document.addEventListener('DOMContentLoaded', function () {
    const redondoLabel = document.getElementById('redondo');
    const sencilloLabel = document.getElementById('sencillo');
    const fechaRegresoContainer = document.getElementById('fecha_regreso_container');
    const radioRedondo = document.getElementById('radio_redondo');
    const radioSencillo = document.getElementById('radio_sencillo');

    function toggleFechaRegreso() {
        if (radioRedondo.checked) {
            fechaRegresoContainer.style.display = "block"; // Mostrar el contenedor
        } else {
            fechaRegresoContainer.style.display = "none"; // Ocultar el contenedor
        }
    }

    function actualizarColores() {
        if (radioRedondo.checked) {
            redondoLabel.style.color = "black";   
            sencilloLabel.style.color = "gray";  
        } else {
            redondoLabel.style.color = "gray";    
            sencilloLabel.style.color = "black";  
        }
    }

    redondoLabel.addEventListener('click', function () {
        radioRedondo.checked = true; 
        redondoLabel.classList.add('selected');
        sencilloLabel.classList.remove('selected');
        actualizarColores();       
        toggleFechaRegreso();
    });

    sencilloLabel.addEventListener('click', function () {
        radioSencillo.checked = true; 
        sencilloLabel.classList.add('selected');
        redondoLabel.classList.remove('selected');
        actualizarColores();         
        toggleFechaRegreso();
    });

    actualizarColores();
    toggleFechaRegreso();
});
