$(document).ready(function () {
    let btn_pago = document.getElementById('pay-button-getnet');
    $("#pay-button-getnet").on("click", function (event) {
        if (!validarFormulariosReservacion()) return false;
        if ($("#condiciones").is(":not(:checked)")) {
            Swal.fire({
                title: 'Advertencia',
                text: "Debe aceptar los términos y condiciones",
                icon: 'warning',
                showCancelButton: false,
            })
        } else {
            setTimeout(() => {
                appGetnet.generarLigaPaGo();
            }, 300);
        }
    });

    $("#debito-tab").on("click", function (event) {
        btn_pago.disabled = true;
    });
    $("#credito-tab").on("click", function (event) {        
        btn_pago.disabled = true;
    });
});


function validarFormulariosReservacion() {
    var mensaje = '';
    var response = true;
    // console.log('aqui')
    var reg = /(\.|\-)/g;

    if ($('#Reservacion_nombre_cliente').val() == '' || $('#Reservacion_apellido_cliente').val() == '') {
        mensaje += 'El Nombre y Apellido del cliente son requeridos. ';
        response = false;
    }
    if ($('#Reservacion_tel_cliente').val() == '') {
        mensaje += 'El Teléfono del cliente es requerido. ';
        response = false;
    }
    if ($('#Reservacion_email').val() == '') {
        mensaje += 'El E-mail del cliente es requerido. ';
        response = false;
    }

    var num_hab = $('#Reservacion_num_habitaciones').val();
    for (var hab = 1; hab <= num_hab; hab++) {
        var num_adultos = $('#num_adultos_' + hab).val();
        for (var i = 1; i <= num_adultos; i++) {
            if ($('#nombre_' + i + '_' + hab).val() == '' || $('#apellido_' + i + '_' + hab).val() == '') {
                mensaje += 'El nombre y apellido de pasajero #' + i + ' son requeridos en habitación:' + hab;
                response = false;
            }
            if (reg.test($('#nombre_' + i + '_' + hab).val()) == true || reg.test($('#apellido_' + i + '_' + hab).val()) == true) {
                mensaje += 'El nombre y/o apellido de pasajero #' + i + ' contiene caracteres no permitidos. habitación:' + hab;
                response = false;
            }
        }
    }

    if ($('#s2_agencias').val() == '' || $('#s2_agentes').val() == '' || $('#nombre_cliente').val() == '' || $('#apellido_cliente').val() == '') {
        mensaje += 'Por favor, complete los campos requeridos.';
        response = false;
    }

    if (reg.test($('#nombre_cliente').val()) == true || reg.test($('#apellido_cliente').val()) == true) {
        mensaje += 'El nombre y/o apellido contiene caracteres no permitidos.';
        response = false;
    }

    if ($('#tel_cliente').val() == '' && $('#ok_elige_transporte').val() == 1) {
        mensaje += 'Datos Adicionales para su transportación son requeridos.';
        response = false;
    }
    var xhr = {
        responseText: 'Formulario Incompleto',
        status: 'Advertencia',
        statusIcon: 'warning'
    }

    if (response === false) {

        sweetError(xhr, mensaje, false);
    }
    return response;
}

function sweetError(xhr, text, reload) {

    var estatusText = xhr.responseText;
    if (!estatusText) {
        estatusText = xhr.statusText;
    }
    var icon = 'error';
    if (xhr.statusIcon) {
        icon = xhr.statusIcon;
    }
    Swal.fire({
        icon: icon,
        title: xhr.status,
        text: text,
        footer: estatusText
    }).then((result) => {
        if (reload === true) {
            location.reload();
        } else if (reload == 'replace') {
            window.location.replace('/sur4agenciasv2/site/index');
        }
    })
}


var appGetnet = new Vue({
    el: '#transaccion_getnet',
    data: {
        baseUrl: baseUrl,
        id_agencia_2b_getnet: id_agencia_2b_getnet,
        pago_pasarela: [],
        liga_pago: [],
        array_transaccion: [],
        estatus_transaccion: "",
        cont: 0,
        pagoMeses: "",
    },
    methods: {
        generarLigaPaGo: function () {
            let btn_pago = document.getElementById('pay-button-getnet')
            btn_pago.disabled = true;
            btn_pago.textContent = 'Procesando...';

            let create_transaccion_getnet = {};
            let datos_create_transaccion = {
                id_agencia: this.id_agencia_2b_getnet,
                tipo_pasarela: 'hoteleria',
                pagoMeses: this.pagoMeses
            }
            create_transaccion_getnet.create_transaction = datos_create_transaccion;

            this.$http.post(baseUrl + "/reservacion/createTransactionGetnet", create_transaccion_getnet).then(function (response) {
                this.pago_pasarela = response.body;
                if (this.pago_pasarela.id_pago) {
                    let update_getnet = {};
                    let datos_update_transaccion = {
                        id_pago: this.pago_pasarela.id_pago,

                    }
                    update_getnet.update_transaction = datos_update_transaccion;

                    this.$http.post(this.baseUrl + "/reservacion/createTransactionGetnet", update_getnet).then(function (response) {
                        this.liga_pago = response.body;
                        if (this.liga_pago.url_pago != null && this.liga_pago.url_pago != '') {

                            btn_pago.hidden = true;
                            const contenedor_iframe_getnet = document.getElementById("contIframeGetnet");
                            const iframe_getnet = document.createElement("iframe");
                            iframe_getnet.setAttribute("src", this.liga_pago.url_pago);
                            iframe_getnet.setAttribute("width", "100%");
                            iframe_getnet.setAttribute("height", "550");
                            iframe_getnet.setAttribute("id", "iframePagoGetnet");
                            iframe_getnet.setAttribute("frameborder", "0");
                            iframe_getnet.setAttribute("scrolling", "no");
                            iframe_getnet.setAttribute("seamless", "seamless");

                            contenedor_iframe_getnet.appendChild(iframe_getnet);
                            contenedor_iframe_getnet.style.height = '600';

                            setTimeout(() => {
                                const iframe_getnet_generado = document.getElementById("iframePagoGetnet");
                                iframe_getnet_generado.style.position = 'static';
                            }, 300);

                            setTimeout(() => {
                                this.getTransaccion();
                            }, 8000);


                        } else {
                            Swal.fire({
                                icon: 'error',
                                title: 'Ha ocurrido un error, intente recarar la página',
                                showConfirmButton: false,
                                timer: 2000
                            })
                        }
                    }, function (ex) {
                        console.log(ex);
                    });
                }
            }, function (ex) {
                console.log(ex);
            });
        },
        saveEstatusRutaMaya: function () {
            let referenciaPago = this.liga_pago.referencia_pago
            this.$http.get(this.baseUrl + "/reservacion/getEstatusGetnetRutamaya?referenciaPago=" + referenciaPago).then(function (response) {
                console.log("enviado");
            }).catch();

        },
        getTransaccion: function () {
            if ((this.liga_pago.estatus_transaccion == "NA")) {
                this.request();
            }

        },
        request: function () {
            setTimeout(() => {
                this.cont++;
                this.$http.get(this.baseUrl + "/reservacion/estatusGetnet?referencia_pago=" + this.liga_pago.referencia_pago)
                    .then(function (response) {
                        this.array_transaccion = response.body;
                        if (this.array_transaccion.estatus_transaccion == "approved") {
                            appGetnet.crearReservacionGetnet();
                            // alert("SE CREA LA RESERVA");

                        } else {
                            if (this.id_agencia_2b_getnet == 10 || this.id_agencia_2b_getnet == 12) {
                                this.saveEstatusRutaMaya();
                            }
                            this.getTransaccion();
                        }
                    })
            }, 10000);
        },

        crearReservacionGetnet: function () {
            datosformulario = $("#reservacion-form").serializeArray();
            var uniquekey = {
                name: "datos",
                value: datosReserva
            };

            datosformulario.push(uniquekey);

            $.ajax({
                url: url_reserva,
                type: "POST",
                data: datosformulario,
                dataType: "JSON",

                success: function (data) {
                    if (data.cupon != null) {
                        appGetnet.datosClientesGetnet(data.cupon);
                    }
                    appGetnet.emailGetnet(data.cupon);
                    appGetnet.sweetReservacionGetnet(data.cupon);
                },
                error: function (xhr) {
                    console.log("ERROR: " + xhr.responseText);
                    sweetError(xhr, "A ocurrido un error al tratar de realizar la reserva", "replace");
                }
            })
        },
        datosClientesGetnet: function (cupon) {
            var paramscliente = new Object();
            paramscliente.id_reservacion = cupon;
            paramscliente.id_agencia = datos_formulario[5].value;
            paramscliente.telefono = $("#Reservacion_tel_cliente").val();
            paramscliente.email = $("#Reservacion_email").val();

            $.ajax({
                url: baseUrl + "/reservacion/datosCliente",
                type: "POST",
                data: paramscliente,
                success: function (data) {
                    convertido = JSON.parse(data);
                    appGetnet.emailClienteGetnet(convertido.id_datos_clientes, cupon);
                }
            })
        },

        emailClienteGetnet: function (id, cupon) {
            var url = url_sur4 + "/solicitudReservacion/enviarEmailCliente/id/" + id;
            $.ajax({
                url: url,
                data: '{id_reservacion:' + cupon + ', email:' + $("#Reservacion_email").val() + ', telefono:' + $("#Reservacion_tel_cliente").val() + ', agencia:' + datos_formulario[5].value + '}',
                type: 'post',
                success: function (e) {
                    console.log("email Enviado al cliente");

                }
            })
        },
        emailGetnet: function (cupon) {
            var params = new Object();
            params.cupon = cupon;
            params.id_agencia = datos_formulario[5].value;
            params.telefono = $("#Reservacion_tel_cliente").val();
            params.correo = $("#Reservacion_email").val();

            $.ajax({
                url: baseUrl + "/reservacion/emailGetnet",
                type: "POST",
                data: params,
            })
        },
        sweetReservacionGetnet: function (cupon) {
            let timerInterval
            Swal.fire({
                title: '!Reservación Creada!',
                text: 'Estamos Redireccionando a su Reservación...',
                timer: 3000,
                timerProgressBar: false,
                imageUrl: 'https://rutamayatravel.com/images/onboarding/pose2-2.png',
                imageWidth: 200,
                imageAlt: 'Reservación creada',
                didOpen: () => {
                    Swal.showLoading()
                    timerInterval = setInterval(() => {
                        const content = Swal.getHtmlContainer()

                        Swal.getTimerLeft()


                    }, 100)
                },
                willClose: () => {
                    clearInterval(timerInterval)
                }
            }).then((result) => {
                if (result.dismiss === Swal.DismissReason.timer) {
                    window.location.replace(baseUrl + '/reservacion/view/id/' + cupon);
                }

            })
        }
    },
});