var datos_formulario = $("#reservacion-form").serializeArray();
var url_reserva = "https://www.rutamayatravel.com/sur4/reservacion/guardarBooking";
var url_sur4 = 'https://www.rutamayatravel.com/sur4';

function crearreservaliga() {
    if (!validarFormularioReservaLiga()) return false;
    if ($("#cboxligapago").is(":not(:checked)")) {
        Swal.fire({
            title: 'Advertencia',
            text: "Debe aceptar los términos y condiciones",
            icon: 'warning',
            showCancelButton: false,
        })
    } else {
        Swal.fire({
            title: 'Al confirmar acepta que los datos de la reserva son correctos.',
            showDenyButton: false,
            showCancelButton: true,
            confirmButtonText: `Confirmar`,
            cancelButtonText: 'Cancelar',
            buttonsStyling: false,
            customClass: {
                confirmButton: 'btn btn-info mr-3',
                cancelButton: 'btn btn-default'
            },
        }).then((result) => {
            /* Read more about isConfirmed, isDenied below */
            if (result.isConfirmed) {

                crearreservacionlinkpago();
                // alert("se creara la reserva");
                //Swal.fire('Saved!', '', 'success')
            } else if (result.isDenied) {
                Swal.fire('Reserva no realizada', '', 'info')
            }
        })
    }
}

function validarFormularioReservaLiga() {
    var mensaje = '';
    var response = true;
    // console.log('aqui')
    var reg = /(\.|\-)/g;

    if ($('#Reservacion_nombre_cliente').val() == '' || $('#Reservacion_apellido_cliente').val() == '') {
        mensaje += 'El Nombre y Apellido del cliente son requeridos. ';
        response = false;
    }
    if ($('#Reservacion_tel_cliente').val() == '') {
        mensaje += 'El Teléfono del cliente es requerido. ';
        response = false;
    }
    if ($('#Reservacion_email').val() == '') {
        mensaje += 'El E-mail del cliente es requerido. ';
        response = false;
    }

    var num_hab = $('#Reservacion_num_habitaciones').val();
    for (var hab = 1; hab <= num_hab; hab++) {
        var num_adultos = $('#num_adultos_' + hab).val();
        for (var i = 1; i <= num_adultos; i++) {
            if ($('#nombre_' + i + '_' + hab).val() == '' || $('#apellido_' + i + '_' + hab).val() == '') {
                mensaje += 'El nombre y apellido de pasajero #' + i + ' son requeridos en habitación:' + hab;
                response = false;
            }
            if (reg.test($('#nombre_' + i + '_' + hab).val()) == true || reg.test($('#apellido_' + i + '_' + hab).val()) == true) {
                mensaje += 'El nombre y/o apellido de pasajero #' + i + ' contiene caracteres no permitidos. habitación:' + hab;
                response = false;
            }
        }
    }

    if ($('#s2_agencias').val() == '' || $('#s2_agentes').val() == '' || $('#nombre_cliente').val() == '' || $('#apellido_cliente').val() == '') {
        mensaje += 'Por favor, complete los campos requeridos.';
        response = false;
    }

    if (reg.test($('#nombre_cliente').val()) == true || reg.test($('#apellido_cliente').val()) == true) {
        mensaje += 'El nombre y/o apellido contiene caracteres no permitidos.';
        response = false;
    }

    if ($('#tel_cliente').val() == '' && $('#ok_elige_transporte').val() == 1) {
        mensaje += 'Datos Adicionales para su transportación son requeridos.';
        response = false;
    }
    var xhr = {
        responseText: 'Formulario Incompleto',
        status: 'Advertencia',
        statusIcon: 'warning'
    }

    if (response === false) {

        sweetError(xhr, mensaje, false);
    }
    return response;
}


function crearreservacionlinkpago() {
    datosformulario = $("#reservacion-form").serializeArray();
    var uniquekey = {
        name: "datos",
        value: datosreserva
    };

    datosformulario.push(uniquekey);

    $.ajax({
        url: url_reserva,
        type: "POST",
        data: datosformulario,
        dataType: "JSON",

        success: function (data) {
            if (data.cupon != null) {
                datosclientelinkpago(data.cupon);
            }
            emaillinkpago(data.cupon);
            sweetReservacion(data.cupon);
            // else {
            //     $("#modal-reservar .modal-body").append("<div class=\'alert alert-danger\'>HUBO UN ERROR AL INTENTAR CREAR SU RESERVACIÓN! FAVOR DE CONTACTAR A RUTA MAYA TRAVEL.</div>");
            // }
        },
        error: function (xhr) {
            console.log("ERROR: " + xhr.responseText);
            sweetError(xhr, "A ocurrido un error al tratar de realizar la reserva", "replace");
        }
    })
}

function datosclientelinkpago(cupon) {
    var paramscliente = new Object();
    paramscliente.id_reservacion = cupon;
    paramscliente.id_agencia = datos_formulario[5].value;
    paramscliente.telefono = $("#Reservacion_tel_cliente").val();
    paramscliente.email = $("#Reservacion_email").val();

    $.ajax({
        url: baseUrl + "/reservacion/datosCliente",
        type: "POST",
        data: paramscliente,
        success: function (data) {
            convertido = JSON.parse(data);
            emailclientelinkpago(convertido.id_datos_clientes, cupon);
        }
    })
}

function emailclientelinkpago(id, cupon) {
    var url = url_sur4 + "/solicitudReservacion/enviarEmailCliente/id/" + id;
    $.ajax({
        url: url,
        data: '{id_reservacion:' + cupon + ', email:' + $("#Reservacion_email").val() + ', telefono:' + $("#Reservacion_tel_cliente").val() + ', agencia:' + datos_formulario[5].value + '}',
        type: 'post',
        success: function (e) {
            console.log("email Enviado al cliente");

        }
    })
}

function emaillinkpago(cupon) {
    console.log("Envia correo de linkpago");
    var params = new Object();
    params.cupon = cupon;
    params.id_agencia = datos_formulario[5].value;
    params.telefono = $("#Reservacion_tel_cliente").val();
    params.correo = $("#Reservacion_email").val();

    $.ajax({
        url: baseUrl + "/reservacion/emaillinkpago",
        type: "POST",
        data: params,
    })
}

function sweetReservacion(cupon) {
    let timerInterval
    Swal.fire({
        title: '!Reservación Creada!',
        text: 'Estamos Redireccionando a su reservación...',
        timer: 3000,
        timerProgressBar: false,
        imageUrl: 'https://rutamayatravel.com/images/onboarding/pose2-2.png',
        imageWidth: 200,
        imageAlt: 'Reservación creada',
        didOpen: () => {
            Swal.showLoading()
            timerInterval = setInterval(() => {
                const content = Swal.getHtmlContainer()

                Swal.getTimerLeft()


            }, 100)
        },
        willClose: () => {
            clearInterval(timerInterval)
        }
    }).then((result) => {
        if (result.dismiss === Swal.DismissReason.timer) {
            window.location.replace(baseUrl + '/reservacion/view/id/' + cupon);
        }

    })
}