// Stripe API Key

// let publicKey = publicKeyStripe;

var stripe = Stripe(publicKeyStripe);
var elements = stripe.elements();
var respuesta = "";
var datos_formulario = $("#reservacion-form").serializeArray();
var url_reserva = "https://www.rutamayatravel.com/sur4/reservacion/guardarBooking";
var url_sur4 = 'https://www.rutamayatravel.com/sur4';
// Custom Styling
var style = {
    base: {
        color: '#32325d',
        lineHeight: '24px',
        fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
        fontSmoothing: 'antialiased',
        fontSize: '16px',
        '::placeholder': {
            color: '#aab7c4'
        }
    },
    invalid: {
        color: '#fa755a',
        iconColor: '#fa755a'
    }
};
// Create an instance of the card Element
var card = elements.create('card', {
    style: style
});

// Add an instance of the card Element into the `card-element` <div>
function montarStripe() {
    card.mount('#card-element');
}
// Handle real-time validation errors from the card Element.
if (card) {
    card.addEventListener('change', function (event) {
        var displayError = document.getElementById('card-errors');
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    });
}

function generarToken() {
    if (!validarFormularioReserva()) return false;
    
    if ($("#cboxstripe").is(":not(:checked)")) {
        Swal.fire({
            title: 'Advertencia',
            text: "Debe aceptar los términos y condiciones",
            icon: 'warning',
            showCancelButton: false,
        })
    } else {
        stripe.createToken(card).then(function (result) {
            if (result.error) {
                // Inform the user if there was an error
                var errorElement = document.getElementById('card-errors');
                errorElement.textContent = result.error.message;
            } else {
                stripeTokenHandler(result.token);
            }
        });
    }


}

function stripeTokenHandler(token) {

    Swal.fire({
        title: 'Espere un momento por favor, estamos procesando su pago.',
        html: '',
        timer: 3000,
        timerProgressBar: true,
        didOpen: () => {
            Swal.showLoading()
        },
    }).then((result) => {
        /* Read more about handling dismissals below */
        if (result.dismiss === Swal.DismissReason.timer) {
            console.log('I was closed by the timer')
        }
    })

    var paramsstripe = new Object();
    paramsstripe.token = token;
    paramsstripe.nomHotel = nomHotel;

    $.ajax({
            url: baseUrl + "/reservacion/stripe",
            type: "POST",
            data: paramsstripe,
        })
        .success(function (response) {
            respuesta = response;
            if (respuesta.estatus == 200) {
                Swal.fire({
                    icon: 'success',
                    title: 'Su pago ha sido procesado correctamente, en un momento se generará la reserva',
                    showConfirmButton: false,
                    timer: 4000
                })

                setTimeout(() => {
                    crearreservacionstripe();
                }, 4000);
            } else if (respuesta.estatus == 400) {
                Swal.fire({
                    icon: 'error',
                    title: "Ha ocurrido un error inesperado",
                    text: "Por favor recargue la página o inténtelo más tarde",
                })
            } else {
                var titulo = "";
                var mensaje = "";
                if (respuesta.error_code == "card_declined") {
                    titulo = "Tarjeta declinada";
                    if (respuesta.decline_code == "insufficient_funds") {
                        mensaje = "Su tarjeta no tiene fondos suficientes";
                    } else if (respuesta.decline_code == "lost_card") {
                        mensaje = "Su tarjeta ha sido reportada como extraviada";
                    } else if (respuesta.decline_code == "stolen_card") {
                        mensaje = "Su tarjeta ha sido reportada como robada";
                    } else {
                        mensaje = "Su tarjeta ha sido rechazada"
                    }
                } else if (respuesta.error_code == "expired_card") {
                    titulo = "Tarjeta expirada";
                    mensaje = "Su tarjeta ha expirado, intente con otra."
                } else if (respuesta.error_code == "incorrect_cvc") {
                    titulo = "Su CVC es incorrecto";
                    mensaje = "Por favor verifique el codigo CVC ingresado"
                } else {
                    titulo = "Ha ocurrido un error";
                    mensaje = "Por favor recargue la pagina o inténtelo más tarde."
                }
                Swal.fire({
                    icon: 'error',
                    title: titulo,
                    text: mensaje,
                })
            }
        })
        .error(function (response) {
            respuesta = response;
            Swal.fire({
                icon: 'error',
                title: "Ha ocurrido un error",
                text: "Por favor recargue la pagina o inténtelo más tarde.",
            })
        })
}


function validarFormularioReserva() {
    var mensaje = '';
    var response = true;
    // console.log('aqui')
    var reg = /(\.|\-)/g;

    if ($('#Reservacion_nombre_cliente').val() == '' || $('#Reservacion_apellido_cliente').val() == '') {
        mensaje += 'El Nombre y Apellido del cliente son requeridos. ';
        response = false;
    }
    if ($('#Reservacion_tel_cliente').val() == '') {
        mensaje += 'El Teléfono del cliente es requerido. ';
        response = false;
    }
    if ($('#Reservacion_email').val() == '') {
        mensaje += 'El E-mail del cliente es requerido. ';
        response = false;
    }

    var num_hab = $('#Reservacion_num_habitaciones').val();
    for (var hab = 1; hab <= num_hab; hab++) {
        var num_adultos = $('#num_adultos_' + hab).val();
        for (var i = 1; i <= num_adultos; i++) {
            if ($('#nombre_' + i + '_' + hab).val() == '' || $('#apellido_' + i + '_' + hab).val() == '') {
                mensaje += 'El nombre y apellido de pasajero #' + i + ' son requeridos en habitación:' + hab;
                response = false;
            }
            if (reg.test($('#nombre_' + i + '_' + hab).val()) == true || reg.test($('#apellido_' + i + '_' + hab).val()) == true) {
                mensaje += 'El nombre y/o apellido de pasajero #' + i + ' contiene caracteres no permitidos. habitación:' + hab;
                response = false;
            }
        }
    }

    if ($('#s2_agencias').val() == '' || $('#s2_agentes').val() == '' || $('#nombre_cliente').val() == '' || $('#apellido_cliente').val() == '') {
        mensaje += 'Por favor, complete los campos requeridos.';
        response = false;
    }

    if (reg.test($('#nombre_cliente').val()) == true || reg.test($('#apellido_cliente').val()) == true) {
        mensaje += 'El nombre y/o apellido contiene caracteres no permitidos.';
        response = false;
    }

    if ($('#tel_cliente').val() == '' && $('#ok_elige_transporte').val() == 1) {
        mensaje += 'Datos Adicionales para su transportación son requeridos.';
        response = false;
    }
    var xhr = {
        responseText: 'Formulario Incompleto',
        status: 'Advertencia',
        statusIcon: 'warning'
    }

    if (response === false) {

        sweetError(xhr, mensaje, false);
    }
    return response;
}


function crearreservacionstripe() {
    datosformulario = $("#reservacion-form").serializeArray();
    var uniquekey = {
        name: "datos",
        value: datosreserva
    };

    datosformulario.push(uniquekey);

    $.ajax({
        url: url_reserva,
        type: "POST",
        data: datosformulario,
        dataType: "JSON",

        success: function (data) {
            if (data.cupon != null) {
                datosclientestripe(data.cupon);
            }
            emailstripe(data.cupon);
            sweetReservacion(data.cupon);
            // else {
            //     $("#modal-reservar .modal-body").append("<div class=\'alert alert-danger\'>HUBO UN ERROR AL INTENTAR CREAR SU RESERVACIÓN! FAVOR DE CONTACTAR A RUTA MAYA TRAVEL.</div>");
            // }
        },
        error: function (xhr) {
            console.log("ERROR: " + xhr.responseText);
            sweetError(xhr, "A ocurrido un error al tratar de realizar la reserva", "replace");
        }
    })
}

function datosclientestripe(cupon) {
    var paramscliente = new Object();
    paramscliente.id_reservacion = cupon;
    paramscliente.id_agencia = datos_formulario[5].value;
    paramscliente.telefono = $("#Reservacion_tel_cliente").val();
    paramscliente.email = $("#Reservacion_email").val();

    $.ajax({
        url: baseUrl + "/reservacion/datosCliente",
        type: "POST",
        data: paramscliente,
        success: function (data) {
            convertido = JSON.parse(data);
            emailclientestripe(convertido.id_datos_clientes, cupon);
        }
    })
}

function emailclientestripe(id, cupon) {
    var url = url_sur4 + "/solicitudReservacion/enviarEmailCliente/id/" + id;
    $.ajax({
        url: url,
        data: '{id_reservacion:' + cupon + ', email:' + $("#Reservacion_email").val() + ', telefono:' + $("#Reservacion_tel_cliente").val() + ', agencia:' + datos_formulario[5].value + '}',
        type: 'post',
        success: function (e) {
            console.log("email Enviado al cliente");

        }
    })
}

function emailstripe(cupon) {
    console.log("Envia correo de stripe");
    var params = new Object();
    params.cupon = cupon;
    params.id_agencia = datos_formulario[5].value;
    params.telefono = $("#Reservacion_tel_cliente").val();
    params.correo = $("#Reservacion_email").val();

    $.ajax({
        url: baseUrl + "/reservacion/emailStripe",
        type: "POST",
        data: params,
    })
}

function sweetReservacion(cupon) {
    let timerInterval
    Swal.fire({
        title: '!Reservación Creada!',
        text: 'Estamos Redireccionando a su reservación...',
        timer: 3000,
        timerProgressBar: false,
        imageUrl: 'https://rutamayatravel.com/images/onboarding/pose2-2.png',
        imageWidth: 200,
        imageAlt: 'Reservación creada',
        didOpen: () => {
            Swal.showLoading()
            timerInterval = setInterval(() => {
                const content = Swal.getHtmlContainer()

                Swal.getTimerLeft()


            }, 100)
        },
        willClose: () => {
            clearInterval(timerInterval)
        }
    }).then((result) => {
        if (result.dismiss === Swal.DismissReason.timer) {
            window.location.replace(baseUrl + '/reservacion/view/id/' + cupon);
        }

    })
}