var app = new Vue({
    el: '#element',
    data: {
        id_agencia: id_agencia,
        baseUrl: baseUrl,
        url_rmt: url_rmt,
        api_url: url_rmt + "/api/",
        info_agencia: [],
        img_pie_flyer: [],
    },
    created: function() {
        this.loadInfoAgencia();
    },
    methods: {
        loadInfoAgencia: function() {
            this.$http.get(this.api_url + 'agenciasRest/' + this.id_agencia).then(function(response) {
                var response_var = response.body;
                this.info_agencia = response_var.data.agenciasRest;
            }, function() {
                console.log('Error');
            });
        },
        loadedImg: function() {
            this.img_pie_flyer = event.target.files[0];
        },
        uploadImg: function() {
            var data = new FormData();
            data.append("id_agencia", this.id_agencia);
            data.append("img", this.img_pie_flyer);
            this.$http.post(this.url_rmt + '/agencias/uploadPieFlyer/', data).then(function(response) {
                var response_var = response.body;
            }, function(e) {
                $("#btnSaveChanges").removeClass("disabled");
                console.log(e);
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Problema al subir la imagen. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        saveChanges: function() {
            $("#btnSaveChanges").addClass("disabled");
            var nombre_img = this.id_agencia + "-" + this.img_pie_flyer.name.replace(/\s+/g, '-');
            var postData = { "pie_flyer": nombre_img };
            this.$http.put(this.api_url + 'agenciasRest/' + this.id_agencia, JSON.stringify(postData)).then(function(response) {
                var response_var = response.body;
                if(response_var.success == "true") {
                    this.uploadImg();
                    Swal.fire({
                        type: 'success',
                        title: "Correcto",
                        text: "Se ha guardado la información",
                    });
                } else {
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response_var.body) + "</pre></code>",
                    });
                }
                $("#btnSaveChanges").removeClass("disabled");
            }, function(e) {
                $("#btnSaveChanges").removeClass("disabled");
                console.log(e);
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(e.body) + "</pre></code>",
                });
            });
        },
        test_method: function() {
            console.log(event.target.value);
        }
    }
});