var app = new Vue({
    el: '#viaticos_actividades',
    data: {
        rmt_url: rmt_url,
        api_url: rmt_url + '/api/',
        actividades: [],
        array_events: [],

        model_id_actividad: 0,
        model_nombre: '',
        model_aportacion_efectivo: null,
        model_aportacion_tarjeta: null,
        model_fecha_inicio: '',
        model_fecha_final: null,
        model_id_evento: null,
        model_id_usuario: id_usuario,
    },
    created: function() {
        this.loadActividades();
        this.loadEvents();
    },
    methods: {
        loadActividades: function() {
            var url = this.api_url + 'viaticosActividades?filter=[{"property":"id_usuario","value":' + this.model_id_usuario +',"operator":=}]';
            this.$http.get(encodeURI(url)).then(function(response) {
                var response_var = response.body.data;
                this.actividades = response_var.viaticosActividades;
            }, function(ex) {
                console.log(ex);
            });
        },
        loadEvents: function() {
            this.$http.get(this.api_url + 'events/').then(function(response) {
                var response_var = response.body.data;
                this.array_events = response_var.events;
            }, function(ex) {
                console.log(ex);
            });
        },
        save: function() {
            if(this.model_id_actividad > 0) {
                this.updateActividad();
            } else {
                this.createActividad();
            }
        },
        createActividad: function() {
            console.log(((this.model_fecha_final.split("/")).reverse()).join("-"));
            var modal = UIkit.modal("#modal_cu");
            var post_data = { nombre: this.model_nombre, aportacion_efectivo: this.model_aportacion_efectivo, aportacion_tarjeta: this.model_aportacion_tarjeta, fecha_inicio: ((this.model_fecha_inicio.split("/")).reverse()).join("-"), fecha_final: ((this.model_fecha_final.split("/")).reverse()).join("-"), id_evento: this.model_id_evento, id_usuario: this.model_id_usuario };
            this.$http.post(this.api_url + 'viaticosActividades/', JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                    modal.hide();
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha creado una nueva actividad.'
                    });
                    this.loadActividades();
                    this.clearModels();
                } else {
                    modal.hide();
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                modal.hide();
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        updateActividad: function() {
            var modal = UIkit.modal("#modal_cu");
            var post_data = { nombre: this.model_nombre, aportacion_efectivo: this.model_aportacion_efectivo, aportacion_tarjeta: this.model_aportacion_tarjeta, fecha_inicio: ((this.model_fecha_inicio.split("/")).reverse()).join("-"), fecha_final: ((this.model_fecha_final.split("/")).reverse()).join("-"), id_evento: this.model_id_evento, id_usuario: this.model_id_usuario };
            this.$http.put(this.api_url + 'viaticosActividades/' + this.model_id_actividad, JSON.stringify(post_data)).then(function(response) {
                var response_var = response.body;
                if(response_var.success) {
                    modal.hide();
                    Swal.fire({
                        type: 'success',
                        title: 'Correcto',
                        text: 'Se ha creado una nueva actividad.'
                    });
                    this.loadActividades();
                    this.clearModels();
                } else {
                    modal.hide();
                    Swal.fire({
                        type: 'error',
                        title: "¡Ops!",
                        html: "Algo salió mal. <pre><code>" + JSON.stringify(response) + "</pre></code>",
                    });
                }
            }, function(ex) {
                modal.hide();
                Swal.fire({
                    type: 'error',
                    title: "¡Ops!",
                    html: "Algo salió mal. <pre><code>" + JSON.stringify(ex) + "</pre></code>",
                });
                console.log(ex);
            });
        },
        getTotalActividad: function(item) {
            var total = 0;
            item.viaticosGastoses.forEach(function(element) {
                total += parseFloat(element.importe);
            });
            return this.round(total, 2);
        },
        setInfoActividad: function(actividad) {
            this.model_id_actividad = actividad.id_actividad;
            this.model_nombre = actividad.nombre;
            this.model_aportacion_efectivo = actividad.aportacion_efectivo;
            this.model_aportacion_tarjeta = actividad.aportacion_tarjeta;
            this.model_fecha_inicio = this.parseDate(actividad.fecha_inicio, "DD/MM/YYYY");
            this.model_fecha_final = this.parseDate(actividad.fecha_final, "DD/MM/YYYY");
            this.model_id_evento = actividad.idEvento.id_event;
        },
        clearModels: function() {
            this.model_id_actividad = 0;
            this.model_nombre = '';
            this.model_aportacion_efectivo = null;
            this.model_aportacion_tarjeta = null;
            this.model_fecha_inicio = '';
            this.model_fecha_final = null;
            this.model_id_evento = null;
        },
        initComponents: function() {
            $("#select_eventos").selectize({
                plugins:{remove_button:{label:""}},
                onDropdownOpen:function(t){
                    t.hide().velocity("slideDown",{begin:function(){t.css({"margin-top":"0"})},duration:200,easing:easing_swiftOut})
                },
                onDropdownClose:function(t){
                    t.show().velocity("slideUp",{complete:function(){t.css({"margin-top":""})},duration:200,easing:easing_swiftOut})
                }
            });
        },
        round: function(value, decimals) {
            return Number(Math.round(value + 'e' + decimals) + 'e-' + decimals).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,');
        },
        parseDate: function(date,format) {
            return moment(date).format(format);
        },
    }
});

var $dp_start = $('#dp_fecha_inicio'), $dp_end = $('#dp_fecha_fin');

var start_date = UIkit.datepicker($dp_start, {
    format:'DD/MM/YYYY',
    i18n: { 
        months:['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'], 
        weekdays:['DOM','LUN','MAR','MIE','JUE','VIE','SAB'] 
    },
});

var end_date = UIkit.datepicker($dp_end, {
    format:'DD/MM/YYYY',
    i18n: { 
        months:['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'], 
        weekdays:['DOM','LUN','MAR','MIE','JUE','VIE','SAB'] 
    },
});

$dp_start.on('change',function() {
    end_date.options.minDate = $dp_start.val();
    setTimeout(function() {
        $dp_end.focus();
    },300);
});

$('body').on('change', '#dp_fecha_inicio', function() {
    app.model_fecha_inicio = $(this).val();
});

$('body').on('change', '#dp_fecha_fin', function() {
    app.model_fecha_final = $(this).val();
});