<?php
// include dirname(__FILE__) . DIRECTORY_SEPARATOR . '../../../protected/config/config.php';
include 'config.php';
// Set the path of Bootstrap to be the root of the project.
//Yii::setPathOfAlias('bootstrap', realpath(dirname(__FILE__).'/../../../'));

$config = array(
	'basePath' => realpath(dirname(__FILE__) . '/..'),
	'name' => 'Reservaciones Ruta Maya Travel',
	'language' => 'es',
	'sourceLanguage' => 'en',
	'charset' => 'UTF-8',

	'preload' => array(
		'bootstrap',
		'log',
	),

	'import' => array(
		'application.models.*',
		'application.components.*',
		'application.modules.user.models.*',
		'application.modules.user.components.*',
	),

	'modules' => array(
		'gii' => array(
			'class' => 'system.gii.GiiModule',
			'password' => 'pass',
			'ipFilters' => false,
			'generatorPaths' => array('bootstrap.gii'),
		),
		'user' => array(
			# encrypting method (php hash function)
			'hash' => 'md5',
			# send activation email
			'sendActivationMail' => false,
			# allow access for non-activated users
			'loginNotActiv' => true,
			# activate user on registration (only sendActivationMail = false)
			'activeAfterRegister' => true,
			# automatically login from registration
			'autoLogin' => true,
			# registration path
			'registrationUrl' => array('/user/registration'),
			# recovery password path
			'recoveryUrl' => array('/user/recovery'),
			# login form path
			'loginUrl' => array('/user/login'),
			# page after login
			#'returnUrl' => array('/user/profile'),
			'returnUrl' => array('/index'),
			# page after logout
			'returnLogoutUrl' => array('/user/login'),
		),
		'erp',
		'casateconmigo'
	),

	'aliases' => array(
		'RestfullYii' => realpath(__DIR__ . '/../extensions/starship/RestfullYii'),
	),

	'components' => array(

		'session' => array(
			'timeout' => 3600,
		),
		'bootstrap' => array(
			'class' => 'ext.bootstrap.components.Bootstrap',
			'responsiveCss' => false,
		),
		'zip' => array(
			'class' => 'application.extensions.zip.EZip',
		),
		'user' => array(
			// enable cookie-based authentication
			'class' => 'WebUser',
			'allowAutoLogin' => true,
			'loginUrl' => array('/user/login'),
		),
		//RUTA MAYA TRAVEL
		'db' => array(
			// 'connectionString' => 'mysql:host=localhost;dbname=rutamaya_outlet',
			// 'connectionString' => 'mysql:host=rutamayatravel.com;dbname=rutamaya_sur45',
			
			'connectionString' => 'mysql:host=' . $db_hostRMT . ';dbname=' . $db_nameRMT,
			'emulatePrepare' => true,
			'username' => $db_usernameRMT,
			'password' => $db_passwordRMT,
			'charset' => 'utf8',
			'tablePrefix' => 'tbl_',
		),
		//panel antiguo
		'db2' => array(
			'class' => 'CDbConnection',
			'connectionString' => 'mysql:host=' . $db_host . ';dbname=' . $db_name,
			'emulatePrepare' => false,
			'username' => $db_username,
			'password' => $db_password,
			'charset' => 'utf8',
		),
		//panel nuevo
		'db3' => array(
			'class' => 'CDbConnection',
			'connectionString' => 'mysql:host=' . $db_host . ';dbname=' . $db_name_panelnuevo,
			'emulatePrepare' => false,
			'username' => $db_username,
			'password' => $db_password,
			'charset' => 'utf8',
		),
		'authManager' => array(
			'class' => 'CDbAuthManager',
			'connectionID' => 'db',
		),
		'errorHandler' => array(
			'errorAction' => 'site/error',
		),
		'fb' => array(
			'class' => 'ext.facebook.components.FacebookConnect',
			'appID' => '',
			'appNamespace' => 'yii-bootstrap',
		),
		'log' => array(
			'class' => 'CLogRouter',
			'routes' => array(
				array(
					'class' => 'CFileLogRoute',
					'levels' => 'error, warning',
				),
			),
		),
		'ePdf' => array(
			'class'         => 'ext.yii-pdf.EYiiPdf',
			'params'        => array(
				'mpdf'     => array(
					'librarySourcePath' => 'application.vendors.mpdf.*',
					'constants'         => array(
						'_MPDF_TEMP_PATH' => Yii::getPathOfAlias('application.runtime'),
					),
					'class' => 'mpdf', // the literal class filename to be loaded from the vendors folder
					'defaultParams'     => array( // More info: http://mpdf1.com/manual/index.php?tid=184
						'mode'              => '', //  This parameter specifies the mode of the new document.
						'format'            => 'letter', // format A4, A5, ...
						//'default_font_size' => 0, // Sets the default document font size in points (pt)
						//'default_font'      => '', // Sets the default font-family for the new document.
						'mgl'               => 15, // margin_left. Sets the page margins for the new document.
						'mgr'               => 15, // margin_right
						'mgt'               => 16, // margin_top
						'mgb'               => 16, // margin_bottom
						'mgh'               => 9, // margin_header
						'mgf'               => 9, // margin_footer
						'orientation'       => 'P', // landscape or portrait orientation
					)
				),
			),
		),
		'urlManager' => array(
			'showScriptName' => false,
			'urlFormat' => 'path',
			'urlSuffix' => '.html',
			/*'rules'=>array(
				'<controller:\w+>/<id:\d+>'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>'=>'<controller>/<action>',
				'<controller:\w+>/<id:\d+>.html'=>'<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>.html'=>'<controller>/<action>',
				'<controller:\w+>/<action:\w+>.html'=>'<controller>/<action>',
				'index'=>'site/index',
				'setup'=>'site/setup',
			),*/
			'rules' => array(
				'api/<controller:\w+>' => array('<controller>/REST.GET', 'verb' => 'GET'),
				'api/<controller:\w+>/<id:\w*>' => array('<controller>/REST.GET', 'verb' => 'GET'),
				'api/<controller:\w+>/<id:\w*>/<param1:\w*>' => array('<controller>/REST.GET', 'verb' => 'GET'),
				'api/<controller:\w+>/<id:\w*>/<param1:\w*>/<param2:\w*>' => array('<controller>/REST.GET', 'verb' => 'GET'),
				array('<controller>/REST.PUT', 'pattern' => 'api/<controller:\w+>/<id:\w*>', 'verb' => 'PUT'),
				array('<controller>/REST.PUT', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>', 'verb' => 'PUT'),
				array('<controller>/REST.PUT', 'pattern' => 'api/<controller:\w*>/<id:\w*>/<param1:\w*>/<param2:\w*>', 'verb' => 'PUT'),
				array('<controller>/REST.DELETE', 'pattern' => 'api/<controller:\w+>/<id:\w*>', 'verb' => 'DELETE'),
				array('<controller>/REST.DELETE', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>', 'verb' => 'DELETE'),
				array('<controller>/REST.DELETE', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>/<param2:\w*>', 'verb' => 'DELETE'),
				array('<controller>/REST.POST', 'pattern' => 'api/<controller:\w+>', 'verb' => 'POST'),
				array('<controller>/REST.POST', 'pattern' => 'api/<controller:\w+>/<id:\w+>', 'verb' => 'POST'),
				array('<controller>/REST.POST', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>', 'verb' => 'POST'),
				array('<controller>/REST.POST', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>/<param2:\w*>', 'verb' => 'POST'),
				array('<controller>/REST.OPTIONS', 'pattern' => 'api/<controller:\w+>', 'verb' => 'OPTIONS'),
				array('<controller>/REST.OPTIONS', 'pattern' => 'api/<controller:\w+>/<id:\w+>', 'verb' => 'OPTIONS'),
				array('<controller>/REST.OPTIONS', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>', 'verb' => 'OPTIONS'),
				array('<controller>/REST.OPTIONS', 'pattern' => 'api/<controller:\w+>/<id:\w*>/<param1:\w*>/<param2:\w*>', 'verb' => 'OPTIONS'),
				'<controller:\w+>/<id:\d+>' => '<controller>/view',
				'<controller:\w+>/<action:\w+>/<id:\d+>' => '<controller>/<action>',
				'<controller:\w+>/<action:\w+>' => '<controller>/<action>',
				'index' => 'site/index',
			),
		),
	),

	// Application-level parameters
	'params' => array(
		'appTitle' => 'UVAC ONLINE',
		'adminEmail' => 'UVAC <it@uvaconline.com>',

		'appDescription' => 'Sistema de Reservaciones - UVAC ONLINE',
	),
);

return file_exists(dirname(__FILE__) . '/local.php')
	? CMap::mergeArray($config, require('local.php'))
	: $config;
