<?php
//antes del cambio en el tiempo de carga
Yii::import('application.extensions.bootstrap.gii.*');
$_SESSION["timeTS"]=date("Y-m-d his");
require_once('../api/travelsolution/TravelSolution.php');
require_once('../api/beds/HotelApi.php');
class ApitarifasController extends Controller
{
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	public function accessRules()
	{
		return array(
			array('allow',
				'actions'=>array('error','avail','index','cotizador','hotelesFotos'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array(''),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/* CONSULTA DE TARIFAS
	Metodo para consultar las tarifas de los hoteles del sistema local
	*/
	public function actionAvail() {
		if(isset($_GET)){ 
			$tarifa= new Tarifa;
			$cadena= new CadenaHotel;
			$zonas= new Zonasbeds;
			$hotel= new Hoteles;
			$session=new CHttpSession;
			$session->open();
			// $this->iniciarSesion();
			$dividir = explode('RMTU',$_GET['uss']);
			$user = explode('A',$dividir[1]);
			$agencia = Agencias::model()->findByPk($user[1]);
			$usuario = Usuarios::model()->findByPk($user[0]);
			$profile = Profiles::model()->findByPk($user[0]);
			$fecha_inicial=implode("-", array_reverse( explode("/", $_GET["fecha_entrada"]) ) );								
			$fecha_final=implode("-", array_reverse( explode("/", $_GET["fecha_salida"]) ) );
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$hora = "and curtime() between hora_inicio and hora_final";
			$early_booking = "and (early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
			$tipo_precio="";
			$tipo_plan="";
			$proveedor="";
			$categoria="";
			$solo_adultos="";
			$datetime1=new DateTime($fecha_inicial);
			$datetime2=new DateTime($fecha_final);
			$interval = $datetime1->diff($datetime2);
			$noches= $interval->format('%a');
			unset($_SESSION['data']);

			$busquedaController = Yii::app()->createController('busqueda');
            $busquedaController = $busquedaController[0];
            $riuController = Yii::app()->createController('riu');
            $riuController = $riuController[0];
            $palaceController = Yii::app()->createController('palace');
            $palaceController = $palaceController[0];
            $habitacionesRQ = array();

        	if (empty($_SESSION['loginRiu'])) {
        		$_SESSION['loginRiu']=$riuController->login();
        	}

			//ALMACENA VARIABLES DE BUSQUEDA EN SESSION FRONT_FORM PAX
			$cuartos=array();
			$front_form = array();
			if(!empty($_GET['habs'])) {
				if(!empty($_SESSION['front_form'])){
					unset($_SESSION['front_form']);
					unset($_SESSION['cuartosParaRatesKeys']);
					$_SESSION['info_search'] = array();
				}
				
				$habs = $_GET['habs'];
				$front_form['habs'] = $habs;
				$front_form['solo_adultos']="";
				
				for($i=1;$i<=$habs;$i++) {
					if(!empty($_GET['habitacion_'.$i]['adultos'])) {
						$adultos = $_GET['habitacion_'.$i]['adultos'];
						$front_form['habitacion_'.$i]['adultos'] = $adultos;
						$_SESSION['info_search']['habitaciones'][$i]['adultos'] = $adultos;
						$cuarto="1~".$front_form['habitacion_'.$i]['adultos']."~";//PARA RATEKEYS
					}
					$num_ninios = $_GET['habitacion_'.$i]['num_ninios'];
					$front_form['habitacion_'.$i]['num_ninios'] = $num_ninios;
					$_SESSION['info_search']['habitaciones'][$i]['no_menores'] = $num_ninios;
					$cuarto.=$front_form['habitacion_'.$i]['num_ninios']."|";//PARA RATEKEYS
					if(!empty($num_ninios)) {
						$edadesArray = array();
						for($j=1;$j<=$num_ninios;$j++) {
							if(isset($_GET['habitacion_'.$i]['edad_'.$j])) {
								$edad = $_GET['habitacion_'.$i]['edad_'.$j];
								$front_form['habitacion_'.$i]['edad_'.$j] = $edad;
								if($num_ninios > 0) {
									array_push($edadesArray, $edad);
								}

								$cuarto.=$front_form['habitacion_'.$i]['edad_'.$j]."~";//PARA RATEKEYS
								$front_form['solo_adultos']="SOLOADULTOS";
								// echo $front_form['habitacion_'.$i]['edad_'.$j];						
							}
						}
						rsort($edadesArray);
						$_SESSION['info_search']['habitaciones'][$i]['menores'] = $edadesArray;
					}
					$front_form['info_search']=$_SESSION['info_search']['habitaciones'];
					
					if($front_form['habitacion_'.$i]['num_ninios'])
          	  			$cuarto=substr($cuarto,0,-1);//PARA RATKEYS

        			array_push($cuartos,$cuarto);//PARA RATEKEYS

				}

				$_SESSION['cuartosParaRatesKeys']=$busquedaController->agrupaCantidad($cuartos); //PARA RATES KEYS
				$front_form['cuartosParaRatesKeys'] = $busquedaController->agrupaCantidad($cuartos);
			}		    

			$front_form['fecha_ini'] = $_GET['fecha_entrada'];
			$front_form['fecha_fin'] = $_GET['fecha_salida'];

			$_SESSION['info_search']['entrada'] = $_GET['fecha_entrada'];
			$_SESSION['info_search']['salida'] = $_GET['fecha_salida'];

			$habitaciones = $front_form['habs'];

			//cuando recibas el destino identificar el tipo de destino.
			if(!empty($_GET["destino"])) {
				$front_form['destino'] = $_GET["destino"];
				$destino = explode('_',$_GET["destino"]);
				if($destino[0] == 'd')
				{
					$id_destino = $destino[1];
				}else if($destino[0] == 'c'){
					$id_cadena = $destino[1];
				}else if($destino[0] == 'h')
				{
					$id_hotel = $destino[1];

				}else if($destino[0] == 'z'){
					$id_zona = $destino[1];
				}
				
				$cadena->id = $id_cadena;
				$hotel->id_hotel = $id_hotel;
			}

			if($front_form['solo_adultos']!="")
			{			
				$solo_adultos='AND solo_adultos=0';
			}

			if (isset($_GET['nombre_hotel']) && !empty($_GET['nombre_hotel'])) {
				$nombreHotel=" AND nombre_hotel LIKE '%".$_GET['nombre_hotel']."%' ";
			}else{
				$nombreHotel=""; 
			}

			$proveedor='and proveedor NOT IN (1,3)';

			if($_GET['tipoPrecio'])
			{
				$front_form['tipoPrecio'] = $_GET['tipoPrecio'];
	    		$tipoPrecio = array('OUTLET');
	    		//$tipoPrecio = array('OUTLETGRUPOS');
				$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
				$proveedor = 'and proveedor=0';
			} else {
				$front_form['tipoPrecio'] = "";
				//$tipoPrecio = array('OUTLET','PROMO','NORMAL','VIP','OUTLETGRUPOS');
				$tipoPrecio = array('OUTLET','PROMO','NORMAL','VIP');
			}

			if(!empty($_GET['Tarifa']['id_tipo_plan'])) { 
				$planHotel=Plan::model()->findByPk($_GET['Tarifa']['id_tipo_plan']);
				$front_form['tipoPlan'] = $planHotel;
				$front_form['id_tipoPlan'] = $front_form['tipoPlan']->id_plan; 
				$tipo_plan = 'and t.id_tipo_plan="'.$front_form['tipoPlan']->id_plan.'"';
				$tarifa->id_tipo_plan=$_GET['Tarifa']['id_tipo_plan'];
			} else {
				$front_form['tipoPlan']=null;
				$front_form['id_tipoPlan']=null;
			}

			$estrellas=array();
			if(!empty($_GET["Hoteles"]["id_categoria"])) {
				$hotel->id_categoria = $_GET["Hoteles"]["id_categoria"];
				$front_form['categoria'] = $_GET["Hoteles"]["id_categoria"];
				foreach ($_GET["Hoteles"]["id_categoria"] as $star) {
					$estrellas[]=$star;
				}
				$categoria=" and tarifaHotel.id_categoria IN (".implode(", ", $estrellas).")";
			} else {
				$front_form['categoria'] = null;
			}

			if(isset($_GET['ORDER_PRECIO'])) {
				$ORDER_PRECIO = $_GET['ORDER_PRECIO'];
			} else {
				$ORDER_PRECIO = "ASC";
			}

			$front_form['agenciaUsuario'] = $usuario->id_agencia;
			$front_form['estadoUsuario'] = $agencia->id_estado_agencia;
		
			if(!empty($id_hotel)) {
				$noresults = 0;
				$hoteles=Hoteles::model()->findAll('id_hotel='.$id_hotel.' and estatus=1 and no_listar = 1');
				$rowscount = count($hoteles);
			}
			else if(!empty($id_destino)) {
				$noresults = 0;
				$zonas=Zonasbeds::model()->findAll('destinationsCode="'.$id_destino.'"');
				foreach ($zonas as $zona) {
					$listazonas.=$zona->idZona.',';					
				}
				$listazonas=substr($listazonas, 0, -1);
				$hoteles=Hoteles::model()->findAll(array('condition'=>'id_destino IN('.$listazonas.') and estatus=1 and no_listar = 1 '.$proveedor.' '.$solo_adultos.$nombreHotel));
				$rowscount = count($hoteles);
			}
			else if(!empty($id_cadena)) {
				$noresults = 0;
				$hoteles=Hoteles::model()->findAll(array('condition'=>'id_cadena='.$id_cadena.' and estatus=1 and no_listar = 1 '.$proveedor.' '.$solo_adultos.$nombreHotel));
				$rowscount = count($hoteles);				
			}
			else if(!empty($id_zona)) {
				$noresults = 0;
				$hoteles=Hoteles::model()->findAll(array('condition'=>'id_destino='.$id_zona.' and estatus=1 and no_listar = 1 '.$proveedor.' '.$solo_adultos.$nombreHotel));
				$rowscount = count($hoteles);
			}

			$i=0;
			$countHotels = count($hoteles);
			foreach($hoteles as $killing => $row) {
        		switch ($row->proveedor) {
        			case '0':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				if ($countHotels==1) {
        					$hotelesRQ = (object) $hotelesRQ;
        				}
        				break;
        			case '1':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			case '2':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			case '3':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			case '4':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			case '5':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			case '6':
        				$hotelesRQ[$row->proveedor]["proveedor"]=$row->proveedor;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["id_hotel"]=$row->id_hotel;
        				$hotelesRQ[$row->proveedor]["hoteles"][$row->id_hotel]["codigo"]=$row->codigo;
        				break;
        			default:
        				break;
        		}
        		$i++;
        	}
        
			$front_form['agencia'] = $agencia;
			$front_form['tipoUsuario'] = $profile->tipo;

			//sirve para mostrar el error en el return, 0 es via sistema e ignora los errores del try catch, 1 es via postman y muestra el error en el return
			$front_form['request_url'] = 0;

			$habitacionesRQ = array(
				'fecha_inicial'=>$fecha_inicial,
				'fecha_final'=>$fecha_final,
				'fecha_promo'=>$fecha_promo,
				'hora'=>$hora,
				'early_booking'=>$early_booking,
				'noches'=>$noches,
				'habitaciones'=>$habitaciones,
				'proveedor'=>$proveedor,
				'categoria'=>$categoria,
				'tipo_precio'=>$tipo_precio,
				'tipo_plan'=>$tipo_plan,
				'ORDER_PRECIO'=>$ORDER_PRECIO,
				'rowscount'=>$rowscount,
				'noresults'=>$noresults,
				'filtro_disponibilidad'=>1,
				'hotel'=>$hotel,
				'tarifa'=>$tarifa,
				'totalHoteles'=>count($hoteles),
			);

			$_SESSION["resultadoBusquedaHoteles"] = $habitacionesRQ;
			$_SESSION['front_form'] = $front_form;

			if (is_array($hotelesRQ)) {
   				$hotelesRQ = (object) $hotelesRQ;
			}

			$resultTarifas = array();

			$resultTarifasJSON = $this->TarifasWs(json_encode($hotelesRQ), json_encode($habitacionesRQ), json_encode($front_form));
			// echo $resultTarifasJSON;
			$resultTarifasJSONWs = iconv("Windows-1252","UTF-8", $resultTarifasJSON);
			if ($resultTarifasJSONWs==null) {
				$resultTarifasJSONWs = mb_convert_encoding($resultTarifasJSON,"HTML-ENTITIES", "UTF-8");
			}
			$resultTarifas = json_decode($resultTarifasJSONWs,true);

			echo json_encode($resultTarifas);	
		}
	}

	

	public function TarifasWs($hoteles, $habitaciones, $front_form) {
		//header("Content-Type: text/html;charset=utf-8");
		$ch = curl_init();
		$urlWS = 'http://www.rutamayatravel.com/sur4/getTarifas/ObtenerTarifas';
		// $urlWS = 'http://'.$_SERVER["SERVER_NAME"].Yii::app()->request->baseUrl.'/getTarifas/ObtenerTarifas';
		//curl_setopt($ch, CURLOPT_URL, "https://apituristico.com/TarifasWebServiceRMT/ServicioWebRMT.asmx/TarifaPorProveedorSinBusqueda");
		curl_setopt($ch, CURLOPT_REFERER, utf8_decode("https://test.apituristico.com/TarifasWebServiceRMT/ServicioWebRMT.asmx/TarifaPorProveedorSinBusqueda"));
		curl_setopt($ch, CURLOPT_URL, "https://test.apituristico.com/TarifasWebServiceRMT/ServicioWebRMT.asmx/TarifaPorProveedorSinBusqueda");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, TRUE);
		curl_setopt($ch, CURLOPT_POST, TRUE);
		curl_setopt($ch, CURLOPT_POSTFIELDS, "habitacionesRQ=".$habitaciones."&hotelesRQ=".$hoteles."&front_form=".$front_form."&URL=".$urlWS."");
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		$response = curl_exec($ch);

		curl_close($ch);
		return $response;
	}

	public function actionCotizador($uss,$callback){
		header('Access-Control-Allow-Origin: *');
		$dividir = explode('RMTU',$uss);
		$user = explode('A',$dividir[1]);
		$usuario=Usuarios::model()->findByPk($user[0]);
		$agencia=Agencias::model()->find('id_agencia='.$user[1].' AND accesows=1');
		$countries = Countries::model()->findAll(); 
		if (count($agencia)==1) {
			$this->renderPartial('cotizador', array(
			'countries'=>$countries,'usuario'=>$usuario,'agencia'=>$agencia,'uss'=>$uss,'callback'=>$callback));
		}else{
			echo 'La agencia no tiene permisos para acceder al cotizador';
		}
	}

	public function actionIndex(){
		$this->render('index');
	}

	public function actionHotelesFotos($hotel){
		header('Access-Control-Allow-Origin: *');
		if ($_GET) {
			$hotel = Hoteles::model()->findByPk($_GET['hotel']);

			$fotosHotel = array();
			$fotosHotel['Hotel'] = $hotel->nombre_hotel;
			if ($hotel->proveedor != 3) {
				$fotos = HotelesFotos::model()->findAll('id_hotel='.$hotel->id_hotel);

				switch ($hotel->proveedor) {
					case 1:
					$rutaImage = 'https://photos.hotelbeds.com/giata/';
					break;
					case 2:
					case 5:
					$rutaImage = '';
					break;
					case 0:
					case 4:
					case 6:
					$rutaImage = 'https://www.rutamayatravel.com/imagenes/';
					break;
				}

				$rutaLogotipo = 'https://www.rutamayatravel.com/imagenes/';

				foreach ($fotos as $k => $photo) {

					if ($photo->logotipo==0) {
						# code...
						$fotosHotel['images'][$k]['codigo'] = $photo->id_foto;
						$fotosHotel['images'][$k]['foto'] = $rutaImage.$photo->foto;
					}

					if ($photo->logotipo==1) {
						$fotosHotel['logotipo']['codigo'] = $photo->id_foto;
						$fotosHotel['logotipo']['foto'] = $rutaLogotipo.$photo->foto;
					}
				}
			}else{
				$fotos = HotelesFotos::model()->findAll('id_hotel='.$hotel->id_hotel.' AND logotipo=1');
				
				if (count($fotos)>0) {
					$fotosHotel['logotipo']['codigo'] = $fotos[0]->id_foto;
					$fotosHotel['logotipo']['foto'] = $rutaLogotipo.$fotos[0]->foto;
				}
				$fotosHotel['images'] = $this->getImagesDo($hotel->codigo);
			}

			echo json_encode($fotosHotel);
		}else{
			echo "No tienes permiso para usar la webservice";
		}
	}


	public function getImagesDo($codigo){
		$travelSolution = new TravelSolution;
		$clave_afiliado=$travelSolution->affiliateId;
		$idHotel = explode('/',$codigo);
		$hotelDoRequest = array();
		$hotelDo = $idHotel[0];
		$ip="MX";
		$currency="PE";
		$lenguage="esp";

		$request = "a=".$clave_afiliado."&ip=".$_SERVER["REMOTE_ADDR"]."&c=".$currency."&l=".$lenguage."&h=".$hotelDo."&hash=hf:true;hg:true";
		$response=$travelSolution->getHotelInformation($request);

		$responseDo = json_decode($response);
		$i=0;

		if (!is_null($responseDo)) {
				# code...
				$hotelInformation = $responseDo->Hotel->Galleries;

				foreach ($hotelInformation->Image as $key) {
					if (!empty($key->URL)) {
						$hotelDoRequest[$i]['codigo']=$responseDo->Hotel->Id;;
						$hotelDoRequest[$i]["foto"]=$key->URL;
						$i++;
					}
				} 

		}

		return $hotelDoRequest;
	}

}