<?php

class BloqueosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	//public $layout='//layouts/column1';
	public $layout = '//layouts/ansonika_site';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getLista','getNoDisponibles'),
				'users' => array('*'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'getBloqueo', 'getDetailBloqueo', 'apartarHabitacion', 'getRoomingList', 'getGrupos'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */

	public function actionGetGrupos($id_agencia) {
		$gruposArray=array();
		if($id_agencia == 9) {
			$grupos = Bloqueos::model()->findAll("tipo = 'GRUPAL' ORDER BY fecha_creacion DESC");
		} else {
			$grupos = Bloqueos::model()->findAll("tipo = 'GRUPAL' AND id_agencia = ". $id_agencia ." ORDER BY fecha_creacion DESC");
		}
		foreach ($grupos as $key => $value) {
			$hotel = Hoteles::model()->findByPk($value->id_hotel);
			$fotos_hotel = HotelesFotos::model()->findAll("id_hotel = ". $value->id_hotel);
			array_push($gruposArray, array(
				"info" => $value,
				"hotel" => $hotel,
				"fotos" => $fotos_hotel,
			));
			/*$gruposArray[$key]['grupo'] = $value;
			$gruposArray[$key]['idHotel'] = $hotel;
			$gruposArray[$key]['hotelesFotoses'] = $fotos_hotel;*/
		}
		echo CJSON::encode($gruposArray);
	}
	
	public function actionView($id)
	{
		$model = $this->loadModel($id);
	
		$rooms = Roominglist::model()->findAll('id_bloqueo=' . $id . ' and id_agencia IS NULL ');
		$disponibles = count($rooms);
		$this->render('view', array(
			'model' => $model, 'disponibles' => $disponibles
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model = new Bloqueos;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Bloqueos'])) {
			$model->attributes = $_POST['Bloqueos'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_bloqueo));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['Bloqueos'])) {
			$model->attributes = $_POST['Bloqueos'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_bloqueo));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$this->render('index');
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Bloqueos('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['Bloqueos']))
			$model->attributes = $_GET['Bloqueos'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Bloqueos::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'bloqueos-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}

	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['Bloqueos_records'])) {
			$model = $session['Bloqueos_records'];
		} else
			$model = Bloqueos::model()->findAll();

		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}

	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['Bloqueos_records'])) {
			$model = $session['Bloqueos_records'];
		} else
			$model = Bloqueos::model()->findAll();

		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Bloqueos Report');
		$pdf->SetSubject('Bloqueos Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Bloqueos_002.pdf", "I");
	}

	public function actionGetDetailBloqueo($id)
	{
		$array_bloqueo = array();
		$array_bloqueo["info_bloqueo"] = Bloqueos::model()->findByPk($id);


		$model_hotel = Hoteles::model()->findByPk($array_bloqueo["info_bloqueo"]->id_hotel);
		$model_destino = Destinos::model()->findByPk($model_hotel->id_destinoLocal);


		$array_bloqueo["info_adicional"]["nombre_hotel"] = $model_hotel->nombre_hotel;
		$array_bloqueo["info_adicional"]["descripcion_hotel"] = $model_hotel->observaciones;
		$array_bloqueo["info_adicional"]["tipo_habitacion"] = TipoHabitaciones::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_habitacion)->descripcion;
		$array_bloqueo["info_adicional"]["plan"] = Plan::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tipo_plan)->nombre;
		$array_bloqueo["info_adicional"]["destino_hotel"] = $model_destino->destino;
		$array_bloqueo["info_adicional"]["fotos"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel);
		$array_bloqueo["info_adicional"]["foto_principal"] = HotelesFotos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and principal=1');
		$array_bloqueo["info_adicional"]["estrellas_hotel"] = $model_hotel->estrellas;
		$array_bloqueo["info_adicional"]["videos_hotel"] = HotelesVideos::model()->findAll("id_hotel = " . $array_bloqueo["info_bloqueo"]->id_hotel . ' and estatus=1');

		//$array_bloqueo["tarifa_bloqueo"] = Tarifa::model()->findByPk($array_bloqueo["info_bloqueo"]->id_tarifa);
		$array_bloqueo["tarifa_desglose"] = TarifaDesglose::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa);
		$array_bloqueo["politicas"] = GruposPoliticasPagos::model()->find("id_bloqueo = " . $array_bloqueo["info_bloqueo"]->id_bloqueo);



		
		if($_GET['id_agencia'] == 9){
			
			$array_bloqueo["rooming_list"] = Roominglist::model()->findAll("id_bloqueo = " . $array_bloqueo["info_bloqueo"]->id_bloqueo);
		}else{
			$array_bloqueo["rooming_list"] = Roominglist::model()->findAll('id_bloqueo = ' . $array_bloqueo["info_bloqueo"]->id_bloqueo .' and id_agencia = ' .$_GET['id_agencia'] );		
		}
			


		$array_bloqueo["desgloseMenores"] = DesgloseMenores::model()->findAll("id_tarifa = " . $array_bloqueo["info_bloqueo"]->id_tarifa);





		echo CJSON::encode($array_bloqueo);
	}
	// public function actionGetRoomingRMT($id){
	// 	$array_roomingList = array();
	// 	$model_bloqueos = Bloqueos::model()->findByPk($id);

	// 	if($_GET['id_agencia'] != "9"){
	// 		$model_roomingList = Roominglist::model()->findAll('id_bloqueo = ' . $model_bloqueos->id_bloqueo .' and id_agencia = ' .$_GET['id_agencia'] );
			
	// 	}else if($_GET['id_agencia'] == "9"){
	// 		$model_roomingList = Roominglist::model()->findAll("id_bloqueo = " . $model_bloqueos->id_bloqueo);
	// 	}

	// 	foreach($model_roomingList as $key=>$data){
	// 		array_push($array_roomingList, array(
	// 			"id_roominglist" => $data->id_roominglist,
	// 			"habitacion" => $data->habitacion,
	// 			"id_bloqueo" => $data->id_bloqueo,
	// 			"id_agencia" => $data->id_agencia,
	// 			"nombre" => $data->nombre,
	// 			"menor" => $data->menor,
	// 			"edad" => $data->edad,
	// 			"id_base_habitacion" => $data->id_base_habitacion,
	// 			"fecha_inicio" => $data->fecha_inicio,
	// 			"fecha_final" => $data->fecha_final,
	// 			"noches" => $data->noches,
	// 			"id_reservacion" => $data->id_reservacion,
	// 			"anticipo" => $data->anticipo,
	// 			"importe" => $data->importe,
	// 			"fecha_apartado" => $data->fecha_apartado,
	// 			"fecha_limite" => $data->fecha_limite,
	// 			"estatus" => $data->estatus,
	// 			"observaciones" => $data->observaciones,
	// 			"confirmado" => $data->confirmado
				
	// 		));
	// 	}

	// 	echo CJSON::encode($array_roomingList);
		
	// }
	public function actionGetRoomingList($id)
	{
		$criteria = new CDbCriteria;
		$criteria->condition = 'id_bloqueo=' . $id . ' and id_agencia=' . $_POST['id_agencia'];

		$model = Roominglist::model()->findAll($criteria);
		echo CJSON::encode($model);
	}
	public function actionApartarHabitacion($id)
	{
		$habs = $_POST['habitaciones'];
		$criteria = new CDbCriteria;
		$criteria->condition = 'id_bloqueo=' . $id . ' and id_agencia is null';
		$criteria->limit = $habs;
		$model = Roominglist::model()->findAll($criteria);
		foreach ($model as $val) {
			$val->id_agencia = $_POST['id_agencia'];
			$val->estatus = "ND";
			if (!$val->save())
				echo CJSON::encode($model->getErros());
		}
		echo CJSON::encode($model);
	}

	public function actionGetLista()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');

		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));	
			$libres = ($data->numero_habitaciones - $apartadas) - $reservadas;		
			$tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;	

			if ($libres == 0) {
				unset($model[$key]);
			} else {
				if ($date_now < $date_a_comparar) {
					array_push($item, array(
						"id_bloqueo" => $data->id_bloqueo,
						"Estrellas" => $estrellasHotel->id_categoria,
						"id_tarifa" => $tarifas->id_tarifa,
						"tipo" => $data->tipo,
						"logotipo" => $fotoLogo->foto,
						"id_hotel" => $data->id_hotel,
						"foto_principal" => $foto->foto,
						"hotel_nombre" => $data->idHotel->nombre_hotel,
						"precio_doble" => $data->tarifaDesgloses->precio_normal,
						"tipo_habitacion" => $habitacion->tipo_habitacion,
						"fecha_inicio" => $data->fecha_inicio,
						"fecha_final" => $data->fecha_final,
						"estatus" => $data->estatus,
						"tipo_moneda" => $data->idTarifa->moneda,
						"tipo_plan" => $plan->nombre,
						"titulo_bloqueo" => $data->titulo,
						"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
						"visibilidad" => $data->visibilidad,
						"hab_disponibles" => $libres
					));
				}else{
					unset($model[$key]);
				}
			}
		}
		echo CJSON::encode($item);
	}
	public function actionGetNoDisponibles()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and t.visibilidad = 1');
		$criteria->addCondition('precio_normal > 0');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');

		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));	
			$libres = ($data->numero_habitaciones - $apartadas) - $reservadas;		
			$tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');
			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			$date_a_comparar =  $data->fecha_final;	

			
				// if ($date_now < $date_a_comparar) {
					array_push($item, array(
						"id_bloqueo" => $data->id_bloqueo,
						"Estrellas" => $estrellasHotel->id_categoria,
						"id_tarifa" => $tarifas->id_tarifa,
						"tipo" => $data->tipo,
						"logotipo" => $fotoLogo->foto,
						"id_hotel" => $data->id_hotel,
						"foto_principal" => $foto->foto,
						"hotel_nombre" => $data->idHotel->nombre_hotel,
						"precio_doble" => $data->tarifaDesgloses->precio_normal,
						"tipo_habitacion" => $habitacion->tipo_habitacion,
						"fecha_inicio" => $data->fecha_inicio,
						"fecha_final" => $data->fecha_final,
						"estatus" => $data->estatus,
						"tipo_moneda" => $data->idTarifa->moneda,
						"tipo_plan" => $plan->nombre,
						"titulo_bloqueo" => $data->titulo,
						"id_base_habitacion" => $data->tarifaDesgloses->id_base_habitacion,
						"visibilidad" => $data->visibilidad,
						"hab_disponibles" => $libres
					));
				// }else{
				// 	unset($model[$key]);
				// }
			
		}
		echo CJSON::encode($item);
	}

	public function actionGetBloqueo($id)
	{
		header('Access-Control-Allow-Origin: *');

		$criteria = new CDbCriteria();
		$criteria->addCondition('tipo="BLOQUEO"');
		$criteria->addCondition('t.estatus=1 and visibilidad = 1');
		$criteria->addCondition('current_date<=t.fecha_inicio');
		$criteria->addCondition('idTarifa.precio!="BODA"');
		$criteria->addCondition('tarifaDesgloses.id_base_habitacion=2');
		$criteria->addCondition('tarifaDesgloses.id_tipo_habitacion=t.id_tipo_habitacion');
		$criteria->addCondition('id_bloqueo=' . $id);



		$model = Bloqueos::model()->with('idTarifa', 'idHotel', 'tarifaDesgloses')->findAll($criteria);

		$item = array();
		foreach ($model as $key => $data) {
			$apartadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_agencia is not null and id_reservacion is null)'));
			$reservadas = count(Roominglist::model()->findAll('id_bloqueo=' . $data->id_bloqueo . ' and (id_reservacion is not null)'));

			$libres = $data->numero_habitaciones - $apartadas - $reservadas;
			if ($libres == 0) {

				unset($model[$key]);
			}

			$tarifas = Tarifa::model()->find('id_tarifa=' . $data['id_tarifa']);
			$foto = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and principal=1');

			$fotoLogo = HotelesFotos::model()->find('id_hotel=' . $data['id_hotel'] . ' and logotipo=1');
			$estrellasHotel = Hoteles::model()->find('id_hotel=' . $data['id_hotel']);

			$plan = TipoPlan::model()->find('id_tipo_plan=' . $data['id_tipo_plan']);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $data['id_tipo_habitacion']);
			$menores = DesgloseMenores::model()->find('id_tarifa=' . $data['id_tarifa']);


			$item[$key]["id_bloqueo"] = $data->id_bloqueo;
			$item[$key]["Estrellas"] = $estrellasHotel->id_categoria;
			$item[$key]["descripcion_hotel"] = $estrellasHotel->observaciones;
			$item[$key]["ubicacion_hotel"] = $estrellasHotel->ubicacion;
			$item[$key]["id_tarifa"] = $tarifas->id_tarifa;
			$item[$key]["tipo_Precio"] = $data->idTarifa->precio;
			$item[$key]["tipo"] = $data->tipo;
			$item[$key]["logotipo"] = $fotoLogo->foto;
			$item[$key]["id_hotel"] = $data->id_hotel;
			$item[$key]["foto_principal"]  = $foto->foto;
			$item[$key]["hotel_nombre"] = $data->idHotel->nombre_hotel;
			$item[$key]["precio_doble"] = $data->tarifaDesgloses->precio_normal;
			// $item[$key]["id_tipo_habitacion"] = $data->tarifaDesgloses->id_tipo_habitacion;
			$item[$key]["tipo_habitacion"] = $habitacion->tipo_habitacion;
			$item[$key]["fecha_inicio"]  = $data->fecha_inicio;
			$item[$key]["fecha_final"]  = $data->fecha_final;
			$item[$key]["estatus"] = $data->estatus;
			$item[$key]["tipo_moneda"] = $data->idTarifa->moneda;
			// $item[$key]["id_tipo_plan"] = $plan->id_tipo_plan;						 
			$item[$key]["tipo_plan"] = $plan->nombre;
			$item[$key]["titulo_bloqueo"] = $data->titulo;
			$item[$key]["id_base_habitacion"] = $data->tarifaDesgloses->id_base_habitacion;
			$item[$key]["visibilidad"] = $data->visibilidad;
			$item[$key]["hab_disponibles"] = $libres;
			$item[$key]["edad_max_menor"] = $menores->edad_max_menor;
			$item[$key]["edad_min_menor"] = $menores->edad_min_menor;
			$item[$key]["num_menores_gratis"] = $menores->num_menores_gratis;
		}




		//	echo CJSON::encode($model);
		echo CJSON::encode($item);
	}
}
