<?php
header('Access-Control-Allow-Origin: *');

//require_once('../../api/beds/HotelApi.php');
// require_once('../demo/array2xml.php');
class BusquedaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';
	public $pais="";
	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules() {
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('buscarDestinos','buscarDestinosPagos', 'buscarZonas','buscarCadenas', 'buscadorV2', 'busquedaDestinos', 'busquedaDestinosActivities', 'busquedaDestinosTours', 'formBusqueda', 'echo', 'SearchDestinations'),
				'users'=>array('*'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','hoteles','tarifa','hotelBeds','hotelPropio'),
				'users'=>array('@'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionIndex() {
		$this->render('index',array(
		));
	}
	
	public function actionSearchDestinations(){
	

		
		$hoteles = $this->buscaHoteles();
		$destino = $this->buscaDestinos();
		$zonas= $this->buscaZonas();
		$cadenas = $this->buscaCadenas();
		$busqueda = array();
		if (count($destino) > 0 ) {
					//$busqueda = array_merge($destino,$zonas);
					$busqueda = array_merge($destino, $hoteles);

					if(!empty($cadenas)) {
						$aux = array_merge($busqueda, $cadenas);
						$busqueda = $aux;
					}
					
				}else{
					$busqueda = $hoteles;
					if(count($cadenas) > 0) {
						$aux = array_merge($busqueda, $cadenas);
						$busqueda = $aux;
					}
				}
				if (count($zonas) > 0) {
					if ($busqueda) {
						
						$busqueda=array_merge($busqueda,$zonas);
					}else{
						$busqueda=$zonas;

					}
		}
		echo json_encode($busqueda);
	
		
		// echo CJSON::encode(array('destino'=>$destino,'zonas'=>$zonas,'hoteles'=>$hoteles));
	}

	public function buscaHoteles(){
		$arSearch=explode(" ", $_POST["search"]);
		$buscarNombreHotel="";
		foreach ($arSearch as $search) {
			$buscarNombreHotel .= 'and H.nombre_hotel like "%'.$search.'%" ';
		}
		$pais = '';
		if ($_POST['paises']=='false') {
			//$pais=" AND D.countryCode in ('MX') ";
		}
		$sql = "SELECT H.id_hotel as 'Codigo', CONCAT(H.nombre_hotel,  ', ', D.name) AS 'Nombre', 'Hotel' AS 'Tipo' 
			FROM tbl_hoteles H 
			INNER JOIN zonasbeds Z ON Z.idZona = H.id_destino 
			INNER JOIN destinations D ON D.code = Z.destinationsCode 
			WHERE H.estatus = 1  ". $buscarNombreHotel ."".$pais." LIMIT 20";

		// $sql = "SELECT H.id_hotel as 'Codigo', H.nombre_hotel AS 'Nombre', 'Hotel' AS 'Tipo', H.id_destino 
		// 	FROM tbl_hoteles H 
		// 	WHERE H.estatus = 1 AND H.busqueda = 1 ". $buscarNombreHotel ." LIMIT 20 ";
		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
        return $model_destinos;
	}

	public function buscaZonas(){
		
		// $sql = "SELECT Z.idZona AS 'Codigo', Z.name AS 'Nombre', 'Zona' AS 'Tipo'
		// 		FROM zonasbeds Z 
		// 		WHERE Z.name LIKE '%". $_POST['search'] ."%' LIMIT 5";
		// $model_destinos = Yii::app()->db->createCommand($sql)->queryAll(); 
        // return $model_destinos;
		/*$zonas=array();
		$criteria = new CDbCriteria;
		$criteria->condition = 't.name like "%'.$_POST['search'].'%" ';
		$criteria->order = 't.name';
		$criteria->limit = 5;
		$zonasb=Zonasbeds::model()->with('destinationsCode0')->findAll($criteria); 
		foreach ($zonasb as $z) {
			
		}
		return $zonas;*/
		$zonas=array();
		$criteria = new CDbCriteria;
		$criteria->condition = 't.name like "%'.$_POST['search'].'%" OR destinationsCode0.name like "%'.$_POST['search'].'%"';
		$criteria->order = 't.name';
		$criteria->limit = 10;
		$zonasb=Zonasbeds::model()->with('destinationsCode0')->findAll($criteria); 
		foreach ($zonasb as $z) {
				$zona["Codigo"]=$z->idZona;
				$zona["Nombre"]=$z->name.", ".$z->destinationsCode0->name;
				$zona["Tipo"]="Zona";
				$zonas[]=$zona;
		}
		return $zonas;
	}

	public function buscaDestinos(){

		// $sql = "SELECT D.code AS 'Codigo', D.name AS 'Nombre', 'Destino' AS 'Tipo' 
		// 		FROM destinations D 
		// 		WHERE D.name LIKE '%". $_POST['search'] ."%'";
		// $model_destinos = Yii::app()->db->createCommand($sql)->queryAll(); 
  		// return $model_destinos;

		$criteria = new CDbCriteria;

		$criteria->condition = 't.name like "%'.$_POST['search'].'%" ';
		$criteria->order = 't.name';
		$destinos = Destinations::model()->findAll($criteria); 
		$zonas=array();
		foreach($destinos as $des){
			foreach ($des->Zonas0 as $z) {
				$zona["Codigo"]=$z->idZona;
				$zona["Nombre"]=$z->name.", ".$z->destinationsCode0->name;
				$zona["Tipo"]="Zona";
				$zonas[]=$zona;
			}
			$destino["Codigo"]=$des->code;
			$destino["Nombre"]=$des->name;
			$destino["Tipo"]='Destino';
			$destinations[]=$destino;
		}
		

		$destino_zona = array_merge($destinations,$zonas);
		return $destino_zona;
	}

	public function buscaCadenas() {
		$criteria = new CDbCriteria;
		$criteria->condition = 't.nombre like "%'.$_POST['search'].'%" ';
		$criteria->order = 't.nombre';
		$chains = CadenaHotel::model()->findAll($criteria);
		$cadenas = array();
		foreach($chains as $cadena) {
			$info["Codigo"] = $cadena->id;
			$info["Nombre"] = $cadena->nombre;
			$info["Tipo"] = "Cadena";
			$cadenas[] = $info;
		}
		return $cadenas;
	}

	public function actionEcho() {
		echo 'http://'.$_SERVER["SERVER_NAME"].Yii::app()->request->baseUrl.'/getTarifas/ObtenerTarifas';
	}

	public function actionBuscarDestinos(){
	  	if(strlen($_POST["search"])>2 ){
			$criteria = new CDbCriteria;
				if ($_POST['pais']!='todos') {
					$pais=' AND t.countryCode="'.$_POST['pais'].'"';
				}
				$criteria->condition = 't.name like "%'.$_POST['search'].'%" '.$pais;
			$criteria->order = 't.name';
			//if(empty($_SESSION["cache"]["destinos"]))
	        //$_SESSION["cache"]["destinos"] = Destinations::model()->findAll($criteria); 
	        $destinos = Destinations::model()->findAll($criteria); 
	        $zonas=array();
	        foreach($destinos as $des){
	        	foreach ($des->Zonas0 as $z) {
				 	$zona["idZona"]=$z->idZona;
				 	$zona["name"]=$z->name.", ".$z->destinationsCode0->name;
				 	$zona["destino"]=$z->destinationsCode0->name;
	        	 $zonas[]=$zona;
	        	}
            }
            $hoteles=$this->buscarHoteles();
            $Zonasbeds=array();
            $Zonasbeds=$this->buscarZonas();
	        	$zonas= array_merge($zonas,$Zonasbeds);
	    }
	      $results = array("destinos"=>$destinos, "zonas"=>$zonas,  "hoteles"=>$hoteles);
	        echo CJSON::encode($results);
    }

    public function actionBuscarDestinosPagos(){
	  	if(strlen($_POST["search"])>2 ){
			$criteria = new CDbCriteria;
				if ($_POST['pais']!='todos') {
					$pais=' AND t.countryCode="'.$_POST['pais'].'"';
				}
				$criteria->condition = 't.name like "%'.$_POST['search'].'%" '.$pais;
			$criteria->order = 't.name';
			//if(empty($_SESSION["cache"]["destinos"]))
	        //$_SESSION["cache"]["destinos"] = Destinations::model()->findAll($criteria); 
	        $destinos = Destinations::model()->findAll($criteria); 
	        $zonas=array();
	        foreach($destinos as $des){
	        	foreach ($des->Zonas0 as $z) {
				 	$zona["idZona"]=$z->idZona;
				 	$zona["name"]=$z->name.", ".$z->destinationsCode0->name;
				 	$zona["destino"]=$z->destinationsCode0->name;
	        	 $zonas[]=$zona;
	        	}
            }
            $hoteles=$this->buscarHotelesPagos();
            $Zonasbeds=array();
            $Zonasbeds=$this->buscarZonas();
	        	$zonas= array_merge($zonas,$Zonasbeds);
	    }
	      $results = array("destinos"=>$destinos, "zonas"=>$zonas,  "hoteles"=>$hoteles);
	        echo CJSON::encode($results);
    }
    
    public function buscarZonas(){
		$zonas = array();
		if(strlen($_POST["search"])>2){
			$criteria = new CDbCriteria;
			if ($_POST['pais']!='todos') {
				$pais=' AND destinationsCode0.countryCode="'.$_POST['pais'].'"';
			}
			$criteria->condition = 't.name like "%'.$_POST['search'].'%" '.$pais;
			$criteria->order = 't.name';
			 $zonasb=Zonasbeds::model()->with('destinationsCode0')->findAll($criteria); 
			 foreach ($zonasb as $z) {
			 	$zona["idZona"]=$z->idZona;
			 	$zona["name"]=$z->name.", ".$z->destinationsCode0->name;
			 	$zona["destino"]=$z->destinationsCode0->name;
			 	$zonas[]=$zona;
			 }
		}
		 return $zonas;
   		//echo CJSON::encode($zonas);
    }

    public function actionBuscarZonas(){
		$zonas=array();
		$criteria = new CDbCriteria;
		/*if($_POST['pais'])
			$pais=' OR t.countryCode="'.$_POST['pais'].'"';*/
		$criteria->condition = 't.name like "%'.$_POST['search'].'%" '.$pais;
		$criteria->order = 't.name';
		 $_SESSION["cache"]["destinos"] = Zonasbeds::model()->findAll($criteria); 
		foreach($_SESSION["cache"]["destinos"] as $des){
            /*foreach($des->Zonas0 as $zone){ 
                $zonas["value"][] = "z_".$zone->idZona.'_'.$des->code.'/'.$zone->zoneCode;
                $zonas["name"][] = htmlentities($zone->name)." - ".$des->name;
            } */
   		echo CJSON::encode($des->Zonas0);
        }
   		//echo CJSON::encode($zonas);
    }

	public function actionBuscarCadenas(){
        if(empty($_SESSION["cache"]["cadenas"]))
    	    $_SESSION["cache"]["cadenas"] = CadenaHotel::model()->findAll(array('order'=>'nombre'));
        echo CJSON::encode($_SESSION["cache"]["cadenas"]);
    }
	
	public function buscarHoteles(){
		$criteria = new CDbCriteria;
		$criteria->select = array('id_hotel', 'nombre_hotel'); 

		$arSearch=explode(" ", $_POST["search"]);

		$buscarNombreHotel="";
		foreach ($arSearch as $search) {
			$buscarNombreHotel .= 'and t.nombre_hotel like "%'.$search.'%" ';
		}
		$paises="";
		if ($_POST['pais']!='todos') {
			$paises='and destinationsCode0.countryCode="'.$_POST['pais'].'"'  ;
		}

		$criteria->condition = 't.estatus=1 and t.busqueda=1 '.$buscarNombreHotel.' '.$paises;
		//$criteria->condition = 't.estatus=1 '.$buscarNombreHotel.' '.$paises;

		$criteria->order = 't.nombre_hotel';
		
        $results = Hoteles::model()->with('Destino.destinationsCode0')->together()->findAll($criteria); 
        return $results;
    }      

    public function buscarHotelesPagos(){
		$criteria = new CDbCriteria;
		$criteria->select = array('id_hotel', 'nombre_hotel'); 

		$arSearch=explode(" ", $_POST["search"]);

		$buscarNombreHotel="";
		foreach ($arSearch as $search) {
			$buscarNombreHotel .= 'and t.nombre_hotel like "%'.$search.'%" ';
		}
		$paises="";
		if ($_POST['pais']!='todos') {
			
			$paises='and destinationsCode0.countryCode="'.$_POST['pais'].'"'  ;
		}

		$criteria->condition = 't.estatus=1 '.$buscarNombreHotel.' '.$paises;
		//$criteria->condition = 't.estatus=1 '.$buscarNombreHotel.' '.$paises;

		$criteria->order = 't.nombre_hotel';
		
        $results = Hoteles::model()->with('Destino.destinationsCode0')->together()->findAll($criteria); 
      
        return $results;
    }      

	public function actionHotelBeds($codigoHotel,$id_hotel,$fecha_inicial,$noches,$categoria){
		//$jsonHotel=$this->tarifasBeds($codigoHotel);   
		$jsonHotel=$_SESSION["tarifasbeds"];			        
		$ahotelHB=json_decode($jsonHotel,true);         
		$hotelHB=json_decode($jsonHotel);         
		$arrHotel=$ahotelHB["hotels"]["hotels"];
		$key = array_search($codigoHotel, array_column($arrHotel, 'code'));   
        $precioBeds=(($hotelHB->hotels->hotels[$key]->minRate)*19.1358261);//*1.1733;
        $resultHotel=$hotelHB->hotels->hotels[$key];
        if($key===false){
			//print_r($arrHotel);
	        //echo '<strong>minRate: '.$precioBeds.'</strong>';
	        //$hotelesOcultar.='"h_'.$id_hotel.'",';
	        //echo '429 h_'.$id_hotel;
	        echo 0;
        } else{
            /*$roomCode=$hotelHB->hotels->hotels[0]->rooms[0]->code;
            $rateKey=$hotelHB->hotels->hotels[0]->rooms[0]->rates[0]->rateKey;*/
            $roomCode=$hotelHB->hotels->hotels[$key]->rooms[0]->code;
            $rateKey=$hotelHB->hotels->hotels[$key]->rooms[0]->rates[0]->rateKey;
            $desdeBeds="$".number_format($precioBeds,2);
			$api = Api::model()->findByPk(1);
            //echo $key;
            $this->renderPartial('cotizacionrapidaBeds',
                array('tipohab'=>$roomCode,
                    'id_tarifa'=>0,
                    'id_hotel'=>$id_hotel,
                    'fecha_inicial'=>$fecha_inicial,
                    'noches'=>$noches,
                    'combinar'=>false,
                    'desdeBeds'=>$desdeBeds,
                    'rateKey'=>$rateKey,
                    'resultHotel'=>$resultHotel,
                    'key'=>$key,
                    'categoria'=>$categoria,
                    'api'=>$api
                ));
        }
	}

	public function actionHotelPropio($id_hotel,$fecha_inicial,$noches,$filtro_disponibilidad) {	
		$jsonHotel=$_SESSION["tarifaspropias"];
		$ahotel=json_decode($jsonHotel,true);
		$arrHotel=$ahotel["hotels"]["hotels"];
		$key = array_search($id_hotel, array_column($arrHotel, 'id_hotel'));   
        $resultHotel=$ahotel["hotels"]["hotels"][$key];

	    $this->renderPartial('cotizacionrapida',array('id_hotel'=>$id_hotel,'fecha_inicial'=>$fecha_inicial,'noches'=>$noches,'filtro_disponibilidad'=>$filtro_disponibilidad,'resultHotel'=>$resultHotel)); 
	}

	public function agrupaCantidad($a) {
        $vecUnique['cuartos']=$a;
        $vecUnique['tipos']=Array();
        foreach($a as $b =>$c){
            if(!in_array($c,$vecUnique['tipos'])){
                $vecUnique['tipos'][$b]=$c;
                $vecUnique['cantidad'][$c]=1;
            }else{
                $vecUnique['cantidad'][$c]++;
            }
        }
        return $vecUnique;
    }

	/*public function menorTarifaBeds2($hotelHBencode) {
		$hotelHB=json_decode($hotelHBencode);
		$api=Api::model()->findByPk(1);
	    
	    $cuartosParaRatesKeys=$_SESSION['cuartosParaRatesKeys'];
	    
	    $ratesKeys=array();
		$cuartos=array();
        $tiposCuartos=array();
        $ratesKeys_primeraTarifa=array();
       
		$primeraTarifa="";  
        $rateClass="";
        $boardCode="";
        
        $r=0;
        $total=0;
		$menorPrecio=0; 
		$markup=$api->markup;

		if($hotelHB->currency=="MXN")
	    {
	    	$tipo_cambio=1;
	    }else
	    {
	    	$tipo_cambio=$api->tipo_cambio;
	    }

        foreach ($hotelHB->rooms as $roomCode => $room)
        {

            foreach ($room->rates as $rate) 
            {
                if($rate->rateKey && !in_array($rate->rateKey, $ratesKeys))
                {
                    
                    $rateKey_explode=explode("|", $rate->rateKey);
                    $condicion_hab=$rateKey_explode[9]."|".$rateKey_explode[10];     
                          
                    if($r<$_SESSION['front_form']['habs'] && count($ratesKeys_primeraTarifa)<=$_SESSION['front_form']['habs'])
                    {            
                    	
                    	$rowTipoCuarto=$cuartosParaRatesKeys['tipos'][$r];
                        
                        //foreach ($cuartosParaRatesKeys['tipos'] as $key => $rowTipoCuarto) 
                        //{
                            
                            $cantidadDeHabs=$cuartosParaRatesKeys['cantidad'][$rowTipoCuarto];
                                                        
                            if($rowTipoCuarto==$condicion_hab && $rate->allotment>=$cantidadDeHabs && !in_array($rowTipoCuarto, $cuartos) && ($rateClass=="" || $rateClass==$rate->rateClass) && ($boardCode=="" || $boardCode==$rate->boardCode))
                            {
        						
                                for ($cantidad=0; $cantidad < $cantidadDeHabs; $cantidad++) 
                                {
                                    
                                    $total+=($rate->net*$tipo_cambio)/$markup;
                                    
                                    array_push($ratesKeys_primeraTarifa, $rate->rateKey);
                                    array_push($ratesKeys, $rate->rateKey);
                                    array_push($tiposCuartos, $descripcionHabitacion);

                                    
	                				$r++;  
                                }

                                array_push($cuartos,$rowTipoCuarto);
                                $rateClass=$rate->rateClass;                           
                                $boardCode=$rate->boardCode;
                                                      
                                
                            }
                        //}

                    }                    
                }
            }
        }

        if($primeraTarifa=="" && $r==$_SESSION['front_form']['habs'])
        {
            $menorPrecio=$total;
        }

    	//echo "<textarea>".json_encode($hotelHB)."</textarea>";
    	//echo $r."<br>";


		return $menorPrecio;
	}*/

	public function menorTarifaBeds($hotelHBencode,$session_api,$mealplanArray) {
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		}else{

			$front_form = json_decode($session_api,true);
		}

		$hotelHB=json_decode($hotelHBencode);
		$api=Api::model()->findByPk(1);
	    
	    $cuartosParaRatesKeys=$front_form['cuartosParaRatesKeys'];

	    $ratesKeys=array();
		$cuartos=array();
        $tiposCuartos=array();
        $ratesKeys_primeraTarifa=array();
       
		$primeraTarifa="";  
        $rateClass="";
        $boardCode="";
        
        $r=0;
        $total=0;
		$menorPrecio=0; 
		$markup=$api->markup;

		if($hotelHB->currency=="MXN")
	    {
	    	$tipo_cambio=1;
	    }else
	    {
	    	$tipo_cambio=$api->tipo_cambio;
	    }

        foreach ($hotelHB->rooms as $roomCode => $room)
        {

            foreach ($room->rates as $rate) 
            {
                if($rate->rateKey && !in_array($rate->rateKey, $ratesKeys))
                {
                    
                    $rateKey_explode=explode("|", $rate->rateKey);
                    $condicion_hab=$rateKey_explode[9]."|".$rateKey_explode[10];     
                          
                    if($r<$front_form['habs'] && count($ratesKeys_primeraTarifa)<=$front_form['habs'])
                    {            
                    	
                    	$rowTipoCuarto=$cuartosParaRatesKeys['tipos'][$r];
                        
                        //foreach ($cuartosParaRatesKeys['tipos'] as $key => $rowTipoCuarto) 
                        //{
                            
                            $cantidadDeHabs=$cuartosParaRatesKeys['cantidad'][$rowTipoCuarto];
                              
                            if($rowTipoCuarto==$condicion_hab && $rate->allotment>=$cantidadDeHabs && !in_array($rowTipoCuarto, $cuartos) && ($rateClass=="" || $rateClass==$rate->rateClass) && ($boardCode=="" || $boardCode==$rate->boardCode))
                            {
        						
                                for ($cantidad=0; $cantidad < $cantidadDeHabs; $cantidad++) 
                                {
                                    
                                    $total+=($rate->net*$tipo_cambio)/$markup;
                                    
                                    array_push($ratesKeys_primeraTarifa, $rate->rateKey);
                                    array_push($ratesKeys, $rate->rateKey);
                                    array_push($tiposCuartos, $descripcionHabitacion);

                                    $planBeds = array_search($rate->boardCode, $mealplanArray);

                                    
	                				$r++;  
                                }

                                array_push($cuartos,$rowTipoCuarto);
                                $rateClass=$rate->rateClass;                           
                                $boardCode=$rate->boardCode;
                                                      
                                
                            }
                        //}

                    }                    
                }
            }
        }

        if($primeraTarifa=="" && $r==$front_form['habs'])
        {
            $menorPrecio=$total;
        }

    	//echo "<textarea>".json_encode($hotelHB)."</textarea>";
    	//echo $r."<br>";


		return array('menorPrecio'=>$menorPrecio, 'planBeds'=>$planBeds);
	}

	public function actionHoteles(){
		$fecha_inicial=implode("-", array_reverse( explode("/", $_POST["fecha_entrada"]) ) );								
		$fecha_final=implode("-", array_reverse( explode("/", $_POST["fecha_salida"]) ) );
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$hora = "and curtime() between hora_inicio and hora_final";
		$early_booking = "and (early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
		$tipo_precio = "";
		$tipo_plan = "";
		$categoria = "";
		$solo_adultos = "";
		/***CALCULA EL NUMERO DE  NOCHES ****/
		$datetime1 = new DateTime($fecha_inicial);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		/***FIN CALCULA EL NUMERO DE  NOCHES ****/
		/* SE USA $_SESSION['front_form'] PARA ALMACENAR LOS CAMPOS DEL FORMULARIO DE BUSQUEDA Y REUTILIZARLO EN EL CAMPO DE FILTRO Y EN EL MODAL DE BUSQUEDA */
		if(!empty($_POST['habs'])){
			if(!empty($_SESSION['front_form']))unset($_SESSION['front_form']);
			$habs = $_POST['habs'];
			$_SESSION['front_form']['habs'] = $habs;
			$_SESSION['front_form']['solo_adultos'] = "";
			for($i=1;$i<=$habs;$i++){
				if(!empty($_POST['habitacion_'.$i]['adultos'])){
					$adultos = $_POST['habitacion_'.$i]['adultos'];
					$_SESSION['front_form']['habitacion_'.$i]['adultos'] = $adultos;
				}
				$num_ninios = $_POST['habitacion_'.$i]['num_ninios'];
				$_SESSION['front_form']['habitacion_'.$i]['num_ninios'] = $num_ninios;
				if(!empty($num_ninios)){
					$_SESSION['front_form']['solo_adultos'] = 0;						
					for($j=1;$j<=$num_ninios;$j++){
						if(isset($_POST['habitacion_'.$i]['edad_'.$j])){
							$edad = $_POST['habitacion_'.$i]['edad_'.$j];
							$_SESSION['front_form']['habitacion_'.$i]['edad_'.$j] = $edad;
						}
					}
				}
			}
		}
		$_SESSION['front_form']['fecha_ini'] = $_POST['fecha_entrada'];
		$_SESSION['front_form']['fecha_fin'] = $_POST['fecha_salida'];
		$habitaciones = $_SESSION['front_form']['habs'];
		if(!empty($_POST["destino"]))
		{
			$_SESSION['front_form']['destino'] = $_POST["destino"];
			$destino = explode('_',$_POST["destino"]);
			if($destino[0] == 'z')
			{
				/***************************/
				//$tarifasBeds=$this->tarifasBeds($codigoHotel);
				/*****************************/
				$id_destino = $destino[1];
				$hoteles=Hoteles::model()->findAll(array('condition'=>'id_destino='.$id_destino,'limit'=>'5'));
				$this->render('hoteles',array('hoteles'=>$hoteles,'fecha_inicial'=>$fecha_inicial,'noches'=>$noches));
			}
		}
	}

	/************************************/
	public function consultarBeds($request){
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		 //return $estatus;
		if($estatus=="OK")
		{
			$response = $hotelApi->hotelAvailableWithFilters($request);
			return $response;
		}
		else
		{
			return "No hubo conexión";
		}
	}

	public function consultaRateComments($request){
		$hotelApi = new HotelApi();
		$estatus = $hotelApi->estatus();
		 //return $estatus;
		if($estatus=="OK")
		{
			$response = $hotelApi->ratecommentdetails($request);
			return $response;
		}
		else
		{
			return "No hubo conexión";
		}
	}

	public function tarifasBeds($codigoHotel){
		$fe=$_SESSION['front_form']['fecha_ini'];//$_POST["fecha_entrada"];
		$fs=$_SESSION['front_form']['fecha_fin'];//$_POST["fecha_salida"];
		$rooms= $_SESSION['front_form']['habs'];//$_POST["habs"];
		$fecha_inicial=implode("-",array_reverse(explode("/",$fe)));
		$fecha_final=implode("-",array_reverse(explode("/",$fs)));
		$request=array();
		$request["stay"]["checkIn"]=$fe;
		$request["stay"]["checkOut"]=$fs;
		$request["dailyRate"]=true;
		$request["stay"]["allowOnlyShift"]=false;
		$datetime1 = new DateTime($fecha_inicial);
		$datetime2 = new DateTime($fecha_final);
		$interval = $datetime1->diff($datetime2);
		$noches= $interval->format('%a');
		$request["stay"]["shiftDays"]=$noches;
		$request["occupancies"][0]["rooms"]=$rooms;
		$request["occupancies"][0]["paxes"]=array();
		for ($i=1; $i <= $rooms; $i++) { 
			$request["occupancies"][0]["adults"]+=$_SESSION['front_form']['habitacion_'.$i]['adultos'];
			for ($j=1; $j <= $_SESSION['front_form']['habitacion_'.$i]['adultos']; $j++) {
				$pax=array('type'=>'AD','age'=>30);
				array_push($request["occupancies"][0]["paxes"],$pax);
			}
		}
		for ($i=1; $i <= $rooms; $i++) { 
			$request["occupancies"][0]["children"]+=$_SESSION['front_form']['habitacion_'.$i]['num_ninios'];
			for ($j=1; $j <=$_SESSION['front_form']['habitacion_'.$i]['num_ninios']; $j++) {
				$pax=array('type'=>'CH','age'=>$_SESSION['front_form']["habitacion_".$i]["edad_".$j]);
				array_push($request["occupancies"][0]["paxes"],$pax);
			}	
		}
		$request["hotels"]["hotel"]=array($codigoHotel);
		$request["filter"]["packaging"]=false;
		$e=$this->consultarBeds(json_encode($request));
		$response=json_decode($e);
		return $e;
	}

	public function politicasCancelacion($cancellationPolicies,$fecha_inicial,$markup,$descripcionHabitacion,$r,$moneda,$bandera) {
        if($cancellationPolicies && $r==0)
            $politicasCancelacion="<h5>Gastos de cancelación</h5>";

        if($bandera==true)
        {
        	$atrrTable="border='1' class='table-tooltip tableInfo'";
		}else
		{
        	$atrrTable="class='table table-bordered table-tooltip tableInfo'";
		}
        $politicasCancelacion.="<table ".$atrrTable.">
                        <thead>
                            <th colspan='2'>".$descripcionHabitacion."</th>
                        </thead>
                        <tbody>";
        $hoy=date("Y-m-d");
					    
        if($cancellationPolicies)
        {
        $fechas_limite=array();
        $fechas_limite_h=array();
	        foreach ($cancellationPolicies as $c => $cancelacion) 
	        {

	            $importe=$cancelacion->amount/$markup;

	            $datetime_hoy=new DateTime($hoy);
			    $datetime_cancelacion=new DateTime(date("Y-m-d",strtotime($cancelacion->from)));
				
				$diferencia = $datetime_cancelacion->diff($datetime_hoy);
				
				$resultado_diferencia_dias= $diferencia->format('%a');

				if($resultado_diferencia_dias<=7)
				{
	            	$fecha_limite_amount=date("d/m/Y 20:00",strtotime($hoy.' +'.($c).' days'));
	            	$fecha_limite=date("d/m/Y 00:00");
	            	
	            	//variable que va al array
	            	$fechaLimite=date('Y-m-d 00:00');
				}else
				{
	            	$fecha_limite_amount=date("d/m/Y H:i",strtotime($cancelacion->from.' -7 days'));
	            	$fecha_limite=date("d/m/Y H:i",strtotime($cancelacion->from.' -8 days'));
	            	
	            	//variable que va al array
	            	$fechaLimite=date("Y-m-d H:i",strtotime($cancelacion->from.' -8 days'));

				}
	            $politicasCancelacion.= "<tr><td>A partir del ".$fecha_limite_amount."</td><td style='width: 25%;'> $".number_format($importe,2)." ".$moneda."</td></tr>";
	            	$fchl['fecha']=strtotime($fechaLimite);
	            	array_push($fechas_limite, $fchl);
	            	array_push($fechas_limite_h, $cancelacion->from);
	        }
	      	$fechaCount=count($fechas_limite);
	      	$fechaHCount=count($fechas_limite_h);
	        if ($fechaCount>=1) {
	       		$comparar='	if ($a[fecha] == $b[fecha]) {
					        return 1;
					    }
					    return ($a[fecha] < $b[fecha]) ? -1 : 1;';
	        	usort($fechas_limite, create_function('$a,$b', $comparar));
	        	$fecha_limite=date('d/m/Y',$fechas_limite[0]['fecha']);
	        }
	         if ($fechaHCount>=1) {
	       		$comparar='	if ($a[fecha] == $b[fecha]) {
					        return 1;
					    }
					    return ($a[fecha] < $b[fecha]) ? -1 : 1;';
	        	usort($fechas_limite_h, create_function('$a,$b', $comparar));
	        	$fecha_limite_h=date('d/m/Y',strtotime($fechas_limite_h[0]['fecha']));
	        }
	        
	    }else
	    {
	    	if($bandera==true)
	        	$politicasCancelacion.= "<tr><td>Gastos de cancelación al reservar</td></tr>";
	    }

        $politicasCancelacion.="</tbody></table>"; 

        if($fecha_inicial==date("Y-m-d"))

            $politicasCancelacion=$politicasCancelacion."Aplica cargo de cancelación inmediato. ";

        return array('politicasCancelacion'=>$politicasCancelacion,'fecha_limite'=>$fecha_limite,'fecha_limite_h'=>$fecha_limite_h,'fearray'=>$fechas_limite_h);
    }

	/*******************************************/
	public function cancelaciones($id_hotel,$fecha_inicio,$id_tarifa=null)##EL METODO EXISTE TAL CUÁL EN ReservacionController y SiteController
	{
		$avisoCancelacion = "";
		$cancelacion = Cancelacion::model()->findAll('id_hotel='.$id_hotel.' and "'.$fecha_inicio.'" between fecha_inicio and fecha_final ORDER BY dias DESC');
		if(empty($cancelacion))
			$cancelacion = Cancelacion::model()->findAll('id_hotel is null and "'.$fecha_inicio.'" between fecha_inicio and fecha_final ORDER BY dias DESC');
		foreach($cancelacion as $row){
			$fecha = strtotime($fecha_inicio." -".$row->dias." days");
			if(strtotime(date('Y-m-d')) <= $fecha){
				$avisoCancelacion .= "<p>Si cancela hasta el ".date('d/m/Y',$fecha)." tiene penalidad de ".$row->penalizacion." noches</p>";
			}
		}
		if(!empty($cancelacion)){
			$fecha = strtotime($fecha_inicio." -".($row->dias - 1)." days");
			if($fecha < strtotime('now')){
				$fecha = strtotime('now');
			}
			$avisoCancelacion .= "<p> A partir del ".date('d/m/Y',$fecha)." tiene penalización de toda la estancia.</p>";
		}

		if($avisoCancelacion=="")
		{

			$siteController = Yii::app()->createController('site');
            $siteController = $siteController[0];

            $fecha_limite=$siteController->getFechaLimitePago($id_tarifa,$fecha_inicio,$id_hotel);

			$avisoCancelacion="<p>Si cancela hasta el ".date("d/m/Y",strtotime($fecha_limite))." tiene penalidad de 0 noches.</p>";
			$avisoCancelacion .= "<p>A partir del ".date('d/m/Y',strtotime($fecha_limite.' +1 days'))." tiene penalización de toda la estancia.</p>";

		}

		return $avisoCancelacion;
	}
	
	public function getPrecio2($tipohab, $id_tarifa, $id_hotel, $fecha_inicial, $noches, $combinar,$fecha_final,$disponibilidadPalace) {
		$tarifa = Tarifa::model()->findByPk($id_tarifa); 
		$hotel = Hoteles::model()->findByPk($id_hotel);
		$tarifaAux=$tarifa;
		$id_tipo_plan = $tarifa->id_tipo_plan;
		$moneda = $tarifa->moneda;

		if($tarifa->precio=="OUTLET")
		{
			$in='"OUTLET","NORMAL"';
		}
		else if($tarifa->precio=="PROMO")
		{
			$in='"PROMO","NORMAL"';
		}else if($tarifa->precio=="NORMAL")
		{
			$in='"NORMAL","PROMO","OUTLET"';
		}
		$in='"NORMAL","PROMO","VIP"';
	
	    
		$hora = "and curtime() between hora_inicio and hora_final";
    	$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
		$early_booking = "and (early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
		
		
	    $vip=TarifaAgencia::model()->find("id_agencia=".$_SESSION["agenciaUsuario"]);
		
	    if($_SESSION["agenciaUsuario"] != 9 && !$vip ){		
			//if($_SESSION["agenciaUsuario"] != 9){
			$tarifaAgencias = 'and not exists(select id from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa='.$id_tarifa.' and tarifaAgencias.id_agencia!='.$_SESSION["agenciaUsuario"].')';
			
			$agenciaUsuario = $_SESSION["agencia"]; 
			$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$agenciaUsuario->id_estado_agencia.')';
		}


		$releaseDays = 0;
		$sup = Yii::app()->createController('reservacion');
		$sup = $sup[0];
		$costoHabitacion = array();
		$costoTotal = 0;
		
		for($dia=0;$dia<$noches;$dia++)
		{


			$fecha = date("Y-m-d", strtotime($fecha_inicial." +".$dia." days"));
			$fechadia = strtotime($fecha_inicial." +".$dia." days");
			$tarifaVacia = false;
			if(empty($combinar))	
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa='.$id_tarifa.' and id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.'', 'limit'=>1));
			if(empty($tarifa) || !empty($combinar)){
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos','tarifaDesgloses')->findAll(array('condition'=>'t.id_hotel='.$id_hotel.' and t.id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and ( t.id_tarifa='.$id_tarifa.' || ( t.precio IN('.$in.') and (t.id_combina='.$id_tarifa.' || t.id_combina is null) and promocontigua=1 ) ) and t.estatus=1 and id_base_habitacion=2 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.'', 'order'=>' t.id_tipo_plan ASC, precio_normal ASC ', 'limit'=>1));
				if(empty($tarifa))
					$tarifaVacia = true;
			}
			$t=0;
			foreach($tarifa as $row)
			{		
				$nocheGratis = NochesGratis::model()->find('id_tarifa='.$row->id_tarifa.' and (id_tipo_habitacion is null or id_tipo_habitacion='.$tipohab->id_tipo_habitacion.')');		
				$NGratis = false;
				if(empty($row->release)){
					$modelRelease=Release::model()->find('id_hotel='.$id_hotel.' AND current_date BETWEEN fecha_inicio AND fecha_final');
					$row->release=$modelRelease->dias;
				}
				if($row->release > $releaseDays)$releaseDays = $row->release;
				if($dia==0)$id_tarifa = $row->id_tarifa;
				if(!empty($nocheGratis) && (($dia+1) % $nocheGratis->noche == 0)){
					if(($dia+1) > $nocheGratis->noche && $nocheGratis->acumulable != 1){
						$NGratis = false;
					}else{
						$NGratis = true;
					}
				}
				if(!empty($_SESSION['front_form'])){
					for($i=1;$i<=$_SESSION['front_form']['habs'];$i++):
						$adultos = $_SESSION['front_form']['habitacion_'.$i]['adultos'];
						$num_ninios = $_SESSION['front_form']['habitacion_'.$i]['num_ninios'];
						$costoHabitacion[$i]['num_adultos'] = $adultos;
						$costoHabitacion[$i]['num_ninios'] = $num_ninios;
						if($combinar == true){
							$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition'=>'t.id_tarifa='.$row->id_tarifa.' and id_base_habitacion='.$adultos.' and max_adultos >= '.$adultos.' and t.max_menores >= '.$num_ninios.' and idTipoHabitacion.estatus=1','order'=>'precio_normal '.$ORDER_PRECIO.''));
						}else{
							$desglose = TarifaDesglose::model()->find('t.id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$tipohab->max_adultos.' >= '.$adultos.' and '.$tipohab->max_menores.' >= '.$num_ninios);
							$desglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$num_ninios.' <= max_menores and estatus=1');
						}
						if(empty($desglose)){
							$costoHabitacion[$i]['N/A'] = true;
							$noDisponible = true;
							if($tipohab->max_adultos < $adultos){
								$max_adultos = TipoHabitaciones::model()->find('id_hotel='.$row->id_hotel.' ORDER BY max_adultos DESC');
								$msgError = "Este Hotel no permite más de ".$max_adultos->max_adultos." adultos. Favor de redefinir su búsqueda.";
							}
							else if($tipohab->max_menores < $num_ninios){
								$max_menores = TipoHabitaciones::model()->find('id_hotel='.$row->id_hotel.' ORDER BY max_menores DESC');
								$msgError = "Este Hotel no permite más de ".$max_menores->max_menores." menores. Favor de redefinir su búsqueda.";
							}
							$_SESSION["msgError"]="No hay tarifa para ".$adultos." adultos que acepte ".$num_ninios." menores para la habitación ".$i.".";							
						}else{
							if($NGratis == true)$desglose->precio_normal = 0;
							$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,$adultos,'A',NULL));
							$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
							$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
							$tipohab = TipoHabitaciones::model()->findByPk($desglose->id_tipo_habitacion);
						}
						$tarifaDia[$dia]=$row->id_tarifa;
						if(!empty($_SESSION['front_form']['habitacion_'.$i]['num_ninios']) && $tipohab->max_menores >= $_SESSION['front_form']['habitacion_'.$i]['num_ninios']){
							$num_ninios = $_SESSION['front_form']['habitacion_'.$i]['num_ninios'];
							for($j=1;$j<=$num_ninios;$j++){ //Ordenar edades menores mayor a menor
								if($_SESSION['front_form']['habitacion_'.$i]['edad_'.$j] < $_SESSION['front_form']['habitacion_'.$i]['edad_'.($j+1)]){
									$aux = $_SESSION['front_form']['habitacion_'.$i]['edad_'.$j];
									$_SESSION['front_form']['habitacion_'.$i]['edad_'.$j] = $_SESSION['front_form']['habitacion_'.$i]['edad_'.($j+1)];
									$_SESSION['front_form']['habitacion_'.$i]['edad_'.($j+1)] = $aux;
									$j=0;
								}
							}
							$existeM = DesgloseMenores::model()->findAll('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and es_junior=0');
							if(!empty($existeM) && count($existeM) >= $desglose->max_menores)
							{
								$convertir = 0;
								$juniors = 0;
								for($j=1;$j<=$num_ninios;$j++){
									$edad = $_SESSION['front_form']['habitacion_'.$i]['edad_'.$j];
									$desgloseM = DesgloseMenores::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and '.$edad.' <= edad_max_menor and num_evaluar='.($j-$convertir-$juniors).' and es_junior=0 and('.$precompraMenor.') and(fecha_inicio is null or "'.$fecha.'" between fecha_inicio and fecha_final) ORDER BY precio ASC');
									if(empty($desgloseM))$desgloseM = DesgloseMenores::model()->with('idTipoHabitacion')->find(array('condition'=>'id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and '.$edad.' >= edad_min_menor and '.$edad.' <= edad_max_menor and es_junior=1 and max_juniors > '.$juniors.' and('.$precompraMenor.') and(fecha_inicio is null or "'.$fecha.'" between fecha_inicio and fecha_final)','order'=>'precio ASC'));
									if(!empty($desgloseM)){
										if($edad < $desgloseM->edad_min_menor || $NGratis == true)$desgloseM->precio = 0;
										$precioMenor = $row->tipoCambio($desgloseM->precio) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,0,'N',$edad));
										$costoHabitacion[$i][$dia]['menores'] += $precioMenor;
										$costoHabitacion[$i][$dia]['total'] += $precioMenor;
										$costoHabitacion[$i]['precio'] += $precioMenor;
										
										if($desgloseM->es_junior == 1)$juniors++;
									}else{
										$adultos += 1;
										$convertir++;
										$aux_ninios = $num_ninios - $convertir;
										if($combinar == true){
											$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition'=>'t.id_tarifa='.$row->id_tarifa.' and id_base_habitacion='.$adultos.' and max_adultos >= '.$adultos.' and t.max_menores >= '.$aux_ninios.' and idTipoHabitacion.estatus=1','order'=>'precio_normal '.$ORDER_PRECIO.''));
										}else{
											$desglose = TarifaDesglose::model()->find('t.id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$tipohab->max_adultos.' >= '.$adultos.' and '.$tipohab->max_menores.' >= '.$aux_ninios);
											$desglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$aux_ninios.' <= max_menores and estatus=1');
										}
										$costoHabitacion[$i]['num_adultos'] = $adultos;
										$costoHabitacion[$i]['num_ninios'] = $aux_ninios;
										$msgConversion = "Se convirtieron ".$convertir." menor(es) en adulto(s).";
										if(empty($desglose)){
											$costoHabitacion[$i]['N/A'] = true;
											$noDisponible = true;
											$msgError = "Este Hotel no permite ".$adultos." adultos y ".$aux_ninios." menores. Favor de redefinir su búsqueda.";
										}else{
											if($NGratis == true)$desglose->precio_normal = 0;
											$costoHabitacion[$i]['precio'] -= $costoHabitacion[$i][$dia]['total'];
											$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,$adultos,'A',NULL));
											$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
											$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
										}
									}
								}						
							}
							else{
								$costoHabitacion[$i]['N/A'] = true;
								$noDisponible = true;
								$msgError = "Error en la tarifa! Se le sugiere notificar a su agente de ventas.";
								break;
							}
						}

						//Mínimo de noches
						$minNoches = MinNoches::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final');
						if(!empty($minNoches) && $minNoches->minimo > $costoHabitacion[$t]['min_noches']){
							$costoHabitacion[$t]['min_noches'] = $minNoches->minimo;
						}else if($row->min_noches > $costoHabitacion[$t]['min_noches']){
							$costoHabitacion[$t]['min_noches'] = $row->min_noches;
						}

					endfor;
				}

				$t++;
			}
		} 

		if($noDisponible!=true)
		{
			$tarifa = Tarifa::model()->findByPk($id_tarifa); 
			$tarifaAux = $tarifa;
			$moneda = ($tarifa->tipo_cambio != 0 && $tarifa->mostrar_conversion == 1) ? 'MXN':$tarifa->moneda;

			for($i=1;$i<=$_SESSION['front_form']['habs'];$i++)
			{
				if($costoHabitacion[$i]['N/A']!=true)
		    	{
					$costoTotal += $costoHabitacion[$i]['precio'];
				} 
			}
	               
	        if($moneda!='MXN')
	        {
	        	if($tarifa->tasa_cambio===null)
	        		$tarifa->tasa_cambio=18.50;
	        }else
	        {
	        	$tarifa->tasa_cambio=1;
	        }

			$menorTarifa=($costoTotal*$tarifa->tasa_cambio);

			######################## fechas disponibles ######################



			$hora = "and curtime() between hora_inicio and hora_final";
    		$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$early_booking = "and(early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
			if(empty($tarifa->release)){
				$modelRelease=Release::model()->find('id_hotel='.$id_hotel.' AND current_date BETWEEN fecha_inicio AND fecha_final');
				$tarifa->release=$modelRelease->dias;
			}
			if($hotel->alerta_disponibilidad == 1){$hasAllotment=0;}else{$hasAllotment=1;}
			if($tarifa->release > $releaseDays) $releaseDays = $tarifa->release; 


			$now = strtotime(date('Y-m-d'));
			$checkin_date = strtotime($fecha_inicial);
			$datediff = abs($now - $checkin_date);
			$diffdays = floor($datediff/(60*60*24));
			
			
			if($diffdays < $releaseDays)
			{
				$tieneRelease=1;	
				
			}
			else
			{
			
			    $ok=0;
				$palaceResorts=array('BP','CZ','IM','LBC','MPS','PL','SP','MPG');
			    if(in_array($hotel->codigo,$palaceResorts) && $disponibilidadPalace=="false")
				{
					for($dia=0;$dia<$noches;$dia++)
				    {
				 		$mensaje = 1;
					}
				}
				else
				{
					for($dia=0;$dia<$noches;$dia++)
				    { 
					 	$fecha = date("Y-m-d", strtotime($fecha_inicial	." +".$dia." days"));
						$fechadia = strtotime($fecha_inicial." +".$dia." days");
						if(strtotime($fecha) > strtotime($tarifa->fecha_final))
						{
							$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->find(array('condition'=>'t.id_hotel='.$id_hotel.' and id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and precio IN('.$in.') and promocontigua=1 and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final', 'order'=>'precio desc'));
						}

						if($tarifaDia[$dia]!="")
						{
							$bloqueada = FechasBloqueadas::model()->find('id_tarifa='.$tarifaDia[$dia].' and ((id_tipo_habitacion is null and "'.$fecha.'" between fecha_inicio and fecha_final) or (id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final))');
						}

						$allotment = AllotmentDesglose::model()->with('idAllotment')->find('id_hotel='.$hotel->id_hotel.' and "'.$fecha.'" between fecha_inicio and fecha_final and id_tipo_habitacion='.$tipohab->id_tipo_habitacion);
						
						$reservadas = ReservacionDesglose::model()->with('idReservacion')->findAll('id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicial and fecha_final and idReservacion.estatus!="C" and libera_cupon=1');

						if($tarifa->release > $releaseDays) $releaseDays = $tarifa->release;
							
						if(!empty($bloqueada))
						{ 
							$mensaje = 1; 
				    	}
				    	else if(($hasAllotment==0) || !empty($allotment) && ($allotment->maximo - count($reservadas)) <= 0)
				    	{ 
				    		$mensaje = 1; 
				        }else
				        { 
				        	$ok++; 
						} 
					}
				}
			} 

			if($ok==$noches) $btnColor="green"; else $btnColor="red";
			if(($hasAllotment==0)  || ($ok==$noches && $hasAllotment==0) ) $btnColor="orange";
			if($tieneRelease==1 || $noches < $costoHabitacion[0]['min_noches']) $btnColor="red";
			//if($hotel->id_cadena==31) $btnColor="green"; 
			$ocultarTarifa="";

			if($btnColor=="green")
			{
				$disponibilidad=true;
			}else
			{
				$disponibilidad=false;
			}
			#############################    fin fechas disponibles    #################################
		}
		else
		{
			$menorTarifa=0;
			$disponibilidad=false;

		}

                                


		//echo json_encode(array('menorTarifa'=>$menorTarifa,'disponibilidad'=>$disponibilidad));
		return json_encode(array('menorTarifa'=>$menorTarifa,'disponibilidad'=>$disponibilidad,'btnColor'=>$btnColor));
		//return $menorTarifa;
	}

	public function getPrecio($tipohab, $id_tarifa, $id_hotel, $fecha_inicial, $noches, $combinar,$fecha_final,$disponibilidadPalace,$session_api) {
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		}else{
			$front_form = $session_api;
		}

		$tarifa = Tarifa::model()->findByPk($id_tarifa); 
		$hotel = Hoteles::model()->findByPk($id_hotel);
		$tarifaAux=$tarifa;
		$id_tipo_plan = $tarifa->id_tipo_plan;
		$moneda = $tarifa->moneda;
		$msgError=array();

		if($tarifa->precio=="OUTLET")
		{
			$in='"OUTLET","NORMAL"';
		}
		else if($tarifa->precio=="PROMO")
		{
			$in='"PROMO","NORMAL"';
		}else if($tarifa->precio=="NORMAL")
		{
			$in='"NORMAL","PROMO","OUTLET"';
		}
		$in='"NORMAL","PROMO","VIP"';
	
		$hora = "and curtime() between hora_inicio and hora_final";
    	$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
		$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
		$precompraMenor = "fecha_inicio_precompra is null or current_date between fecha_inicio_precompra and fecha_final_precompra";
		$early_booking = "and (early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
		
		
	    $vip=TarifaAgencia::model()->find("id_agencia=".$front_form["agenciaUsuario"]);
		
	    if($front_form["agenciaUsuario"] != 9 && !$vip ){		
	    

			//if($_SESSION["agenciaUsuario"] != 9){
			$tarifaAgencias = 'and not exists(select id from tbl_tarifa_agencia tarifaAgencias where tarifaAgencias.id_tarifa='.$id_tarifa.' and tarifaAgencias.id_agencia!='.$front_form["agenciaUsuario"].')';
			

			#####POSIBLEMENTE OCASIONE UN ERROR EN EL $FRONT_FORM POR EL MODO DE REFERENCIAR;
			$agenciaUsuario = $front_form["agencia"]; 
			$tarifaEstados = 'and exists(select NULL from tbl_tarifa_estados tarifaEstados where tarifaEstados.id_tarifa=t.id_tarifa and tarifaEstados.id_estado='.$front_form["id_estado_agencia"].')';
		}

		// echo json_encode($front_form["agencia"]);


		$releaseDays = 0;
		$sup = Yii::app()->createController('reservacion');
		$sup = $sup[0];
		$costoHabitacion = array();
		$costoTotal = 0;
		
		for($dia=0;$dia<$noches;$dia++)
		{


			$fecha = date("Y-m-d", strtotime($fecha_inicial." +".$dia." days"));
			$fechadia = strtotime($fecha_inicial." +".$dia." days");
			$tarifaVacia = false;
			if(empty($combinar))	
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->findAll(array('condition'=>'t.id_tarifa='.$id_tarifa.' and id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.'', 'limit'=>1));
			if(empty($tarifa) || !empty($combinar)){
				$tarifa = Tarifa::model()->with('tarifaDiasvalidos','tarifaDesgloses')->findAll(array('condition'=>'t.id_hotel='.$id_hotel.' and t.id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and ( t.id_tarifa='.$id_tarifa.' || ( t.precio IN('.$in.') and (t.id_combina='.$id_tarifa.' || t.id_combina is null) and promocontigua=1 ) ) and t.estatus=1 and id_base_habitacion=2 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final '.$tarifaAgencias.' '.$tarifaEstados.'', 'order'=>' t.id_tipo_plan ASC, precio_normal ASC ', 'limit'=>1));
				if(empty($tarifa))
					$tarifaVacia = true;
			}
			$t=0;
			foreach($tarifa as $row)
			{		
				$nocheGratis = NochesGratis::model()->find('id_tarifa='.$row->id_tarifa.' and (id_tipo_habitacion is null or id_tipo_habitacion='.$tipohab->id_tipo_habitacion.')');		
				$NGratis = false;
				if(empty($row->release)){
					$modelRelease=Release::model()->find('id_hotel='.$id_hotel.' AND current_date BETWEEN fecha_inicio AND fecha_final');
					$row->release=$modelRelease->dias;
				}
				if($row->release > $releaseDays)$releaseDays = $row->release;
				if($dia==0)$id_tarifa = $row->id_tarifa;
				if(!empty($nocheGratis) && (($dia+1) % $nocheGratis->noche == 0)){
					if(($dia+1) > $nocheGratis->noche && $nocheGratis->acumulable != 1){
						$NGratis = false;
					}else{
						$NGratis = true;
					}
				}
				if(!empty($front_form)){
					for($i=1;$i<=$front_form['habs'];$i++):
						$adultos = $front_form['habitacion_'.$i]['adultos'];
						$num_ninios = $front_form['habitacion_'.$i]['num_ninios'];
						$costoHabitacion[$i]['num_adultos'] = $adultos;
						$costoHabitacion[$i]['num_ninios'] = $num_ninios;
						if($combinar == true){
							$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition'=>'t.id_tarifa='.$row->id_tarifa.' and id_base_habitacion='.$adultos.' and max_adultos >= '.$adultos.' and t.max_menores >= '.$num_ninios.' and idTipoHabitacion.estatus=1','order'=>'precio_normal '.$ORDER_PRECIO.''));
						}else{
							$desglose = TarifaDesglose::model()->find('t.id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$tipohab->max_adultos.' >= '.$adultos.' and '.$tipohab->max_menores.' >= '.$num_ninios);
							$desglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$num_ninios.' <= max_menores and estatus=1');
						}

						// echo "<br>_________???".$desglose->id_tarifa_desglose;

						if(empty($desglose)){
							$costoHabitacion[$i]['N/A'] = true;
							$noDisponible = true;
							if($tipohab->max_adultos < $adultos){
								$max_adultos = TipoHabitaciones::model()->find('id_hotel='.$row->id_hotel.' ORDER BY max_adultos DESC');
								$msgError['msgError'] = "Este Hotel no permite más de ".$max_adultos->max_adultos." adultos. Favor de redefinir su búsqueda.";
							}
							else if($tipohab->max_menores < $num_ninios){
								$max_menores = TipoHabitaciones::model()->find('id_hotel='.$row->id_hotel.' ORDER BY max_menores DESC');
								$msgError['msgError'] = "Este Hotel no permite más de ".$max_menores->max_menores." menores. Favor de redefinir su búsqueda.";
							}
							$msgError['msgError']["msgError"]="No hay tarifa para ".$adultos." adultos que acepte ".$num_ninios." menores para la habitación ".$i.".";							
						}else{
							if($NGratis == true)$desglose->precio_normal = 0;
							$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,$adultos,'A',NULL));
							$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
							$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
							$tipohab = TipoHabitaciones::model()->findByPk($desglose->id_tipo_habitacion);
						}
						$tarifaDia[$dia]=$row->id_tarifa;
						if(!empty($front_form['habitacion_'.$i]['num_ninios']) && $tipohab->max_menores >= $front_form['habitacion_'.$i]['num_ninios']){
							$num_ninios = $front_form['habitacion_'.$i]['num_ninios'];
							for($j=1;$j<=$num_ninios;$j++){ //Ordenar edades menores mayor a menor
								if($front_form['habitacion_'.$i]['edad_'.$j] < $front_form['habitacion_'.$i]['edad_'.($j+1)]){
									$aux = $front_form['habitacion_'.$i]['edad_'.$j];
									$front_form['habitacion_'.$i]['edad_'.$j] = $front_form['habitacion_'.$i]['edad_'.($j+1)];
									$front_form['habitacion_'.$i]['edad_'.($j+1)] = $aux;
									$j=0;
								}
							}
							$existeM = DesgloseMenores::model()->findAll('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and es_junior=0');
							if(!empty($existeM) && count($existeM) >= $desglose->max_menores)
							{
								$convertir = 0;
								$juniors = 0;
								for($j=1;$j<=$num_ninios;$j++){
									$edad = $front_form['habitacion_'.$i]['edad_'.$j];
									$desgloseM = DesgloseMenores::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and '.$edad.' <= edad_max_menor and num_evaluar='.($j-$convertir-$juniors).' and es_junior=0 and('.$precompraMenor.') and(fecha_inicio is null or "'.$fecha.'" between fecha_inicio and fecha_final) ORDER BY precio ASC');
									if(empty($desgloseM))$desgloseM = DesgloseMenores::model()->with('idTipoHabitacion')->find(array('condition'=>'id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and '.$edad.' >= edad_min_menor and '.$edad.' <= edad_max_menor and es_junior=1 and max_juniors > '.$juniors.' and('.$precompraMenor.') and(fecha_inicio is null or "'.$fecha.'" between fecha_inicio and fecha_final)','order'=>'precio ASC'));
									if(!empty($desgloseM)){
										if($edad < $desgloseM->edad_min_menor || $NGratis == true)$desgloseM->precio = 0;
										$precioMenor = $row->tipoCambio($desgloseM->precio) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,0,'N',$edad));
										$costoHabitacion[$i][$dia]['menores'] += $precioMenor;
										$costoHabitacion[$i][$dia]['total'] += $precioMenor;
										$costoHabitacion[$i]['precio'] += $precioMenor;
										
										if($desgloseM->es_junior == 1)$juniors++;
									}else{
										$adultos += 1;
										$convertir++;
										$aux_ninios = $num_ninios - $convertir;
										if($combinar == true){
											$desglose = TarifaDesglose::model()->with('idTipoHabitacion')->find(array('condition'=>'t.id_tarifa='.$row->id_tarifa.' and id_base_habitacion='.$adultos.' and max_adultos >= '.$adultos.' and t.max_menores >= '.$aux_ninios.' and idTipoHabitacion.estatus=1','order'=>'precio_normal '.$ORDER_PRECIO.''));
										}else{
											$desglose = TarifaDesglose::model()->find('t.id_tarifa='.$row->id_tarifa.' and t.id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$tipohab->max_adultos.' >= '.$adultos.' and '.$tipohab->max_menores.' >= '.$aux_ninios);
											$desglose = TarifaDesglose::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and id_base_habitacion='.$adultos.' and '.$aux_ninios.' <= max_menores and estatus=1');
										}
										$costoHabitacion[$i]['num_adultos'] = $adultos;
										$costoHabitacion[$i]['num_ninios'] = $aux_ninios;
										$msgConversion = "Se convirtieron ".$convertir." menor(es) en adulto(s).";
										if(empty($desglose)){
											$costoHabitacion[$i]['N/A'] = true;
											$noDisponible = true;
											$msgError['msgError'] = "Este Hotel no permite ".$adultos." adultos y ".$aux_ninios." menores. Favor de redefinir su búsqueda.";
										}else{
											if($NGratis == true)$desglose->precio_normal = 0;
											$costoHabitacion[$i]['precio'] -= $costoHabitacion[$i][$dia]['total'];
											$costoHabitacion[$i][$dia]['adultos'] = $row->tipoCambio($desglose->precio_normal) + $row->tipoCambio($sup->Sumarsuplemento($row->id_tarifa,$fecha,$adultos,'A',NULL));
											$costoHabitacion[$i][$dia]['total'] = $costoHabitacion[$i][$dia]['adultos'];
											$costoHabitacion[$i]['precio'] += $costoHabitacion[$i][$dia]['total'];
										}
									}
								}						
							}
							else{
								$costoHabitacion[$i]['N/A'] = true;
								$noDisponible = true;
								$msgError['msgError'] = "Error en la tarifa! Se le sugiere notificar a su agente de ventas.";
								break;
							}
						}

						//Mínimo de noches
						$minNoches = MinNoches::model()->find('id_tarifa='.$row->id_tarifa.' and id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final');
						if(!empty($minNoches) && $minNoches->minimo > $costoHabitacion[$t]['min_noches']){
							$costoHabitacion[$t]['min_noches'] = $minNoches->minimo;
						}else if($row->min_noches > $costoHabitacion[$t]['min_noches']){
							$costoHabitacion[$t]['min_noches'] = $row->min_noches;
						}

					endfor;
				}

				$t++;
			}
		} 

		if($noDisponible!=true)
		{
			$tarifa = Tarifa::model()->findByPk($id_tarifa); 
			$tarifaAux = $tarifa;
			$moneda = ($tarifa->tipo_cambio != 0 && $tarifa->mostrar_conversion == 1) ? 'MXN':$tarifa->moneda;

			for($i=1;$i<=$front_form['habs'];$i++)
			{
				if($costoHabitacion[$i]['N/A']!=true)
		    	{
					$costoTotal += $costoHabitacion[$i]['precio'];
				} 
			}
	               
	        if($moneda!='MXN')
	        {
	        	$menorTarifa_usd = $costoTotal;
	        	
	        	if($tarifa->tasa_cambio===null)
	        		$tarifa->tasa_cambio=18.50;
	        }else
	        {
	        	$tarifa->tasa_cambio=1;
	        }

			$menorTarifa=($costoTotal*$tarifa->tasa_cambio);

			// echo json_encode($costoHabitacion);
			// echo $costoTotal.'<br>';
			######################## fechas disponibles ######################



			$hora = "and curtime() between hora_inicio and hora_final";
    		$fecha_promo = "and (current_date between fecha_promo_inicio and fecha_promo or fecha_promo>='".date('Y-m-d')."')";
			$fecha_promo = "and current_date between fecha_promo_inicio and fecha_promo";
			$early_booking = "and(early_booking is null or DATEDIFF('".$fecha_inicial."',current_date) <= early_booking)";
			if(empty($tarifa->release)){
				$modelRelease=Release::model()->find('id_hotel='.$id_hotel.' AND current_date BETWEEN fecha_inicio AND fecha_final');
				$tarifa->release=$modelRelease->dias;
			}
			if($hotel->alerta_disponibilidad == 1){$hasAllotment=0;}else{$hasAllotment=1;}
			if($tarifa->release > $releaseDays) $releaseDays = $tarifa->release; 


			$now = strtotime(date('Y-m-d'));
			$checkin_date = strtotime($fecha_inicial);
			$datediff = abs($now - $checkin_date);
			$diffdays = floor($datediff/(60*60*24));
			
			
			if($diffdays < $releaseDays)
			{
				$tieneRelease=1;	
				
			}
			else
			{
			
			    $ok=0;
				$palaceResorts=array('BP','CZ','IM','LBC','MPS','PL','SP','MPG');
			    if(in_array($hotel->codigo,$palaceResorts) && $disponibilidadPalace=="false")
				{
					for($dia=0;$dia<$noches;$dia++)
				    {
				 		$mensaje = 1;
					}
				}
				else
				{
					for($dia=0;$dia<$noches;$dia++)
				    { 
					 	$fecha = date("Y-m-d", strtotime($fecha_inicial	." +".$dia." days"));
						$fechadia = strtotime($fecha_inicial." +".$dia." days");
						if(strtotime($fecha) > strtotime($tarifa->fecha_final))
						{
							$tarifa = Tarifa::model()->with('tarifaDiasvalidos')->find(array('condition'=>'t.id_hotel='.$id_hotel.' and id_tipo_plan='.$id_tipo_plan.' '.$fecha_promo.' '.$hora.' '.$early_booking.' and precio IN('.$in.') and promocontigua=1 and estatus=1 and dia='.date("N",$fechadia).' and "'.$fecha.'" between t.fecha_inicial and t.fecha_final', 'order'=>'precio desc'));
						}

						if($tarifaDia[$dia]!="")
						{
							$bloqueada = FechasBloqueadas::model()->find('id_tarifa='.$tarifaDia[$dia].' and ((id_tipo_habitacion is null and "'.$fecha.'" between fecha_inicio and fecha_final) or (id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicio and fecha_final))');
						}

						$allotment = AllotmentDesglose::model()->with('idAllotment')->find('id_hotel='.$hotel->id_hotel.' and "'.$fecha.'" between fecha_inicio and fecha_final and id_tipo_habitacion='.$tipohab->id_tipo_habitacion);
						
						$reservadas = ReservacionDesglose::model()->with('idReservacion')->findAll('id_tipo_habitacion='.$tipohab->id_tipo_habitacion.' and "'.$fecha.'" between fecha_inicial and fecha_final and idReservacion.estatus!="C" and libera_cupon=1');

						if($tarifa->release > $releaseDays) $releaseDays = $tarifa->release;
							
						if(!empty($bloqueada))
						{ 
							$mensaje = 1; 
				    	}
				    	else if(($hasAllotment==0) || !empty($allotment) && ($allotment->maximo - count($reservadas)) <= 0)
				    	{ 
				    		$mensaje = 1; 
				        }else
				        { 
				        	$ok++; 
						} 
					}
				}
			} 

			if($ok==$noches) $btnColor="green"; else $btnColor="red";
			if(($hasAllotment==0)  || ($ok==$noches && $hasAllotment==0) ) $btnColor="orange";
			if($tieneRelease==1 || $noches < $costoHabitacion[0]['min_noches']) $btnColor="red";
			//if($hotel->id_cadena==31) $btnColor="green"; 
			$ocultarTarifa="";

			if($btnColor=="green")
			{
				$disponibilidad=true;
			}else
			{
				$disponibilidad=false;
			}
			#############################    fin fechas disponibles    #################################
		}
		else
		{
			$menorTarifa=0;
			$disponibilidad=false;

		}

                                


		// echo json_encode(array('menorTarifa'=>$menorTarifa,'disponibilidad'=>$disponibilidad,'btnColor'=>$btnColor,'id_plan'=>$tarifa->id_tipo_plan,'errores'=>$msgError,'menorTarifa_usd'=>$menorTarifa_usd,'moneda'=>$moneda));
		
		return json_encode(array('menorTarifa'=>$menorTarifa,'disponibilidad'=>$disponibilidad,'btnColor'=>$btnColor,'id_plan'=>$tarifa->id_tipo_plan,'errores'=>$msgError,'menorTarifa_usd'=>$menorTarifa_usd,'moneda'=>$moneda));
		//return $menorTarifa;
	}

	public function disponibilidadPalace($fecha_inicial,$noches,$hotel,$tipo_hab,$session_api) {
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		}else{
			$front_form = $session_api;
		}
		// echo $fecha_inicial;echo $noches;echo $hotel; echo $tipo_hab; echo $front_form['habs'];

		for($i=1;$i<=$front_form['habs'];$i++)
		{
			$adultos = $front_form['habitacion_'.$i]['adultos'];
			$menores = $front_form['habitacion_'.$i]['num_ninios'];
			$personas = $adultos + $menores;
			$bebes = 0; $ninios = 0; $juniors = 0;
			//Validando tipo de cama
			if($personas > 2){
				$tipo_cama = "D";
			}else{
				$tipo_cama = "K";
			}
			if($tipo_hab == "FL"){
				if($tipo_cama == "K"){
					$tipo_hab = "FL1";
				}else if($tipo_cama == "D"){
					$tipo_hab = "FL2";
				}
			}

			if ($menores>0) {
			//Validando tipo de menores
			for($j=1;$j<=$menores;$j++)
			{
				$edad = $_SESSION['front_form']['habitacion_'.$i]['edad_'.$j];
				if($edad <= 3){
					$bebes++;
				}else if($edad > 3 && $edad <= 12){
					$ninios++;
				}else if($edad > 12 && $edad <= 17){
					$juniors++;
				}
			}
			}else{
				$bebes=0;
				$ninios=0;
				$juniors=0;
			}
		}

		$ararytoxml= new XML2Array;
		ini_set('display_errors', true);
		ini_set('display_startup_errors', true);
		ini_set('default_socket_timeout', 120);


		// url de conección con el webservice y la clase del webservice
		$url = 'https://api.palaceresorts.com/EnterpriseServiceInterface/ServiceInterface.asmx?wsdl';
		$action = 'http://localhost/xmlschemas/enterpriseservice/16-07-2009/GetAvailability';
		$options = array(
	                'location'=>'http://api.palaceresorts.com/EnterpriseServiceInterface/ServiceInterface.asmx?wsdl',
	                'uri'=>"",
	                'trace'=>1
	    );
		
		$client = new SoapClient(null, $options);
		//array de los parametros enviados por el formulario hacia el web service



		$fecha_final = date("Y-m-d", strtotime($fecha_inicial	." +".$noches." days"));

		$getAvailabilityRq["availabilityRequest"]=array(
		    "data"=>array(
		        "hotel"=>$hotel, //"MPS",
		         "room_type"=>$tipo_hab, //"OV",
		         "bed_type"=>$tipo_cama, //"K", 
		         "adultos"=>$adultos, //2,
		         //"menores"=>$menores, //0,
		         "baby"=>$bebes,
		         "child"=>$ninios,
		         "kid"=>$juniors,
		         "arrival_date"=>$fecha_inicial."T00:00:00.0000000-05:00", //"2018-04-10T00:00:00.0000000-05:00",
		         "departure_date"=>$fecha_final."T00:00:00.0000000-05:00", //"2018-04-15T00:00:00.0000000-05:00",
		         "agency_cd"=>"RMAYA"
		         ),
		    "AuthInfo"=>array(  
		         "Recnum"=>0,
		         "Ent_User"=>"RMY",
		         "Ent_Pass"=>"QMrq8UzEru",
		         "Ent_Term"=>"RMY"
		         )
		    );
	    

		//cabecera del xml en forma de string, para utilizar el metodo simplexmlelement de php
		$xmlString='<?xml version="1.0"?><soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:ns="http://localhost/xmlschemas/enterpriseservice/16-07-2009/" xmlns:ava="http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd" xmlns:ava1="http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd" xmlns:aut="http://localhost/pr_xmlschemas/hotel/01-03-2006/authInfo.xsd"> </soapenv:Envelope>';


		//clase para manipular el xml
		$xml = new SimpleXMLElement($xmlString);
		
		//$nameSpace=$xml->getDocNamespaces(true); //sirve para mostrar nameSpace registrados en el documento 
		$node1=$xml->addChild('Body'); // agregar nodo hijo heredando el primer namespace "soapenv"
		$node=$node1->addChild('GetAvailability', null, 'http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd'); //agregar nodo hijo del anterior, agregando el namespace que le corresponde segun documentación
		$nuevoXml = $this->array_to_xml($getAvailabilityRq, $node); //enviando parametros a la funcion array con parametros del formulario, y nodo hijo creado anteriormente
		$reservaFolioXml=$xml->asXML();
	
		try{
	    	$response = $client->__doRequest($reservaFolioXml, $url, $action, 1);
	    
	    	if ($response!=NULL)
	    	{
		        $responseXml = XML2Array::createArray($response);
		        /*if (isset($responseXml['soap:Envelope']['soap:Body']['GetAvailabilityResponse']['roomAvailabilityResponse']['Hotel']))
		        {
		        	$disponibilidad=true;
		        }
		        else{
		        	$disponibilidad=false;
		        }*/
		        
		        $data=$responseXml['soap:Envelope']['soap:Body']['GetAvailabilityResponse']['roomAvailabilityResponse'];

		       

						$logHotelbeds = new LogHotelbeds;
				$logHotelbeds->header = "palace";
				$logHotelbeds->request = $reservaFolioXml;
				$logHotelbeds->response = $response;
				$logHotelbeds->save(); 	
	    	}
	      
		}catch (SoapFault $exception){   
			    echo "<textarea>".$exception."</textarea>";
		}
 
		//echo "<textarea>".json_encode(array('disponibilidad'=>$disponibilidad,'data'=>$data,))."</textarea>";
		return json_encode($data);
	}

	public function array_to_xml($array, &$xml)  {
    	foreach($array as $key => $value) {
        	if(is_array($value)) 
        	{
            	if(!is_numeric($key))
            	{
                    if($key=='availabilityRequest')    
                	    $subnode = $xml->addChild($key, null, 'http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd');   
                  	else if($key=='data')
                    	$subnode = $xml->addChild($key, null, 'http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd'); 
                   	else if($key=='AuthInfo')
                    	$subnode = $xml->addChild($key, null, 'http://localhost/pr_xmlschemas/hotel/01-03-2006/availabilityRequest.xsd'); 
                    else
                       $subnode = $xml->addChild($key);
                   
                	$this->array_to_xml($value, $subnode);
            	} 
            	else 
            	{
                	$this->array_to_xml($value, $xml);
            	}
        	}
        	else 
        	{
         
          		$xml->addChild($key, $value, 'http://localhost/pr_xmlschemas/hotel/01-03-2006/availability.xsd');
	        }
		}
   		
   		return $xml;
	}

	public function actionBuscadorV2() {
		$this->layout="//layouts/altair";
		$this->render("buscadorV2");
	}

	public function array_sort_by(&$arrIni, $col, $order = SORT_ASC) {
		$arrAux = array();
		foreach ($arrIni as $key=> $row) 
		{
			$arrAux[$key] = is_object($row) ? $arrAux[$key] = $row->$col : $row[$col];
			$arrAux[$key] = strtolower($arrAux[$key]);
		}
		array_multisort($arrAux, $order, $arrIni);
	}

	public function desglose($rateDailyRates,$fecha_inicial,$markup,$moneda,$r,$condicion_hab,$session_api){
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		}else{
			$front_form = json_decode($session_api,true);
		}

		$tipoCambio=1;
		$desgloseHab = "<tr>
		<th colspan='2'>
		Habitación ".$r."
		</th>
		<td> 
		Adultos: ".$front_form['habitacion_'.$r]['adultos']." 
		-
		Menores: ".$front_form['habitacion_'.$r]['num_ninios']."
		</td>
		</tr>";
		foreach ($rateDailyRates as $dailyRates) {
			$dailyNet_A_MXN=($dailyRates->dailyNet*$tipoCambio)/$markup;
			$dailyNet_M_MXN=(0*$tipoCambio);
			$dailyNetMXN=$dailyNet_A_MXN+$dailyNet_M_MXN;              
			$desglose .= "<tr>
			<td>".$dailyRates->offset."</td>
			<td>".date('d-m-Y',strtotime($fecha_inicial.'+'.($dailyRates->offset-1).' day'))."</td>
			<td>$ ".number_format($dailyNet_A_MXN,2)." ".$moneda."</td>
			</tr>";
			$totalHab+=$dailyNet_A_MXN;
		}
		$desglose.="<tr><th colspan='2'>Sub-total:</th><td>$ ".number_format($totalHab,2)." ".$moneda."</tr>";
		$desglose = $desgloseHab.$desglose;
		return $desglose;
	}

	public function desglosePersonas($rateDailyRates,$fecha_inicial,$markup,$moneda,$r,$condicion_hab,$session_api){
		if ($_SESSION["front_form"]) {
			$front_form = $_SESSION["front_form"];
		}else{
			$front_form = json_decode($session_api,true);
		}

		$tipoCambio=1;

		$desglosePersona = array();

		$desglosePersona['resumen']['adultos'] = $front_form['habitacion_'.$r]['adultos'];
		$desglosePersona['resumen']['menores'] = $front_form['habitacion_'.$r]['num_ninios'];

		foreach ($rateDailyRates as $dailyRates) {
			$dailyNet_A_MXN=($dailyRates->dailyNet*$tipoCambio)/$markup;
			$dailyNet_M_MXN=(0*$tipoCambio);
			$dailyNetMXN=$dailyNet_A_MXN+$dailyNet_M_MXN;
			$desglosePersona['Fechas'][$dailyRates->offset]['Fecha'] = date('d-m-Y',strtotime($fecha_inicial.'+'.($dailyRates->offset-1).' day'));
			$desglosePersona['Fechas'][$dailyRates->offset]['Adultos'] = number_format($dailyNet_A_MXN,2);
			$desglosePersona['Fechas'][$dailyRates->offset]['Menores'] = 0.00;
			$desglosePersona['Fechas'][$dailyRates->offset]['total'] = number_format($dailyNet_A_MXN,2);
			$desglosePersona['Fechas'][$dailyRates->offset]['moneda'] = $moneda;
			$totalHab+=$dailyNet_A_MXN;
		}

		$desglosePersona['Total']['total'] = number_format($totalHab,2);
		$desglosePersona['Total']['moneda'] = $moneda;

		return $desglosePersona;
	}

	public function offers($offers,$markup,$descripcionHabitacion,$r,$moneda){
		if($r==0)
			$ofertas="<h5>Ofertas</h5> ";
		$ofertas.="<table border='1' class='table-tooltip tableInfo'>
		<thead>
		<th colspan='2'>".$descripcionHabitacion."</th>
		</thead>
		<tbody>";
		foreach ($offers as $oferta) 
		{
			$importe=$oferta->amount/$markup;
			$ofertas.="<tr><td>".$oferta->name."</td><td>$ ".number_format($importe,2)." ".$moneda."</td></tr>";
		}
		$ofertas.="</tbody></table>";           

		return $ofertas;
	}

	public function offersHB($offers,$markup,$descripcionHabitacion,$r,$moneda){

		$ofertas = array();
		if($r==0)
			$ofertas['descripcion'] = $descripcionHabitacion;
		foreach ($offers as $off => $oferta) 
		{
			$importe=$oferta->amount/$markup;
			$ofertas['offers'][$off]['nombre'] = $oferta->name;
			$ofertas['offers'][$off]['descuento'] = number_format($importe,2);
			$ofertas['offers'][$off]['moneda'] = $moneda;
		}        

		return $ofertas;
	}

	public function promociones($promos,$descripcionHabitacion,$r){
		$promociones.='<table border="1" class="table-tooltip tableInfo">
		<thead>
		<th>'.$descripcionHabitacion.'</th>
		</thead>
		<tbody>';

		foreach ($promos as $promocion) {
			$name="";
			$remark="";
			if($promocion->name)
				$name=$promocion->name;
			if($promocion->remark)
				$remark=" - ".$promocion->remark;
			//$promociones.= $name.$remark." <br>";
			$promociones.='<tr><td>'.$name.$remark.'</td></tr>';
		}
		$promociones.='</tbody></table>';
		return $promociones;
	}

	public function promocionesHB($promos,$descripcionHabitacion,$r){
		$promociones=array();
		$promociones["descripcion"] = $descripcionHabitacion;

		foreach ($promos as $p => $promocion) {
			$name="";
			$remark="";
			if($promocion->name)
				$name=$promocion->name;
			if($promocion->remark)
				$remark=" - ".$promocion->remark;

			$promociones['promotions'][$p]['nombre'] = $name;
			$promociones['promotions'][$p]['descuento'] = $remark;
		}
		return $promociones;
	}

	public function extraeRatekey($rateKey){
		$rate=explode("|",$rateKey);
		$rate["codigo"]=$rate[6];
		$rate["paxs"]=$rate[9];
		$rate["edadesCh"]=$rate[10];
		return $rate;
	}

	public function rateComments($rateCommentsResponse){
		$rateCommentsArray=json_decode($rateCommentsResponse);
		$rate_Comments="Comentarios de la tarifa<br>";
		foreach ($rateCommentsArray->rateComments as $rateComments) 
		{
			$rate_Comments.=$rateComments->description."<br>";
		}
		return $rate_Comments;
	}

	/*public function actionBusquedaDestinos($destino) {
		$sql = "SELECT H.id_hotel, CONCAT(H.nombre_hotel, ', ', Z.name, ', ', D.name) AS 'Nombre', 'Hotel' AS 'Tipo' FROM tbl_hoteles H INNER JOIN zonasbeds Z ON Z.idZona = H.id_destino INNER JOIN destinations D ON D.code = Z.destinationsCode WHERE H.nombre_hotel LIKE '%". $destino ."%' GROUP BY H.nombre_hotel UNION SELECT Z.idZona AS 'Codigo', Z.name AS 'Nombre', 'Zona' AS 'Tipo' FROM zonasbeds Z WHERE Z.name LIKE '%". $destino ."%' UNION SELECT Z.idZona AS 'Codigo', CONCAT(Z.name, ', ', D.name) AS 'Nombre', 'Zona' AS 'Tipo' FROM destinations D INNER JOIN zonasbeds Z ON Z.destinationsCode = D.code WHERE D.name LIKE '%". $destino ."%' UNION SELECT D.code AS 'Codigo', D.name AS 'Destino', 'Destino' AS 'Tipo' FROM destinations D WHERE D.name LIKE '%". $destino ."%'";
		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
		echo CJSON::encode($model_destinos);
	}*/

	public function actionBusquedaDestinos($destino) {
		$sql = "SELECT H.id_hotel as 'Codigo', CONCAT(H.nombre_hotel,  ', ', D.name) AS 'Nombre', 'Hotel' AS 'Tipo' FROM tbl_hoteles H INNER JOIN zonasbeds Z ON Z.idZona = H.id_destino INNER JOIN destinations D ON D.code = Z.destinationsCode WHERE H.nombre_hotel LIKE '%". $destino ."%' AND H.estatus = 1 AND H.proveedor NOT IN(1,3) AND H.busqueda = 1 LIMIT 20 UNION  SELECT Z.idZona AS 'Codigo', Z.name AS 'Nombre', 'Zona' AS 'Tipo' FROM zonasbeds Z WHERE Z.name LIKE '%". $destino ."%' UNION SELECT Z.idZona AS 'Codigo', CONCAT(Z.name, ', ', D.name) AS 'Nombre', 'Zona' AS 'Tipo' FROM destinations D INNER JOIN zonasbeds Z ON Z.destinationsCode = D.code WHERE D.name LIKE '%". $destino ."%' UNION SELECT D.code AS 'Codigo', D.name AS 'Destino', 'Destino' AS 'Tipo' FROM destinations D WHERE D.name LIKE '%". $destino ."%'";
		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
		echo CJSON::encode($model_destinos);
	}

	public function actionBusquedaDestinosActivities($query) {
		$sql = "SELECT * FROM(SELECT AC.code, AD.destinationcode, CONCAT(AD.nombre, ', ', AC.nombre) AS 'destino' FROM tbl_act_countries AC INNER JOIN tbl_act_destinations AD ON AD.countrycode = AC.code WHERE AC.nombre LIKE '%". $query ."%' GROUP BY AD.nombre UNION SELECT AC.code, AD.destinationcode, CONCAT(AD.nombre, ', ', AC.nombre) AS 'destino' FROM tbl_act_countries AC INNER JOIN tbl_act_destinations AD ON AD.countrycode = AC.code WHERE AD.nombre LIKE '%". $query ."%' GROUP BY AD.nombre) AS destinations GROUP BY destino";
		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
		echo CJSON::encode($model_destinos);
	}

	public function actionBusquedaDestinosTours() {
		// $sql = "SELECT TC.idTipoCategoria AS 'codigo', TC.nombre AS 'nombre', 'tipo' AS 'tipo' FROM tbl_tipo_categoria TC UNION SELECT T.id_tour AS 'codigo', T.nombre AS 'nombre', 'tour' AS 'tipo' FROM tbl_tour T WHERE estatus = 1";
		// $model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
		// echo CJSON::encode($model_destinos);
		$sql = "SELECT TC.idTipoCategoria AS 'codigo', TC.nombre AS 'nombre', 'tipo' AS 'tipo' , TC.estatus FROM tbl_tipo_categoria TC UNION SELECT T.id_tour AS 'codigo', T.nombre AS 'nombre', 'tour' AS 'tipo' , T.estatus FROM tbl_tour T WHERE estatus = 1 AND busqueda=1";
		$model_destinos = Yii::app()->db->createCommand($sql)->queryAll();
		echo CJSON::encode($model_destinos);
	}

	public function actionFormBusqueda() {
		$array_form = array(
			"agencia_usuario" => $_POST["agencia_usuario"],
			"destino" => json_decode($_POST["destino"]),
			"fechas" => $_POST["fechas"],
			"habitaciones" => json_decode($_POST["habitaciones"]),
		);
		echo json_encode($array_form);
	}
}