<?php
Yii::import('application.extensions.bootstrap.gii.*');
// require_once('bootstrap/tcpdf/tcpdf.php');
require_once('bootstrap/tcpdf/config/lang/eng.php');

class CarritoController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'imprimircotizacion', 'addCarrito', 'deleteCarrito', 'emptyCarrito', 'echoCarrito', 'getCarrito', 'getInfoCotiz', 'test', 'fotosHotel', 'changeCurrency', 'getCurrency', 'echoSession', 'changeCountry'),
				'users' => array('@'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}
	/*public function actionDestino()
	{
	}*/

	public function actionChangeCountry() {
		session_start();
		if($_SESSION["agencia"]["id_pais_agencia"] == 146) {
			$_SESSION["estadoUsuario"] = 33;
			$_SESSION["agencia"]["id_estado_agencia"] = 33;
			$_SESSION["agencia"]["id_pais_agencia"] = 52;
			$country = Pais::model()->findByPk(52);
			$_SESSION["pais"] = array(
				'id_pais'    => $country->id_pais,
				'nombrePais' => $country->nombre_pais,
				'iso2_pais'  => $country->iso2_pais
			);
		} else {
			$_SESSION["estadoUsuario"] = 31;
			$_SESSION["agencia"]["id_estado_agencia"] = 31;
			$_SESSION["agencia"]["id_pais_agencia"] = 146;
			$country = Pais::model()->findByPk(146);
			$_SESSION["pais"] = array(
				'id_pais'    => $country->id_pais,
				'nombrePais' => $country->nombre_pais,
				'iso2_pais'  => $country->iso2_pais
			);
		}

		echo CJSON::encode($_SESSION);
	}

	public function actionIndex() {
		$this->layout = '//layouts/ansonika_site';
		//$this->layout = '//layouts/ansonika_site_currency';
		$this->render("index_currency");
	}

	public function actionTest() {
		$ch = curl_init("https://photos.hotelbeds.com/giata/medium/33/330664/330664a_hb_ro_015.JPG");
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_exec($ch);
		$response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		if ($response == 200) {
			echo "file exists";
		} else {
			echo $response;
		}
	}

	public function actionFotosHotel($id_hotel) {
		echo $_SERVER["DOCUMENT_ROOT"];
		/*$model_hoteles_fotos = HotelesFotos::model()->findAll("id_hotel = ". $id_hotel);
		echo CJSON::encode($model_hoteles_fotos);*/
	}

	public function actionGetInfoCotiz($request) {
		session_start();
		switch ($request) {
			case "hotel":
				$json = array();
				$json["front_form"] = $_SESSION["front_form"];
				$json["info_search"] = $_SESSION["info_search"];
				echo json_encode($json);
				break;

			case "activity":
				echo json_encode($_SESSION["searchAct"]);
				break;

			case "tour":
				echo json_encode($_SESSION["search_tour"]);
				break;
		}
	}

	public function actionGetCarrito() {
		session_start();
		if (empty($_SESSION['carrito'])) {
			$_SESSION['carrito'] = array();
		}
		echo json_encode($_SESSION['carrito']);
	}

	public function actionAddCarrito() {
		session_start();
		if (empty($_SESSION['carrito'])) {
			$_SESSION['carrito'] = array();
		}

		$request = json_decode($_POST["info"], true);
		/*print_r($_POST["info"]);
		exit;*/
		if ($request["tipo"] == "reserva") {
			$request["info_search"] = $_SESSION["info_search"];
		} else {
			if ($request["tipo"] == "activity") {
				$request["info_search"] = $_SESSION["searchAct"];
			} else {
				$request["info_search"] = $_SESSION["search_tour"];
			}
		}
		array_push($_SESSION['carrito'], $request);
		echo json_encode($_SESSION['carrito']);
	}

	public function actionDeleteCarrito() {
		session_start();
		array_splice($_SESSION['carrito'], $_POST["index"], 1);
		//unset($_SESSION['carrito'][$_POST["index"]]);
	}

	public function actionEmptyCarrito() {
		session_start();
		$_SESSION['carrito'] = array();
	}

	public function actionChangeCurrency() {
		session_start();
		$_SESSION["currency"] = $_POST["currency"];
	}

	public function actionGetCurrency() {
		session_start();
		echo json_encode(array(
			"currency" => "MXN"
		));
	}
	
	public function actionEchoSession() {
		session_start();
		echo json_encode($_SESSION);
	}

	public function actionEchoCarrito() {
		session_start();
		//echo json_encode($_SESSION);
		echo json_encode($_SESSION["carrito"]);
		/*foreach ($_SESSION['carrito'] as $key => $value) {
			echo json_encode($value["item"][$value["item"]["idHotel"]]["Habitaciones"][$value["hab"]]["Planes"][$value["plan_tarifa"]]["plan"]);
		}*/
	}

	public function actionImprimircotizacion($fotos = false, $observacion = false) {
		session_start();
		$nota = Politica::model()->findByPk(3);
		$cotizacion_ordenada = $_SESSION["carrito"];
		$array_cotizacion = json_decode($cotizacion->cotizacion, true);
		
		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Cotizacion');
		$pdf->SetSubject('Cotizacion');
		//$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
		//$pdf->SetMargins(15, 45, 15, 30, false);
		$pdf->SetMargins(15, 55, 15, TRUE);
		$pdf->SetHeaderMargin(10);
		$pdf->SetFooterMargin(30);
		$pdf->SetAutoPageBreak(TRUE, 30);
		$pdf->SetFont('helvetica', '', 10);

		$model_usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
		$pdf->footer_pdf = "
			<table>
				<tr>
					<td>Cotización generada: ". date("d/m/Y H:i:s") ." por ". $model_usuario->nombre_usuario ."</td>
				</tr>
				<tr>
					<td>
						* Precio sujetos a cambios sin previo aviso.
					</td>
				</tr>
				<tr>
					<td>
						* Estancia sujeta a disponibilidad y revisión por parte del ejecutivo.
					</td>
				</tr>
				<tr>
					<td>". $nota->descripcion ."</td>
				</tr>
			</table>";

		$model_agencia = Agencias::model()->findByPk($model_usuario->id_agencia);
		$estado = Estadosmex::model()->findByPk($model_agencia->id_estado_agencia);
		$pais = Pais::model()->findByPk($model_agencia->id_pais_agencia);
		$code_ua = "U". $model_usuario->id_usuario ."A". $model_agencia->id_agencia;

		$agency_logo = $_SERVER['DOCUMENT_ROOT'] ."/imagenes/" . $model_agencia->foto;
		if(empty($model_agencia->foto) || !is_readable($_SERVER['DOCUMENT_ROOT'] ."/imagenes/". $model_agencia->foto)) {
			$agency_logo = "https://rutamayatravel.com/images/logo-agencia-no-definido.png";
		}
		$tel_agencia = strlen($model_agencia->tel_agencia) == 10 ? ("(". substr($model_agencia->tel_agencia, 0, 3) . ")" . substr($model_agencia->tel_agencia, 3, 10)) : $model_agencia->tel_agencia;
		$created_by = $model_usuario->nombre_usuario;
		$header_agency = '<div align="center"><img height="40" src="'. $agency_logo .'"><br><b>'. $model_agencia->nombre_agencia .'</b><br>
		Calle '. $model_agencia->calle_agencia .' No. '. $model_agencia->num_exterior_agencia .' Colonia '. $model_agencia->id_colonia_agencia .'<br>'. $model_agencia->id_ciudad_agencia .', '. $estado->nombreestado .' '. $pais->nombre_pais .'<br>Tel. '. $tel_agencia .'</div>';

		foreach ($_SESSION["carrito"] as $key => $value) {
			if($value["tipo"] == "reserva") {
				$html = $this->renderPartial('//cotizacion/cotizacion_item', array(
					'value' => $value,
					'add_price' => null,
					'price_type' => "none",
					'code_ua' => $code_ua,
					'fotos' => $fotos,
					'observacion' => $observacion,
					'desglose' => true
				), true);

				$id_hotel = $value["prov"] == 3 ? $value["item"]["idHotel"] : $value["item"]["id_hotel"];
				$foto_hotel = HotelesFotos::model()->find('id_hotel='. $id_hotel .' AND logotipo = 1');
				$calle_hotel = Hoteles::model()->findByPk($id_hotel)->calle_hotel;
				$info_img = explode(".", $foto_hotel->foto);
				if (empty($foto_hotel->foto) || !is_readable($_SERVER['DOCUMENT_ROOT'] . 'imagenes/' . $foto_hotel->foto) || $info_img[1] == "webp") {
					$hotel_logo = "https://rutamayatravel.com/images/hotel-no-definido.png";
				} else {
					$hotel_logo = $_SERVER['DOCUMENT_ROOT'] . 'imagenes/' . $foto_hotel->foto;
				}

				if(gettype($value["item"]["estrellas"]) == "integer") {
					$category = "";
					for ($i = 0; $i < $value["item"]["estrellas"]; $i++) { 
						$category .= "* ";
					}
				} else {
					$category = $value["item"]["estrellas"];
				}
				$direccion_hotel = ucwords(strtolower($calle_hotel)); // str_replace(",", "<br>", $direccion_hotel)
				$header_hotel = '<div align="center" style="width: 100%;"><img height="40" src="'. $hotel_logo .'"><br><span style="font-size: 16px;">'. $category .'</span><br><b style="font-size:12px;">'. $value["item"]["nombre_hotel"] .'</b><br>'. $direccion_hotel .'<br></div>';
				$pdf_header = "<table><tr><td>". $header_agency ."</td><td>". $header_hotel ."</td></tr></table><hr>";
			} else if($value["tipo"] == "tour") {
				$html = $this->renderPartial('//cotizacion/cotizacion_item_tour', array(
					'value' => $value,
					'add_price' => null,
					'price_type' => "none",
					'code_ua' => $code_ua,
					'fotos' => $fotos,
					'observacion' => $observacion,
					'desglose' => true
				), true);
				$tour_logo = "https://rutamayatravel.com/images/tour-logo.jpg";
				$header_tour = '<div align="center" style="width: 100%;"><img height="40" src="'. $tour_logo .'"><br><b>'. $value["item"]["nombre"] .'<br>'. $value["item"]["tipo"] .'</b></div>';
				$pdf_header = "<table><tr><td>". $header_agency ."</td><td>". $header_tour ."</td></tr></table><hr>";
				$pdf->SetMargins(15, 40, 15, TRUE);
			} else {
				$html = $this->renderPartial('//cotizacion/cotizacion_item_activity', array(
					'value' => $value,
					'add_price' => null,
					'price_type' => "none",
					'code_ua' => $code_ua,
					'fotos' => $fotos,
					'observacion' => $observacion,
					'desglose' => true
				), true);
				$activity_logo = "https://rutamayatravel.com/images/activity-logo.png";
				$header_activity = '<div align="center" style="width: 100%;"><img height="40" src="'. $activity_logo .'"><br><b>'. $value["item"]["name"] .'</b></div>';
				$pdf_header = "<table><tr><td>". $header_agency ."</td><td>". $header_activity ."</td></tr></table><hr>";
				$pdf->SetMargins(15, 40, 15, TRUE);
			}
			
			$pdf->pdf_header = $pdf_header;
			$pdf->AddPage('P', 'LETTER');
			$pdf->writeHTML($html, true, false, true, false, '');
		}

		if(count($_SESSION["carrito"]) == 0) {
			$html = "<h1>No tiene artículos en su carrito o su sesión expiró.</h1>";
			$pdf->AddPage('P', 'LETTER');
			$pdf->writeHTML($html, true, false, true, false, '');
		}
		$pdf->LastPage();
		$pdf->Output("Cotizacion_001.pdf", "I");
	}

	function priceToFloat($s) {
		// convert "," to "."
		$s = str_replace(',', '.', $s);
	
		// remove everything except numbers and dot "."
		$s = preg_replace("/[^0-9\.]/", "", $s);
	
		// remove all seperators from first part and keep the end
		$s = str_replace('.', '',substr($s, 0, -3)) . substr($s, -3);
	
		// return float
		return (float) $s;
	}

	function getFotosAPIRentas($id,$tourOperador)
	{
		$tourFotosRestController  = Yii::app()->createController('tourFotosRest');
		$tourFotosRestController  = $tourFotosRestController[0];
		$data					  =	$tourFotosRestController->getProduct($id,$tourOperador);
		return $data;
	}
	
	function printPrecio($price, $add_price, $price_type) {
		if(isset($add_price)) {
			$new_price = $this->priceToFloat($price);
			if($price_type == "percentage") {
				$quantity = $this->priceToFloat($add_price) / 100;
				$new_price = $new_price * (1 + $quantity);
			} else if($price_type == "price") {
				$new_price = $new_price + $this->priceToFloat($add_price);
			}
			
			return number_format($new_price, 2);
		}
		return $price;
	}

	function dateDifference($date_1, $date_2, $differenceFormat = '%a') {
		$date1 = implode("-", array_reverse(explode("/", $date_1)));
		$date2 = implode("-", array_reverse(explode("/", $date_2)));
		$datetime1 = date_create($date1);
		$datetime2 = date_create($date2);

		$interval = date_diff($datetime1, $datetime2);

		return $interval->format($differenceFormat);
	}

	function printTotalCotiz($planes, $prov) {
		$total = 0;
		foreach ($planes as $plan) {
			$monto = floatval(str_replace(",", "", $plan["precio"]));
			$total += $monto;
		}
		return number_format($total, 2);
	}

	function getTotalTour($tarifa, $info_search, $hay_descuento) {
		$total = 0;
		$precio_adulto = 0;
		foreach ($tarifa["desglose"] as $key => $value) {
			if ($value["tipo"] == "Adulto") {
				$precio_adulto = $value["precio"];
				$total += $value["precio"] * $info_search["num_adultos"];
			} else {
				for ($i = 1; $i <= $info_search["num_ninios"]; $i++) {
					if ($info_search["num_edad"]["edad_" . $i] >= $value["edad_min"] && $info_search["num_edad"]["edad_" . $i] <= $value["edad_max"]) {
						$total += $value["precio"];
					} else if ($info_search["num_edad"]["edad_" . $i] > $value["edad_max"]) {
						$total += $precio_adulto;
					}
				}
			}
		}

		if($info_search['destino']!='c_8') $total = $total * (float) $tarifa['tasa_cambio'];

		if ($hay_descuento == true) {
			$$total_discount = 0;
			$total_discount = $total * 0.10;
			$total = $total - $total_discount;
		}
		return number_format($total, 2);
	}

	function getMonedaTour($tarifas) {
		$moneda = $tarifas["moneda"];
		if ($tarifas["moneda"] == "USD" && (float) $tarifas["tasa_cambio"] > 1) {
			$moneda = "MXN";
		}
		return $moneda;
	}

	function checkFileExists($url_img) {
		$ch = curl_init($url_img);
		curl_setopt($ch, CURLOPT_NOBODY, true);
		curl_exec($ch);
		$response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
		curl_close($ch);
		if ($response == 200) {
			return true;
		} else {
			return false;
		}
	}

	public function actionImprimircotizacionV1($fotos = false, $observacion = false) {
		session_start();
		$nota = Politica::model()->findByPk(3);
		$html = $this->renderPartial('cotizacion', array(
			'model' => $_SESSION["carrito"],
			'nota' => $nota->descripcion,
			'fotos' => $fotos,
			'observacion' => $observacion
		), true);
		$pdf = new MYPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('Cotizacion');
		$pdf->SetSubject('Cotizacion');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE, PDF_HEADER_STRING);
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 35, 15);
		$pdf->SetHeaderMargin(25);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 20);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("Cotizacion_001.pdf", "I");
	}
}

// class MYPDF extends TCPDF {
// 	public $header_pdf;
// 	public $footer_pdf;

// 	//Page header
// 	public function Header() {
// 		$this->SetFont('helvetica', '', 10);
//         $this->writeHTML($this->pdf_header, false, true, false, true);
// 	}

// 	public function Footer() {
// 		$this->SetFont('helvetica', '', 10);
//         $this->writeHTML($this->footer_pdf, false, true, false, true);
// 	}
// }