<?php
/*require_once('../api/banxico/tipocambio.php');
require_once('../api/banxico/BanamexApi.php');*/

class DashboardController extends Controller
{
	public $layout = '//layouts/altair';


	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}
	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index'),
				'users' => array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('tasaCambioActual'),
				'users'=>array('*'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actionTasaCambioActual() {
		$tasa_cambio = $this->tasaCambioActual();
		echo json_encode($tasa_cambio);
	}

 	public function tasaCambioActual() {
		$criteria = new CDbCriteria();
		$criteria->condition = "id_pais = 75"; //id_pais EU
		$criteria->order = "id_tasa_cambio DESC";
		$tasa = TasaCambio::model()->find($criteria);

		$criteria_cop = new CDbCriteria();
		$criteria_cop->condition = "id_pais = 52"; //id_pais COL
		$criteria_cop->order = "id_tasa_cambio DESC";
		$tasa_cop = TasaCambio::model()->find($criteria_cop);
		if ($tasa) {
			$tasaArray = array(
				'compra' => $tasa->compra,
				'importe' => ($tasa->importe),
				'usuario' => ($tasa->idUser->nombre_usuario),
				'fecha' => (date('d/m/y H:i', strtotime($tasa->log))),

				'cop_compra' => $tasa_cop->compra,
				'cop_venta' => $tasa_cop->importe,
			);
		} else {
			$tasaArray=false;
		}
		return $tasaArray;
	}
}
