<?php
// error_reporting(E_ALL & ~E_NOTICE);
require_once($_SERVER["DOCUMENT_ROOT"] . "/func.inc.php");
require_once __DIR__ . '/../vendors/autoload.php';
class FormatosController extends Controller
{
	/**
	 * Declares class-based actions.
	 */
	public function actions()
	{
		return array(
			// captcha action renders the CAPTCHA image displayed on the contact page
			'captcha' => array(
				'class' => 'CCaptchaAction',
				'backColor' => 0xFFFFFF,
			),
			// page action renders "static" pages stored under 'protected/views/site/pages'
			// They can be accessed via: index.php?r=site/page&view=FileName
			'page' => array(
				'class' => 'CViewAction',
			),
		);
	}
	/**
	 * This is the default 'index' action that is invoked
	 * when an action is not explicitly requested by users.
	 */
	public function actionIndex()
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$this->render('index');
	}
	public function actionCotizacion()
	{
		echo "<pre>";
		print_r($_POST);
		echo "</pre>";
		$this->render('index');
	}
	public function actionEnviarproforma($id)
	{
		if (isset($_POST["email"], $_POST["fechalimite"], $_POST["fechalimite_h"])) {
			$fechalimite = implode('-', array_reverse(explode('/', $_POST["fechalimite"])));
			$fechalimite_h = implode('-', array_reverse(explode('/', $_POST["fechalimite_h"])));
			$sql = "update tbl_reservacion set fecha_limite_old=fecha_limite, fecha_limite='" . $fechalimite . "', fecha_limite_h='" . $fechalimite_h . "' where id_reservacion=" . $id . ";";
			$command = Yii::app()->db->createCommand($sql)->execute();
			$encabezados  = "MIME-Version: 1.0\n";
			$encabezados .= "Content-type: text/html; charset=UTF-8\n";
			$encabezados .= "From:  Ruta Maya Travel <no-reply@rutamayatravel.com>\n";
			$encabezados .= "X-Sender: <contacto web>\n";
			$encabezados .= "X-Mailer: PHP\n";
			$encabezados .= "X-Priority: 3\n";
			$encabezados .= "Return-Path: <web page>\n";
			$recipent = $_POST["email"];
			$subject = "Proforma";
			$message = "<div align='center' width='400' style='border:1px solid black'>
							<img src='http://" . $_SERVER['SERVER_NAME'] . "/outlet/images/logo_rutamaya.jpg'>
							<h4>SE HA GENERADO UNA ORDEN DE PAGO PARA LA RESERVACION #" . $id . "</h4><hr>
							<p>Fecha: " . date('d/m/Y') . "</p>
							<p>Reservacion: #" . $id . "</p>
							<p><strong>Fecha Límite:</strong> " . $_POST["fechalimite"] . "</p>
							<p><a href='http://" . $_SERVER['SERVER_NAME'] . "/reservaciones/yii_rutamaya/index.php/site/proforma/" . $id . "'>Descargar Orden de Pago</a></p>
							<h4>SI TIENES ALGUNA DUDA CONTÁCTANOS, CON GUSTO TE ASESORAREMOS</h4>
							<h4>Atentamente el equipo de Ruta Maya Travel</h4>
						</div>";
			Yii::import('application.extensions.phpmailer.JPhpMailer');
			$mail = new JPhpMailer;
			$mail->IsSMTP();
			$mail->Host = 'rutamayatravel.com';
			$mail->SMTPAuth = true;
			$mail->Username = 'no-reply@rutamayatravel.com';
			$mail->Port = '26';
			$mail->Password = 'Intelred76';
			$mail->SMTPKeepAlive = true;
			$mail->Mailer = "smtp";
			$mail->IsSMTP(); // telling the class to use SMTP  
			$mail->SMTPAuth   = true;
			$mail->CharSet = 'utf-8';
			$mail->SMTPDebug  = 0;
			$mail->SetFrom('no-reply@rutamayatravel.com', 'Sistema Ruta Maya Travel');
			$mail->Subject = $subject;
			$mail->AltBody = 'To view the message, please use an HTML compatible email viewer!';
			$mail->MsgHTML($message);
			$mail->AddAddress($recipent, $recipent);
			// $mail->AddAddress('contabilidad@rutamayatravel.com', 'Contabilidad RutaMayaTravel');
			$mail->Send();
			$this->actionProforma($id);
		}
	}
	public function actionProforma($id)
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '<table><tr><td><img src="https://rutamayatravel.com/reservaciones/images/pakal.jpg"></td></tr></table>';
		$footer = '<table width="100%" border="0"><tr>&nbsp;<td></td><td width="250" style="text-align:right; font-family:Arial, Helvetica, sans-serif; font-size:12px;border-color:#000000;"></td></tr></table>';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		$mPDF1->WriteHTML($stylesheet, 1);
		$reservacion = new ReservacionManager($id);
		$agencia = $reservacion->getAgencia();
		$usuario = $reservacion->getUsuario();
		$hotel = $reservacion->getHotel();
		$destino = $hotel->getDestino();
		$ocupaciones = $reservacion->getOcupaciones();
		$habitaciones = array();
		$total_adultos = 0;
		$total_menores = 0;
		if ($agencia->data->foto != '') {
			$logo_agencia = "../../imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = "../reservaciones/images/sinlogo.png";
		}
		foreach ($ocupaciones->data as $o) {
			$arr_edades = array();
			$OcupacionesPersona = new OcupacionPersonaManager(array("tipo" => 'id_ocupacion', 'param' => $o->id_desglose)); //Devuelve los menores para la ocupacion solicitada
			foreach ($OcupacionesPersona->data as $op) {
				if ($op->tipo != 'A') {
					$arr_edades[] = $op->edad;
					$total_menores++;
				} else {
					$total_adultos++;
				}
			}
			$hab = array(
				'base' => $o->baseHabitacion->base_habitacion,
				'tipo' => $o->tipoHabitacion->tipo_habitacion,
				'num_adultos' => $o->num_adultos,
				'num_menores' => $o->num_ninios,
				'edades' => join(",", $arr_edades),
			);
			$habitaciones[] = $hab;
		}
		if ($reservacion->data->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			$estatus_reserva = '';
		}

		$criteria_outlet = new CDbCriteria();
		$criteria_outlet->addCondition('tipo= "VIRTUAL"');
		$criteria_outlet->addCondition('estatus= 1');
		// $criteria_outlet->addBetweenCondition('fecha_inicio', "2020-02-27", "2020-03-09");
		$model_outlet = Outlet::model()->find($criteria_outlet);

		($reservacion->data->code != '') ? $clave_confirmacion = $reservacion->data->code : $clave_confirmacion = 'N/A';
		$pagos = ReciboDetalles::model()->with('idRecibo')->findAll('estado!="C" and id_reservacion=' . $id);
		$data = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'fecha' => $reservacion->data->log, //;strftime("%d-%b-%Y", strtotime(date('Y-m-d'))),
			'estatus_outlet' => $model_outlet->estatus,
			'outlet_inicio' => $model_outlet->fecha_inicio,
			'outlet_final' => $model_outlet->fecha_final,							
			'hotel_proveedor' => $hotel->data->proveedor,
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan()->data->nombre,
			'fecha_entrada' => myDate($reservacion->data->fecha_inicial),
			'fecha_salida' => myDate($reservacion->data->fecha_final),
			'clave_confirmacion' => $clave_confirmacion,
			'fecha_limite' => $reservacion->data->fecha_limite,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => myPhone($agencia->data->tel_agencia),
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destino' => $destino->data->destino,
			'tel_hotel' => myPhone($hotel->data->tel_hotel1),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'num_noches' => $reservacion->data->num_noches,
			'observaciones' => $reservacion->observaciones,
			'comision_agencia' => $reservacion->data->comision,
			'importe' => $reservacion->data->total,
			'pagos' => $pagos,
		);
		$mPDF1->WriteHTML($this->renderPartial('documentos/proforma', $data, true));
		$mPDF1->Output();
		/*$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <soporte@rutamayatravel.com>\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$recipent = $_POST["email"];
		$subject = "Proforma";
		$message = "Descarga Proforma: <a href='http://www.reservaciones.rutamayatravel.com/yii_rutamaya/index.php/site/proforma/".$reservacion->id."'></a>";
		mail($recipent,$subject,$message,$encabezados);*/
	}
	public function actionCupon2($id)
	{
		$session = new CHttpSession;
		$session->open();
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		/*$header = '<table><tr><td><img src="' . $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/images/pakal.jpg"></td></tr></table>';*/

		$header = '';
		$footer = '';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = new \Mpdf\Mpdf();
		// $mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		//$mPDF1->WriteHTML($stylesheet, 1);
		$reservacion = new ReservacionManager($id);
		$agencia = $reservacion->getAgencia();
		$usuario = $reservacion->getUsuario();
		$hotel = $reservacion->getHotel();
		$destino = $hotel->getDestino();
		$ocupaciones = $reservacion->getOcupaciones();
		$habitaciones = array();
		$total_adultos = 0;
		$total_menores = 0;

		// die($_SERVER['SERVER_NAME']);
		$imagen_validada = $this->validarNombreImagen($agencia->data->foto);
		if ($imagen_validada == 1 && !is_null($imagen_validada)) {
			$logo_agencia = 'https://' . $_SERVER['SERVER_NAME'] . "/imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = '';
		}
		foreach ($ocupaciones->data as $o) {
			$arr_edades = array();
			$arr_nom_adultos = array();
			$OcupacionesPersona = new OcupacionPersonaManager(array("tipo" => 'id_ocupacion', 'param' => $o->id_desglose)); //Devuelve los menores para la ocupacion solicitada
			foreach ($OcupacionesPersona->data as $op) {
				if ($op->tipo != 'A') {
					$arr_edades[] = $op->edad;
					$total_menores++;
				} else {
					$arr_nom_adultos[] = $op->nombre;
					$total_adultos++;
				}
			}
			$hab = array(
				'base' => $o->baseHabitacion->base_habitacion,
				'tipo' => $o->tipoHabitacion->tipo_habitacion,
				'num_adultos' => $o->num_adultos,
				'num_menores' => $o->num_ninios,
				'edades' => join(",", $arr_edades),
				'nombres' => join(" / ", $arr_nom_adultos),
			);
			$habitaciones[] = $hab;
		}
		if ($reservacion->data->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			if ($reservacion->data->saldo > 0 and $reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('PENDIENTE DE PAGO');
				$mPDF1->showWatermarkText = true;
			}
			$estatus_reserva = '';
		}


		($reservacion->data->code != '') ? $clave_confirmacion = $reservacion->data->code : $clave_confirmacion = 'N/A';
		($hotel->data->proveedor == 1) ? $categoria_hotel = $hotel->data->estrellas : $categoria_hotel = $hotel->data->id_categoria;
		$reservacionController = Yii::app()->createController('Reservacion');
		$reservacionController = $reservacionController[0];
		$categoria_hotel = $reservacionController->loadModelCategoria(Hoteles::model()->findByPk($reservacion->data->id_hotel));

		$qr_liga = false;
		if ($reservacion->data->estatus != 'C' || $reservacion->data->estatus != 'PH') {
			$tiposBanco = array('1' => 'bancomer', '2' => 'santander');

			if ($reservacion->data->saldo > 0) {
				$liga_exist = MITLiga::model()->findAll('importe LIKE "' . round($reservacion->data->saldo, 1) . '" AND referencia=' . $reservacion->id . ' AND estatus="PENDIENTE"');

				$qr_liga = true;
				if (count($liga_exist) == 0 || empty($liga_exist)) {
					foreach ($tiposBanco as $key => $value) {
						$liga_generada[$key]['cupon'] = $this->generarLiga($reservacion->id, $key);
					}
				} else {
					foreach ($liga_exist as $key => $value) {
						$liga_generada[$value->banco]['cupon'] = $value->id_MIT;
					}
				}
			}
		}
		$criteria_outlet = new CDbCriteria();
		//$criteria_outlet->addCondition('tipo= "VIRTUAL" || tipo="MEGA OUTLET"');
		$criteria_outlet->addCondition('tipo = "VERANO"');
		$criteria_outlet->addCondition('estatus= 1');
		// $criteria_outlet->addBetweenCondition('fecha_inicio', "2020-02-27", "2020-03-09");
		$model_outlet = Outlet::model()->find($criteria_outlet);



		$data = array(
			'id_reservacion' => $reservacion->id,
			'outlet_model' => $model_outlet,
			'id_bloqueo' => Reservacion::model()->findByPk($reservacion->id)->id_bloqueo,
			'estatus_cupon' => $estatus_reserva,
			'fecha_reservacion' => strftime("%Y-%m-%d", strtotime($reservacion->data->log)),
			'estatus_outlet' => $model_outlet->estatus,
			'outlet_inicio' => $model_outlet->fecha_inicio,
			'outlet_final' => $model_outlet->fecha_final,
			'hotel_proveedor' => $hotel->data->proveedor,
			'tarifa' => $reservacion->data->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->data->log)),
			'fecha_liberacion' => empty($reservacion->data->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->data->fecha_liberacion)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan(),
			'fecha_entrada' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_inicial))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->data->destinationsCode0->name,
			'destiny' => $destino->data->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => $reservacion->data->politicas_cancelacion,
			'supplier' => $reservacion->getSupplier(),
			'desglose_rate' => $reservacion->data->desglose_rate,
			'id_agencia' => $agencia->data->id_agencia,
			'id_pais_agencia' => $agencia->data->id_pais_agencia,
			'liga_generada' => $liga_generada,
			'qr_liga' => $qr_liga
		);

		$dataCliente = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'tarifa' => $reservacion->data->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->data->log)),
			'fecha_liberacion' => empty($reservacion->data->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->data->fecha_liberacion)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan(),
			'fecha_entrada' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_inicial))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->data->destinationsCode0->name,
			'destiny' => $destino->data->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => $reservacion->data->politicas_cancelacion,
			'supplier' => $reservacion->getSupplier(),
			'desglose_rate' => $reservacion->data->desglose_rate,
			'cliente' => 1
		);
		/*if($_SESSION["tipoUsuario"]=="Admon" || $_SESSION["tipoUsuario"]=="Finanzas" || ($_SESSION["tipoUsuario"]=="Agencia" && $_SESSION["agenciaUsuario"]==$agencia->data->id_agencia)) {*/

		if ($_SESSION["tipoUsuario"] != "Agencia" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $agencia->data->id_agencia)) {

			/*if($reservacion->libera_cupon==1){
			$mPDF1->WriteHTML($this->renderPartial('documentos/cupon',$data, true));
			$mPDF1->Output();
			}
			else
			{
				echo "Cupón no liberado";
			}*/
			$html = $this->renderPartial('documentos/cupon', $data, true);
			//$html2=$this->renderPartial('documentos/cuponcliente',$dataCliente, true);
			$mPDF1->WriteHTML($html);
			$mPDF1->AddPage();

			if ($reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('ORIGINAL');
				$mPDF1->showWatermarkText = true;
			}
			$mPDF1->WriteHTML($html);
			$mPDF1->Output();
		}
	}

	public function actionCupon($id)
	{
		$session = new CHttpSession;
		$session->open();

		$reservacion = Reservacion::model()->findByPk($id);
		$agencia = Agencias::model()->findByPk($reservacion->id_agencia);
		$hotel = Hoteles::model()->findByPk($reservacion->id_hotel);
		$destino = Zonasbeds::model()->findByPk($hotel->id_destino);
		$country = Countries::model()->find('code = "' . $destino->destinationsCode0->countryCode . '"');
		$desglose = ReservacionDesglose::model()->findAll("id_reservacion = " . $id);

		$data = array(
			"reservacion" 	=> $reservacion,
			"agencia"		=> $agencia,
			"hotel"			=> $hotel,
			"destino"		=> $destino,
			"country"		=> $country,
			"desglose"		=> $desglose
		);

		// Path de la imagen de marca de agua
		$imagen_fondo = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . "/img/icono-maleta.png";
		$logo = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/logo_uvac_outlet.svg";
		// Configurar encabezado y pie de página (opcional)
		$header = $this->renderPartial("documentos/_header_cupon", array(
			"reservacion" => $reservacion,
			"agencia" => $agencia,
			"imagen_fondo" => $imagen_fondo,
			"logo" => $logo,
		), true);

		$footer = '<div style="text-align: right; font-style: italic; font-size: 10px;">Pag. {PAGENO} UVAC ONLINE / Tel: 2960931 / Boulevard Miguel Alemán #82 Int. Tercer piso Local 15 Col. Boca del Rio centro 94290 Boca, Veracruz, Mexico <br>Código Interno: 538191</div>';

		// Crear instancia de mPDF
		$mPDF1 = new \Mpdf\Mpdf([
			'default_font' => 'Arial',
			'margin_left' => 15,
			'margin_right' => 15,
			'margin_top' => 60,
			'margin_bottom' => 20,
			'margin_header' => 10,
			'margin_footer' => 10,
			'watermark_text_alpha' => 0.2, // Marca de agua más transparente
			'shrink_tables_to_fit' => true // Ajustar tablas para evitar desbordamientos
		]);

		// $mPDF1->fontdata['nunito'] = [
		// 	'R' => 'nunito.ttf',  // Archivo para la fuente regular
		// ];
		// $mPDF1->SetFont('arial');

		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);

		// Ajustar el tamaño y la posición de la imagen como marca de agua
		$mPDF1->SetWatermarkImage($imagen_fondo, 0.1, '', array(130, 80), 50); // El último parámetro es la escala de la imagen
		$mPDF1->showWatermarkImage = true;

		// Renderizar HTML y añadir contenido al PDF
		$html = $this->renderPartial('documentos/cuponuvac', $data, true);
		$mPDF1->WriteHTML($html);
		// $mPDF1->AddPage();

		// $mPDF1->WriteHTML($html);
		$mPDF1->Output();
	}

	// $session = new CHttpSession;
	// $session->open();
	
	// $model = ReservacionTraslado::model()->findByPk($id);
	// $data = [
	// 	"text" => "prueba"
	// 	//asignar valores
	// ];
	

	public function actioncupontraslado($id)	{
    // Inicializar sesión
	$session = new CHttpSession;
		$session->open();
		$model = ReservacionTraslado::model()->findByPk($id);
		// $reservacion = Reservacion::model()->findByPk($id);
		// $agencia = Agencias::model()->findByPk($reservacion->id_agencia);
		// $hotel = Hoteles::model()->findByPk($reservacion->id_hotel);
		// $destino = Zonasbeds::model()->findByPk($hotel->id_destino);
		// $country = Countries::model()->find('code = "' . $destino->destinationsCode0->countryCode . '"');
		// $desglose = ReservacionDesglose::model()->findAll("id_reservacion = " . $id);

		$data = array(
			'name' => $model->name,
			'phone' => $model->phone,
			'email' => $model->email,
			'lastname' => $model->lastname,
			'moneda' => $model->moneda,
			'tipo_traslado' => $model->tipo_traslado,
			'tipo_vehiculo' => $model->tipo_vehiculo,
			'numero_de_pasajeros' => $model->numero_de_pasajeros,
			'aeropuerto' => $model->aeropuerto,
			'hotel' => $model->hotel,
			'precio_total' => $model->precio_total,
			'total_neto' => $model->total_neto,
			'codigo_vuelo_ida' => $model->codigo_vuelo_ida,
			'nombre_vehiculo' => json_decode($model->booking)->nombrevehiculo,
			'categoria_vehiculo' => json_decode($model->booking)->categoriavehiculo,
			'cantidad_personas' => json_decode($model->booking)->cantidadpersonas,
			'maletas_permitidas' => json_decode($model->booking)->maletaspermitidas,
			'codigo_vuelo' => json_decode($model->booking)->codigovuelo,
			'precio_viaje' => json_decode($model->booking)->precioviaje,
			'tipo_moneda' => json_decode($model->booking)->tipomoneda,
			'imagen' => json_decode($model->booking)->imagen,
			'referencia' => $model->referencia,
			'codigo_vuelo_ida' => $model->codigo_vuelo_ida,
			'codigo_vuelo_regreso' => $model->codigo_vuelo_regreso,
		);

		// Path de la imagen de marca de agua
		$imagen_fondo = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . "/img/icono-maleta.png";
		$logo = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/logo_uvac_outlet.svg";
		// Configurar encabezado y pie de página (opcional)
		$header = $this->renderPartial("documentos/_header_cupontraslado", array(
			'referencia' => $model->referencia,
			"agencia" => $agencia,
			"imagen_fondo" => $imagen_fondo,
			"logo" => $logo,
		), true);

		$footer = '<div style="text-align: right; font-style: italic; font-size: 10px;">Pag. {PAGENO} UVAC ONLINE / Tel: 2960931 / Boulevard Miguel Alemán #82 Int. Tercer piso Local 15 Col. Boca del Rio centro 94290 Boca, Veracruz, Mexico <br>Código Interno: 538191</div>';

		// Crear instancia de mPDF
		$mPDF1 = new \Mpdf\Mpdf([
			'default_font' => 'Arial',
			'margin_left' => 15,
			'margin_right' => 15,
			'margin_top' => 60,
			'margin_bottom' => 20,
			'margin_header' => 10,
			'margin_footer' => 10,
			'watermark_text_alpha' => 0.2, // Marca de agua más transparente
			'shrink_tables_to_fit' => true // Ajustar tablas para evitar desbordamientos
		]);

		// $mPDF1->fontdata['nunito'] = [
		// 	'R' => 'nunito.ttf',  // Archivo para la fuente regular
		// ];
		// $mPDF1->SetFont('arial');

		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);

		// Ajustar el tamaño y la posición de la imagen como marca de agua
		$mPDF1->SetWatermarkImage($imagen_fondo, 0.1, '', array(130, 80), 50); // El último parámetro es la escala de la imagen
		$mPDF1->showWatermarkImage = true;

		// Renderizar HTML y añadir contenido al PDF
		$html = $this->renderPartial('documentos/cupontraslado', $data, true);
		$mPDF1->WriteHTML($html);
		// $mPDF1->AddPage();

		// $mPDF1->WriteHTML($html);
		$mPDF1->Output();
	}
	// $html = $this->renderPartial('documentos/cupontraslado', $data, true);
	// $model = ReservacionTraslado::model()->findByPk($id);


	public function actionCuponRoom($id)
	{
		//roominglist model
		//components/roomingManager
		
		$session = new CHttpSession;
		$session->open();
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		/*$header = '<table><tr><td><img src="' . $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/images/pakal.jpg"></td></tr></table>';*/

		$header = '';
		$footer = '';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		//$mPDF1->WriteHTML($stylesheet, 1);
		$bloqueosControl=Yii::app()->createController('bloqueos')[0];
		$RoomingManager = new RoomingManager($id);
		$roomingList=Roominglist::model()->findByPk($id);
		$roomingDesglose=RoominglistDesglose::model()->findAll('id_roominglist='.$id);
		$roomingLog=RoominglistLog::model()->find('id_roominglist='.$id.' and movimiento="Liberar Cupon"',array('order'=>'id_log DESC'));
		//$reservacion = new ReservacionManager($id);
		$bloqueo =$roomingList->idBloqueo;
		$agencia = $RoomingManager->getAgencia();
		$usuario = $RoomingManager->getAgente();
		$hotel = $RoomingManager->getHotel();
		$destino = $hotel->Destino;
		$ocupaciones = $roomingDesglose;
		$habitaciones = array();
		$total_adultos = 0;
		$total_menores = 0;
		$prefijo= substr($bloqueo->idTarifa->precio, 0,1);
		if ($agencia->data->foto != '') {
			$logo_agencia = 'https://'.$_SERVER['SERVER_NAME'] . "/imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = 'https://'.$_SERVER['SERVER_NAME'] . "/reservaciones/images/sinlogo.png";
		}
		
			$arr_edades = array();
			$arr_nom_adultos = array();
			foreach ($roomingDesglose as $op) {
				if ($op->tipo != 'A') {
					$arr_edades[] = $op->edad;
					$total_menores++;
				} else {
					$arr_nom_adultos[] = $op->nombre.' '.$op->apellido;
					$total_adultos++;
				}
			}
			$tipoHab = $bloqueo->idHab->tipo_habitacion;
			if ($roomingList->id_tipo_habitacion !== null) {
				$tipoHab = TipoHabitaciones::model()->findByPk($roomingList->id_tipo_habitacion)->tipo_habitacion;
			}
			$hab = array(
				'base' => $roomingList->id_base_habitacion,
				'tipo' => $tipoHab,
				'num_adultos' => $total_adultos,
				'num_menores' => $total_menores,
				'edades' => join(",", $arr_edades),
				'nombres' => join(" / ", $arr_nom_adultos),
			);
			$habitaciones[] = $hab;
			$infoPagos=$bloqueosControl->saldoBloqueo($bloqueo);
		if ($infoPagos['saldoPagar']>1) {
			$mPDF1->SetWatermarkText('PENDIENTE DE PAGO');
			$mPDF1->showWatermarkText = true;
			
		}
		
			
		$estatus_reserva = '';
	

		$clave_confirmacion = $roomingList->codigo_confirmacion;
		($hotel->data->proveedor == 1) ? $categoria_hotel = $hotel->data->estrellas : $categoria_hotel = $hotel->data->id_categoria;
		$reservacionController = Yii::app()->createController('Reservacion');
		$reservacionController = $reservacionController[0];
		$categoria_hotel = $reservacionController->loadModelCategoria(Hoteles::model()->findByPk($bloqueo->id_hotel));

		$qr_liga = false;
		/*if ($reservacion->data->estatus != 'C' || $reservacion->data->estatus != 'PH') {
			$tiposBanco = array('1' => 'bancomer', '2' => 'santander');

			if ($reservacion->data->saldo > 0) {
				$liga_exist = MITLiga::model()->findAll('importe LIKE "' . round($reservacion->data->saldo, 1) . '" AND referencia=' . $reservacion->id . ' AND estatus="PENDIENTE"');

				$qr_liga = true;
				if (count($liga_exist) == 0 || empty($liga_exist)) {
					foreach ($tiposBanco as $key => $value) {
						$liga_generada[$key]['cupon'] = $this->generarLiga($reservacion->id, $key);
					}
				} else {
					foreach ($liga_exist as $key => $value) {
						$liga_generada[$value->banco]['cupon'] = $value->id_MIT;
					}
				}
			}
		}*/
		$criteria_outlet = new CDbCriteria();
		$criteria_outlet->addCondition('tipo= "VIRTUAL"');
		$criteria_outlet->addCondition('estatus= 1');
		// $criteria_outlet->addBetweenCondition('fecha_inicio', "2020-02-27", "2020-03-09");
		$model_outlet = Outlet::model()->find($criteria_outlet);
	
		if ($roomingList->idBloqueo->tipo == 'BLOQUEO') {
			$fecha_apartado = strftime("%d-%b-%Y", strtotime($roomingList->fecha_apartado));
		}else{
			$fecha_apartado = strftime("%d-%b-%Y", strtotime($roomingList->fecha_inicio));
		}
		
		$data = array(
			'id_reservacion' => $prefijo.$id,
			'outlet_model' => $model_outlet,
			'id_bloqueo'=> $roomingList->id_bloqueo,
			'estatus_cupon' => '',
			'fecha_reservacion'=> $roomingList->fecha_apartado,
			'estatus_outlet' => $model_outlet->estatus,
			'outlet_inicio' => $model_outlet->fecha_inicio,
			'outlet_final' => $model_outlet->fecha_final,			
			'hotel_proveedor' => $hotel->proveedor,
			'tarifa' => $bloqueo->idTarifa->precio,
			'fecha' => $fecha_apartado,
			'fecha_liberacion' =>'',
			'nombre_elaboro' => $roomingLog->User->nombre_usuario,
			'nombre_cliente' => $arr_nom_adultos[0],
			'plan' => $bloqueo->idTarifa->tarifaPlan->nombre,
			'fecha_entrada' => implode("/", array_reverse(explode("-", $roomingList->fecha_inicio))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $roomingList->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->destinationsCode0->name,
			'destiny' => $destino->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $roomingList->observaciones,
			'politicas_cancelacion' => '',
			'supplier' => '',
			'desglose_rate' => '',
			'liga_generada' => '',
			'qr_liga' => $qr_liga
		);

		$dataCliente = array(
			'id_reservacion' => $prefijo.$id,
			'estatus_cupon' => $estatus_reserva,
			'tarifa' => $bloqueo->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($roomingList->fecha_apartado)),
			'fecha_liberacion' => '',
			'nombre_elaboro' => $usuario->data->nombre_usuario,
			'nombre_cliente' => $arr_nom_adultos[0],
			'plan' => $bloqueo->idTarifa->tarifaPlan->nombre,
			'fecha_entrada' => implode("/", array_reverse(explode("-", $roomingList->fecha_inicio))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $roomingList->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->destinationsCode0->name,
			'destiny' => $destino->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => '',
			'supplier' => '',
			'desglose_rate' => '',
			'cliente' => 1
		);
		/*if($_SESSION["tipoUsuario"]=="Admon" || $_SESSION["tipoUsuario"]=="Finanzas" || ($_SESSION["tipoUsuario"]=="Agencia" && $_SESSION["agenciaUsuario"]==$agencia->data->id_agencia)) {
*/

		if ($_SESSION["tipoUsuario"] != "Agencia" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $agencia->data->id_agencia)) {

			/*if($reservacion->libera_cupon==1){
			$mPDF1->WriteHTML($this->renderPartial('documentos/cupon',$data, true));
			$mPDF1->Output();
			}
			else
			{
				echo "Cupón no liberado";
			}*/
			$html = $this->renderPartial('documentos/cupon', $data, true);
			//$html2=$this->renderPartial('documentos/cuponcliente',$dataCliente, true);
			$mPDF1->WriteHTML($html);
			$mPDF1->AddPage();


				$mPDF1->SetWatermarkText('ORIGINAL');
				$mPDF1->showWatermarkText = true;
			
			$mPDF1->WriteHTML($html);
			$mPDF1->Output();
		}
	}
	public function actionCuponRooms($id)
	{
		$session = new CHttpSession;
		$session->open();
		$bloqueo = Bloqueos::model()->findByPk($id);


		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '<table><tr><td><img src="../../images/pakal.jpg"></td></tr></table>';
		$footer = '<table width="100%" border="0"><tr>&nbsp;<td></td><td width="250" style="text-align:right; font-family:Arial, Helvetica, sans-serif; font-size:12px;border-color:#000000;">OPERADORA</td></tr></table>';
		//set it to writable location, a place for temp generated PNG files
		$PNG_TEMP_DIR = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/temp' . DIRECTORY_SEPARATOR;
		//html PNG location prefix
		$PNG_WEB_DIR = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/temp/';
		include $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . "/phpqrcode/qrlib.php";
		//ofcourse we need rights to create temp dir
		if (!file_exists($PNG_TEMP_DIR))
			mkdir($PNG_TEMP_DIR);
		$filename = $PNG_TEMP_DIR . 'test.png';
		$matrixPointSize = 7;
		$errorCorrectionLevel = 'L';
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		$mPDF1->AddPage('P');
		# mPDF
		//for
		//$mPDF1->WriteHTML($stylesheet, 1);
		$Roominglist = Roominglist::model()->findAll("id_bloqueo=" . $id);

		$mPDF1->WriteHTML($this->renderPartial('documentos/cuponRooms', array('filename' => $filename, 'Roominglist' => $Roominglist), true));




		if ($_SESSION["tipoUsuario"] == "Admon" || $_SESSION["tipoUsuario"] == "Finanzas" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $bloqueo->id_agencia)) {
			$mPDF1->Output();
		}
	}
	public function actionCuponTransporte($id)
	{
		$session = new CHttpSession;
		$session->open();

		$header = '';
		$footer = '';
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		//$mPDF1->WriteHTML($stylesheet, 1);
		$reservacion = new ReservacionTransporteManager($id);
		$agencia = $reservacion->getAgencia();
		$usuario = $reservacion->getUsuario();
		$hotel = $reservacion->getHotel();
		$destino = $hotel->getDestino();

		if ($agencia->data->foto != '') {
			$logo_agencia = 'https://' . $_SERVER['SERVER_NAME'] . "/imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = 'https://' . $_SERVER['SERVER_NAME'] . "/reservaciones/images/sinlogo.png";
		}
		if ($reservacion->data->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			if ($reservacion->data->saldo > 0 and $reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('PENDIENTE DE PAGO');
				$mPDF1->showWatermarkText = true;
			}
			$estatus_reserva = '';
		}


		($reservacion->data->code != '') ? $clave_confirmacion = $reservacion->data->code : $clave_confirmacion = 'N/A';
		($hotel->data->proveedor == 1) ? $categoria_hotel = $hotel->data->estrellas : $categoria_hotel = $hotel->data->id_categoria;

		$reservacionController = Yii::app()->createController('Reservacion');
		$reservacionController = $reservacionController[0];
		$categoria_hotel = $reservacionController->loadModelCategoria(Hoteles::model()->findByPk($reservacion->data->id_hotel));

		$qr_liga = false;
		if ($reservacion->data->estatus != 'C' || $reservacion->data->estatus != 'PH') {
			// $tiposBanco = array('1' => 'bancomer', '2' => 'santander');

			// if ($reservacion->data->saldo > 0) {
			// 	$liga_exist = MITLiga::model()->findAll('importe LIKE "' . round($reservacion->data->saldo, 1) . '" AND referencia=' . $reservacion->id . ' AND estatus="PENDIENTE" AND tipo="TRANSPORTE"');

			// 	$qr_liga = true;
			// 	if (count($liga_exist) == 0 || empty($liga_exist)) {
			// 		foreach ($tiposBanco as $key => $value) {
			// 			$liga_generada[$key]['cupon'] = $this->generarLiga($reservacion->id, $key);
			// 		}
			// 	} else {
			// 		foreach ($liga_exist as $key => $value) {
			// 			$liga_generada[$value->banco]['cupon'] = $value->id_MIT;
			// 		}
			// 	}
			// }
		}

		$transportacionController = Yii::app()->createController('transportacion')[0];
		$reserva = TransportacionReservacion::model()->findByPk($reservacion->id);
		$descripcion = $transportacionController->descripcionServicio($reserva);

		$mostrarFechas = $transportacionController->mostrarFechas($reserva);
		$fecha = $mostrarFechas['fecha'];
		$mostrarFechaLlegada = $mostrarFechas['mostrarFechaLlegada'];
		$mostrarFechaSalida = $mostrarFechas['mostrarFechaSalida'];
		if ($mostrarFechaLlegada == true) {
			$model->fecha_llegada = date('Y-m-d',strtotime($model->fecha_llegada));
		}
		if ($mostrarFechaSalida == true) {
			$model->fecha_salida = date('Y-m-d',strtotime($model->fecha_salida));
		}

		setlocale(LC_TIME, "spanish");
		
		$data = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'fecha_reservacion'=> $reservacion->data->log,		
			'hotel_proveedor' => $hotel->data->proveedor,
			'fecha' => date("d/m/Y",strtotime($reservacion->data->log)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'fecha_entrada' => date('d/m/Y',strtotime($reservacion->data->fecha_llegada)),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->data->destinationsCode0->name,
			'destiny' => $destino->data->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => $reservacion->data->politicas_cancelacion,
			'descripcion'=>$descripcion,
			'reservacion'=>$reservacion,
			'mostrarFechaLlegada'=>$mostrarFechaLlegada,
			'mostrarFechaSalida'=>$mostrarFechaSalida,
		);


		// echo "<textarea>".json_encode($data)."</textarea>";
		

		if ($_SESSION["tipoUsuario"] != "Agencia" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $agencia->data->id_agencia)) {

			$html = $this->renderPartial('documentos/cuponTransporte', $data, true);
			$mPDF1->WriteHTML($html);
			$mPDF1->AddPage();

			if ($reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('ORIGINAL');
				$mPDF1->showWatermarkText = true;
			}
			$mPDF1->WriteHTML($html);
			$mPDF1->Output();
		}
	}
	public function actionCuponclave($clave)
	{
		$session = new CHttpSession;
		$session->open();
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '<table><tr><td><img src="../../images/pakal.jpg"></td></tr></table>';
		$footer = '<table width="100%" border="0"><tr>&nbsp;<td></td><td width="250" style="text-align:right; font-family:Arial, Helvetica, sans-serif; font-size:12px;border-color:#000000;">OPERADORA</td></tr></table>';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		$mPDF1->WriteHTML($stylesheet, 1);
		$reservacionc = new ReservacionClave($clave);
		$id = $reservacionc->getIdReservacion();
		$reservacion = new ReservacionManager($id);
		$agencia = $reservacion->getAgencia();
		$usuario = $reservacion->getUsuario();
		$hotel = $reservacion->getHotel();
		$destino = $hotel->getDestino();
		$ocupaciones = $reservacion->getOcupaciones();
		$habitaciones = array();
		$total_adultos = 0;
		$total_menores = 0;
		if ($agencia->data->foto != '') {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/admon/images/sinlogo.png";
		}
		foreach ($ocupaciones->data as $o) {
			$arr_edades = array();
			$arr_nom_adultos = array();
			$OcupacionesPersona = new OcupacionPersonaManager(array("tipo" => 'id_ocupacion', 'param' => $o->id_desglose)); //Devuelve los menores para la ocupacion solicitada
			foreach ($OcupacionesPersona->data as $op) {
				if ($op->tipo != 'A') {
					$arr_edades[] = $op->edad;
					$total_menores++;
				} else {
					$arr_nom_adultos[] = $op->nombre;
					$total_adultos++;
				}
			}
			$hab = array(
				'base' => $o->baseHabitacion->base_habitacion,
				'tipo' => $o->tipoHabitacion->tipo_habitacion,
				'num_adultos' => $o->num_adultos,
				'num_menores' => $o->num_ninios,
				'edades' => join(",", $arr_edades),
				'nombres' => join(" / ", $arr_nom_adultos),
			);
			$habitaciones[] = $hab;
		}
		if ($reservacion->data->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			$estatus_reserva = '';
		}
		($reservacion->data->code != '') ? $clave_confirmacion = $reservacion->data->code : $clave_confirmacion = 'N/A';
		$data = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'tarifa' => $reservacion->data->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->data->log)),
			'fecha_liberacion' => empty($reservacion->data->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->data->fecha_liberacion)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan()->data->nombre,
			'fecha_entrada' => myDate($reservacion->data->fecha_inicial),
			'fecha_salida' => myDate($reservacion->data->fecha_final),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destino' => $destino->data->destino,
			'tel_hotel' => myPhone($hotel->data->tel_hotel1),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
		);
		$mPDF1->WriteHTML($this->renderPartial('documentos/cupon', $data, true));
		$mPDF1->Output();
		/*			$mPDF1->Output('cupones/'.$reservacion->id.'.pdf','F');
			header("Location: http://".$_SERVER['SERVER_NAME']."/casateconmigo_demo/bodas/site/emailCupon/id/".$reservacion->id);*/
	}

	public function actionCuponTour($id)
	{
		// $session = new CHttpSession;
		// $session->open();
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '';
		$footer = '';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		//$mPDF1->WriteHTML($stylesheet, 1);
		$reservacion = TourReservacion::model()->findByPk($id);
		$personas = TourReservacionDesglosePersona::model()->findAll('id_reservacion=' . $reservacion->id_tourReservacion);


		$data = array(
			'id_reservacion' => $reservacion->id_tourReservacion,
			'code' => $reservacion->code,
			'estatus_cupon' => $reservacion->estatus,
			'tarifa' => $reservacion->idTarifa->tourTarifaDesgloses->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->log)),
			'fecha_liberacion' => empty($reservacion->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->fecha_liberacion)),
			'nombre_elaboro' => $reservacion->idUsuario->nombre_usuario,
			'nombre_cliente' => $reservacion->cliente_nombre,
			'pasajeros' => $personas,
			'apellido_cliente' => $reservacion->cliente_apellido,
			'fecha_entrada' => implode("/", array_reverse(explode("-", $reservacion->fecha_inicio))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $reservacion->fecha_fin))),
			'nombre_agencia' => $reservacion->idAgencia->nombre_agencia,
			'direccion_agencia' => $reservacion->idAgencia->calle_fiscal,
			'localidad_agencia' => $reservacion->idAgencia->id_ciudad_fiscal,
			'tel_agencia' => $reservacion->idAgencia->tel_agencia,
			'logo_agencia' => $reservacion->idAgencia->foto,
			'nombre_tour' => $reservacion->idTour->nombre,
			'destinyName' => $reservacion->idTour->idDestino->destino,
			'destiny' => $reservacion->idTour->idDestino->destino->countryCode,
			'categoria' => $reservacion->idTour->idTipoCategoria0->nombre,
			'observaciones' => $reservacion->observaciones,

			//'politicas_cancelacion'=>$reservacion->data->politicas_cancelacion,


		);
		// if ($_SESSION["tipoUsuario"] == "Admon" || $_SESSION["tipoUsuario"] == "Finanzas" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $reservacion->id_agencia)) {
			/*if($reservacion->libera_cupon==1){
			$mPDF1->WriteHTML($this->renderPartial('documentos/cupon',$data, true));
			$mPDF1->Output();
			}
			else
			{
				echo "Cupón no liberado";
			}*/
			$mPDF1->WriteHTML($this->renderPartial('documentos/cuponTour', $data, true));
			$mPDF1->Output();
		// }
	}

	/**
	 * This is the action to handle external exceptions.
	 */
	public function actionRecibo($id)
	{
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$recibo = Recibos::model()->findByPk($id);
		$reservacion = Reservacion::model()->findByPk($recibo->id_reservacion);
		//		$sql="select sum(abono) as abono from tbl_cuentas where id_recibo = ".$id." and cuenta IN ('Mayorista')  and escancelacion=0";
		$sql = "select sum(abono) as abono from tbl_cuentas where id_recibo = " . $id . " and cuenta IN ('Mayorista')";
		$row = Yii::app()->db->createCommand($sql)->queryAll();
		foreach ($row as $data) {
			$row = $data;
		}
		$montoapagar = $row['abono'];
		/*$reserva= new ReservacionManager($id);
		$agencia=$reserva->getAgencia();
		$usuario=$reserva->getUsuario();
		$hotel=$reserva->getHotel();
		$destino=$hotel->getDestino();
		$ocupaciones=$reserva->getOcupaciones();*/
		$font = 'font-family:Arial, Helvetica, sans-serif; font-size:12px';
		$logo_agencia = $_SERVER['DOCUMENT_ROOT'] . "/imagenes/" . $agencia->data->foto;
		$mycode = 'No. de Confirmación: ' . $recibo->reservacion->code;
		switch ($recibo->forma_pago) {
			case  'E':
				$tipo_pago = "Pago en Efectivo";
				break;
			case 'TC':
				$tipo_pago = "Pago con Tarjeta de Credito";
				break;
			case 'DB':
				$tipo_pago = "Pago en Deposito Bancario";
				break;
		}
		switch ($recibo->estatus) {
			case 'C':
				$estatus_recibo = "Cancelado";
				break;
			case 'P':
				$estatus_recibo = "Pagado";
				break;
			case 'PP':
				$estatus_recibo = "Pagado";
				break;
		}
		$header = '<table><tr><td><img src="https://rutamayatravel.com/reservaciones/images/pakal.jpg"></td></tr></table>';
		$headerc = '
		<table width="100%"  border="0" style="' . $font . '">
		<tr>
			<td align="right"><img width="100" src="' . $_SERVER['DOCUMENT_ROOT'] . '/outlet/images/expoviaje2014.jpg" /></td>		
			<td  height="100px"><img src="' . $logo_agencia . '" width="160" /></td>
			<td>&nbsp;</td>
			<td align="right" >
				<table width="100%" cellspacing="0"  cellpadding="0" style="border-color:#000000; border-style:solid;border:thin; padding:15px">
					<tr>
						<td style="color:#FF0000">Folio No. &nbsp; ' . $recibo->id_recibo . '</td>
					</tr>
					<tr>
						<td style="color:#FF0000">Reservaci&oacute;n No. &nbsp; ' . $recibo->id_reservacion . '</td>
					</tr>
					<tr>
						<td style="color:#FF0000">' . $estatus_recibo . '</td>
					</tr>	    
				</table>
			</td>
		</tr>
		<tr>
			<td colspan="3" align="center"><h1>RECIBO</h1> <span style="color:#FF0000">' . $mycode . '</span></td>
		</tr><br><br>
		<tr>
			<td colspan="3">
				Muchas gracias por haber elegido nuestro servicio. Para cualquier informaci&oacute;n adicional por favor contacte a su asesor de viajes 
				asignado (' . $recibo->agencia->nombre_agencia . ') , con direcci&oacute;n 
				(' . $recibo->agencia->calle_fiscal . ' ' . $recibo->agencia->cruzamientos_fiscal . ' ' . $recibo->agencia->num_exterior_fiscal . ' ' . $recibo->agencia->num_interior_fiscal . ' ' . $recibo->agencia->cp_fiscal . '). Por favor imprima este recibo y traigalo 
				con usted junto con una identificaci&oacute;n v&aacute;lida con fotograf&iacute;a
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
		</tr>
		<tr>
			<td colspan="3" >
			<table width="100%" cellspacing="0"  cellpadding="0" style="border-color:#000000; border-style:solid;border:thin">
			<tr>
				<td style="font-size:15px">Por medio de la presente, en M&eacute;rida Yucat&aacute;n M&eacute;xico a fecha (' . mydatefull(date('Y-m-d')) . ')  recibo 
				de (' . $recibo->reservacion->nombre_cliente . ') 
				el derecho por el paquete contratado, como se desglosa a continuaci&oacute;n</td>
			</tr>
			<tr>
			<td>&nbsp;</td>
			</tr>
			<tr>
				<td align="center">Bueno por: ($ ' . number_format($montoapagar, 2) . ' ' . $reservacion->tarifa->moneda . ')<br><br>Son: ' . convertirNumALetras($montoapagar, $reservacion->tarifa->moneda) . ' <br><br>' . $tipo_pago . ' ' . $banco . ' ' . $plazo . '</td>
			</tr>
			</table></td>
		</tr></table>';
		if ($reservacion->factura != '') {
			$html1 .= '<table width="100%" style="' . $font . ';border-color:#000000; border-style:solid;border:thin"><tr>
					<td>Factura: ' . strtoupper($reservacion->factura) . '</td>
				</tr>
			</table>';
		}
		$footer = $html1 . '<p align="left" style="' . $font . '">*Fin del documento</p>';
		$stylesheet = file_get_contents($_SERVER['DOCUMENT_ROOT'] . "/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		$mPDF1->WriteHTML($stylesheet, 1);
		if ($reservacion->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			$estatus_reserva = '';
		}
		$data = array(
			'nombre_cliente' => $recibo->reservacion->nombre_cliente,
			'nombre_hotel' => $reservacion->hotel->nombre_hotel,
			'direccion_hotel' => $reservacion->hotel->calle_hotel . ' ' . $reservacion->hotel->municipio_hotel,
			'fecha_inicial' => mydatefull($recibo->reservacion->fecha_inicial),
			'fecha_final' => mydatefull($recibo->reservacion->fecha_final),
			'num_noches' => $recibo->reservacion->num_noches,
			'num_cuartos' => $recibo->reservacion->num_habitaciones,
			'num_adultos' => $reservacion->desglose->num_adultos,
			'num_ninios' => $reservacion->desglose->num_ninios,
			'observaciones' => $recibo->reservacion->observaciones,
			'notas' => $recibo->infopago->notasadicionales,
			'headerc' => $headerc,
		);
		$mPDF1->WriteHTML($this->renderPartial('documentos/recibo', $data, true));
		$mPDF1->Output();
	}
	public function GenerarLiga($id, $key)
	{
		$mitLigaController = Yii::app()->createController('mITLiga');
		$mitLigaController = $mitLigaController[0];
		$reservacion = Reservacion::model()->findByPk($id);
		$agencia = Agencias::model()->findByPk($reservacion->id_agencia);

		$model =  new MITLiga;

		if (Yii::app()->user->id == 0) {
			$usuario = Usuarios::model()->findByPk($reservacion->id_usuario);
		} else {
			$usuario = Usuarios::model()->findByPk(Yii::app()->user->id);
		}
		$model->id_usuario = $usuario->id_usuario;
		$model->referencia = $reservacion->id_reservacion;
		$model->email = $usuario->email_usuario;
		$model->celular = $agencia->tel_agencia;
		$model->banco = $key;
		$model->estatus = 'PENDIENTE';
		$model->importe = $reservacion->total;
		$model->tipo = 'RESERVACION';
		if ($model->save()) {
			try {
				$liga_pago = "https://www.rutamayatravel.com/reservaciones/pagoenlinea/?ref=" . base64_encode($model->id_MIT);
				$mitLigaController->mailInterno($liga_pago, $usuario->id_usuario, $reservacion->saldo, $reservacion->id_reservacion, 'RESERVACION');
				return $model->id_MIT;
			} catch (Exception $e) {
				return CJSON::encode($model->getErrors());
			}
		} else {
			return CJSON::encode($model->getErrors());
		}
	}
	public function actionError()
	{
		if ($error = Yii::app()->errorHandler->error) {
			if (Yii::app()->request->isAjaxRequest)
				echo $error['message'];
			else
				$this->render('error', $error);
		}
	}
	/**
	 * Displays the contact page
	 */
	public function actionContact()
	{
		$model = new ContactForm;
		if (isset($_POST['ContactForm'])) {
			$model->attributes = $_POST['ContactForm'];
			if ($model->validate()) {
				$headers = "From: {$model->email}\r\nReply-To: {$model->email}";
				mail(Yii::app()->params['adminEmail'], $model->subject, $model->body, $headers);
				Yii::app()->user->setFlash('contact', 'Thank you for contacting us. We will respond to you as soon as possible.');
				$this->refresh();
			}
		}
		$this->render('contact', array('model' => $model));
	}
	/**
	 * Displays the login page
	 */
	public function actionLogin()
	{
		$model = new LoginForm;
		// if it is ajax validation request
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'login-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
		// collect user input data
		if (isset($_POST['LoginForm'])) {
			$model->attributes = $_POST['LoginForm'];
			// validate user input and redirect to the previous page if valid
			if ($model->validate() && $model->login())
				$this->redirect(Yii::app()->user->returnUrl);
		}
		// display the login form
		$this->render('login', array('model' => $model));
	}
	/**
	 * Logs out the current user and redirect to homepage.
	 */
	public function actionLogout()
	{
		Yii::app()->user->logout();
		$this->redirect(Yii::app()->homeUrl);
	}
	public function actionCuponesBloqueo($id)
	{
		$session = new CHttpSession;
		$session->open();
		$bloqueo = Bloqueos::model()->findByPk($id);


		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '<table><tr><td><img src="../../images/pakal.jpg"></td></tr></table>';
		$footer = '<table width="100%" border="0"><tr>&nbsp;<td></td><td width="250" style="text-align:right; font-family:Arial, Helvetica, sans-serif; font-size:12px;border-color:#000000;">OPERADORA</td></tr></table>';
		//set it to writable location, a place for temp generated PNG files
		$PNG_TEMP_DIR = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/temp' . DIRECTORY_SEPARATOR;
		//html PNG location prefix
		$PNG_WEB_DIR = $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . '/temp/';
		include $_SERVER['DOCUMENT_ROOT'] . Yii::app()->request->baseUrl . "/phpqrcode/qrlib.php";
		//ofcourse we need rights to create temp dir
		if (!file_exists($PNG_TEMP_DIR))
			mkdir($PNG_TEMP_DIR);
		$filename = $PNG_TEMP_DIR . 'test.png';
		$matrixPointSize = 7;
		$errorCorrectionLevel = 'L';
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		# mPDF
		//for
		//$mPDF1->WriteHTML($stylesheet, 1);
		$Roominglist = Roominglist::model()->findAll("id_bloqueo=" . $id);

		$mPDF1->WriteHTML($this->renderPartial('documentos/cuponBloqueo', array('filename' => $filename, 'Roominglist' => $Roominglist), true));




		if ($_SESSION["tipoUsuario"] == "Admon" || $_SESSION["tipoUsuario"] == "Finanzas" || ($_SESSION["tipoUsuario"] == "Agencia" && $_SESSION["agenciaUsuario"] == $bloqueo->id_agencia)) {
			$mPDF1->Output();
		}
	}




	public function actionCuponMovil($id, $idAgencia)

	{
		$session = new CHttpSession;
		$session->open();
		// renders the view file 'protected/views/site/index.php'
		// using the default layout 'protected/views/layouts/main.php'
		$header = '<table><tr><td><img src="../../images/pakal.jpg"></td></tr></table>';
		$footer = '';
		//$stylesheet = file_get_contents("http://www.sistema.rutamayatravel.com/admon/css/plugin.css");
		# mPDF
		$mPDF1 = Yii::app()->ePdf->mpdf();
		$mPDF1->SetHTMLHeader($header);
		$mPDF1->SetHTMLFooter($footer);
		//$mPDF1->WriteHTML($stylesheet, 1);
		$reservacion = new ReservacionManager($id);
		$agencia = $reservacion->getAgencia();
		$usuario = $reservacion->getUsuario();
		$hotel = $reservacion->getHotel();
		$destino = $hotel->getDestino();
		$ocupaciones = $reservacion->getOcupaciones();
		$habitaciones = array();
		$total_adultos = 0;
		$total_menores = 0;

		if ($agencia->data->foto != '') {
			$logo_agencia = "../../imagenes/" . $agencia->data->foto;
		} else {
			$logo_agencia = "../reservaciones/images/sinlogo.png";
		}
		foreach ($ocupaciones->data as $o) {
			$arr_edades = array();
			$arr_nom_adultos = array();
			$OcupacionesPersona = new OcupacionPersonaManager(array("tipo" => 'id_ocupacion', 'param' => $o->id_desglose)); //Devuelve los menores para la ocupacion solicitada
			foreach ($OcupacionesPersona->data as $op) {
				if ($op->tipo != 'A') {
					$arr_edades[] = $op->edad;
					$total_menores++;
				} else {
					$arr_nom_adultos[] = $op->nombre;
					$total_adultos++;
				}
			}
			$hab = array(
				'base' => $o->baseHabitacion->base_habitacion,
				'tipo' => $o->tipoHabitacion->tipo_habitacion,
				'num_adultos' => $o->num_adultos,
				'num_menores' => $o->num_ninios,
				'edades' => join(",", $arr_edades),
				'nombres' => join(" / ", $arr_nom_adultos),
			);
			$habitaciones[] = $hab;
		}
		if ($reservacion->data->estatus == 'C') {
			$estatus_reserva = 'CANCELADO';
			$mPDF1->SetWatermarkText('CANCELADO');
			$mPDF1->showWatermarkText = true;
		} else {
			if ($reservacion->data->saldo > 0 and $reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('PENDIENTE DE PAGO');
				$mPDF1->showWatermarkText = true;
			}
			$estatus_reserva = '';
		}


		($reservacion->data->code != '') ? $clave_confirmacion = $reservacion->data->code : $clave_confirmacion = 'N/A';
		($hotel->data->proveedor == 1) ? $categoria_hotel = $hotel->data->estrellas : $categoria_hotel = $hotel->data->id_categoria;
		$reservacionController = Yii::app()->createController('Reservacion');
		$reservacionController = $reservacionController[0];
		$categoria_hotel = $reservacionController->loadModelCategoria(Hoteles::model()->findByPk($reservacion->data->id_hotel));
		$data = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'tarifa' => $reservacion->data->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->data->log)),
			'fecha_liberacion' => empty($reservacion->data->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->data->fecha_liberacion)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan(),
			'fecha_entrada' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_inicial))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->data->destinationsCode0->name,
			'destiny' => $destino->data->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => $reservacion->data->politicas_cancelacion,
			'supplier' => $reservacion->getSupplier(),
			'desglose_rate' => $reservacion->data->desglose_rate
		);

		$dataCliente = array(
			'id_reservacion' => $reservacion->id,
			'estatus_cupon' => $estatus_reserva,
			'tarifa' => $reservacion->data->idTarifa->precio,
			'fecha' => strftime("%d-%b-%Y", strtotime($reservacion->data->log)),
			'fecha_liberacion' => empty($reservacion->data->fecha_liberacion) ? '' : strftime("%d-%b-%Y", strtotime($reservacion->data->fecha_liberacion)),
			'nombre_elaboro' => $usuario->getNombreCompleto(),
			'nombre_cliente' => $reservacion->data->nombre_cliente,
			'plan' => $reservacion->getPlan(),
			'fecha_entrada' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_inicial))),
			'fecha_salida' => implode("/", array_reverse(explode("-", $reservacion->data->fecha_final))),
			'clave_confirmacion' => $clave_confirmacion,
			'nombre_agencia' => $agencia->data->nombre_agencia,
			'direccion_agencia' => $agencia->getDireccion(),
			'localidad_agencia' => $agencia->getLocalidad(),
			'tel_agencia' => $agencia->data->tel_agencia,
			'logo_agencia' => $logo_agencia,
			'nombre_hotel' => $hotel->data->nombre_hotel,
			'direccion_hotel' => $hotel->getDireccion(),
			'localidad_hotel' => $hotel->getLocalidad(),
			'destinyName' => $destino->data->destinationsCode0->name,
			'destiny' => $destino->data->destinationsCode0->countryCode,
			'tel_hotel' => $hotel->data->tel_hotel1,
			'categoria_hotel' => $categoria_hotel, //$hotel->getCategoria(),
			'habitaciones' => $habitaciones,
			'total_adultos' => $total_adultos,
			'total_menores' => $total_menores,
			'observaciones' => $reservacion->data->observaciones,
			'politicas_cancelacion' => $reservacion->data->politicas_cancelacion,
			'supplier' => $reservacion->getSupplier(),
			'desglose_rate' => $reservacion->data->desglose_rate,
			'cliente' => 1
		);

		$validarUsuario = Usuarios::model()->find('id_agencia=' . $idAgencia);

		if ($validarUsuario) {
			/*if($reservacion->libera_cupon==1){
			$mPDF1->WriteHTML($this->renderPartial('documentos/cupon',$data, true));
			$mPDF1->Output();
			}
			else
			{
				echo "Cupón no liberado";
			}*/
			$html = $this->renderPartial('documentos/cupon', $data, true);
			//$html2=$this->renderPartial('documentos/cuponcliente',$dataCliente, true);
			$mPDF1->WriteHTML($html);
			$mPDF1->AddPage();

			if ($reservacion->data->estatus != 'C') {
				$mPDF1->SetWatermarkText('ORIGINAL');
				$mPDF1->showWatermarkText = true;
			}
			$mPDF1->WriteHTML($html);
			$mPDF1->Output($reservacion->data->id_reservacion . '.pdf', 'I');
		}
	}
}
/*
	//Funciones Generales que deben ir en algun lado
	//funcion para dar formato a un numero de telefono -> $tel = 99991293823 -> (999) 129-38-23;
	function myPhone($tel){
		if(!empty($tel)){
			$newtel = "(".substr($tel,0,3).") ".substr($tel,3,3)."-".substr($tel,6,2)."-".substr($tel,8,2);
		}else{
			$newtel = "";
		}
		return $newtel;
	}
	//funcion para convertir una fecha a texto-numero corto -> 08-Mar-2011;
	function myDate($fecha){ 
	    $fecha= strtotime($fecha); // conviertimos la fecha de formato yyyy-mm-dd a marca de tiempo 
	    $dia=date("d",$fecha); // dï¿œa del mes en nï¿œmero 
	    $mes=date("m",$fecha); // nï¿œmero del mes de 01 a 12 
	       switch($mes){ 
	       case "01": 
	          $mes="Ene"; 
	          break; 
	       case "02": 
	          $mes="Feb"; 
	          break; 
	       case "03": 
	          $mes="Mar"; 
	          break; 
	       case "04": 
	          $mes="Abr"; 
	          break; 
	       case "05": 
	          $mes="May"; 
	          break; 
	       case "06": 
	          $mes="Jun"; 
	          break; 
	       case "07": 
	          $mes="Jul"; 
	          break; 
	       case "08": 
	          $mes="Ago"; 
	          break; 
	       case "09": 
	          $mes="Sep"; 
	          break; 
	       case "10": 
	          $mes="Oct"; 
	          break; 
	       case "11": 
	          $mes="Nov"; 
	          break; 
	       case "12": 
	          $mes="Dic"; 
	          break; 
	       } 
	    $ano=date("Y",$fecha); // obtenemos el aï¿œo en formato 4 digitos 
	    $fecha= $dia."-".$mes."-".$ano; // unimos el resultado en una unica cadena
	    return $fecha;
	}
	*/
