<?php

class GeneralController extends Controller {

	public function convertModelToArray($models) {
        if (is_array($models))
            $arrayMode = TRUE;
        else {
            $models = array($models);
            $arrayMode = FALSE;
        }

        $result = array();

        foreach ($models as $model) {
            $attributes = $model->getAttributes();
            $relations = array();

            foreach ($model->relations() as $key => $related) {
                if ($model->hasRelated($key)) {
                	if ($model->$key) {
                    	$relations[$key] = $this->convertModelToArray($model->$key);	
                	}else{
                		$relations[$key] =[];
                	}
                }
            }

            $all = array_merge($attributes, $relations);

            if ($arrayMode)
                array_push($result, $all);
            else
                $result = $all;
        }

        return $result;
    }

    public function checkAgencyOutlet() {
		$criteria_outlet            = new CDbCriteria();
        $date                       = date('Y-m-d');
		$criteria_outlet->condition = "estatus = 1 AND ('". $date ."' BETWEEN fecha_inicio AND fecha_final) AND tipo = 'VERANO'";
		$model_outlet               = Outlet::model()->find($criteria_outlet);

        if(is_null($model_outlet)) return false;

        if(isset($_SESSION["agencia"]["id_agencia"])) $idAgencia = $_SESSION["agencia"]["id_agencia"];
        else $idAgencia = $_SESSION["agenciaUsuario"];

        if($idAgencia=='') header('Location: https://www.rutamayatravel.com/sur4/user/login.html');

        //$model_ao = OutletAgencia::model()->find("id_agencia = ". $_SESSION["agencia"]["id_agencia"] ." AND id_evento = ". $model_outlet->id_outlet);
        $model_ao = OutletAgencia::model()->find("id_agencia = $idAgencia AND id_evento = 15");

        return (is_null($model_ao) ? false : true);
    }

    function printPrecio($precio, $model) {
		if(gettype($precio) == "string") {
			$new_precio = str_replace(",", "", $precio);
			$new_precio = (float) $new_precio;
		} else {
			$new_precio = floatval($precio);
		}
        session_start();
        if($_SESSION["currency"] != "OR") {
            $currency = $_SESSION["currency"];
    
            $dash = Yii::app()->createController('dashboard');
            $dash = $dash[0];
            $tasa_cambio = $dash->tasaCambioActual();
            $tasa_cambio_general = $tasa_cambio['importe'] ? number_format($tasa_cambio['importe'], 2) : 25.50;
            $tasa_cambio_tarifa = floatval($model->idTarifa->tasa_cambio);
            if ($model->moneda == "USD" && $currency == "MXN") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio * $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio * $tasa_cambio_general;
                }
            } else if (($model->moneda == "MXN" || is_null($model->moneda)) && $currency == "USD") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio / $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio / $tasa_cambio_general;
                }
            } else if(($model->moneda == "MXN" || is_null($model->moneda)) && $currency == "COP") {
                $new_precio = $new_precio / $tasa_cambio["cop_compra"];
            } else if($model->moneda == "USD" && $currency == "COP") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio * $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio * $tasa_cambio_general;
                }
                $new_precio = $new_precio / $tasa_cambio["cop_compra"];
            }
        }
		return $new_precio;
	}

    public function printPrice($price, $model, $type) {
        if(gettype($price) == "string") {
			$new_precio = str_replace(",", "", $price);
			$new_precio = (float) $new_precio;
		} else {
			$new_precio = floatval($price);
		}
        session_start();
        if($_SESSION["currency"] != "OR") {
            switch ($type) {
                case "hotel":
                    $moneda = $model->moneda;
                    $tasa_cambio_tarifa = floatval($model->idTarifa->tasa_cambio);
                    break;

                case "activity":
                    $moneda = json_decode($model->Booking, true)["currency"];
                    $tasa_cambio_tarifa = floatval($model->tipo_cambio);
                    break;

                case "tour":
                    $moneda = $model->moneda;
                    if(is_null($model->moneda) || $model->moneda == 0 || $model->moneda == 1) $moneda = "MXN";

                    $tasa_cambio_tarifa = floatval($model->tasa_cambio);
                    if($model->tasa_cambio == 1 || is_null($model->tasa_cambio)) $tasa_cambio_tarifa = "";
                    break;

                case "traslado":
                    $moneda = $model->moneda;
                    if($model->tipo_cambio > 0) $tasa_cambio_tarifa = "";
                    else $tasa_cambio_tarifa = floatval($model->tipo_cambio);
                    break;
                
                default:
                    # code...
                    break;
            }

            $currency = $_SESSION["currency"];
            $dash = Yii::app()->createController('dashboard')[0];
            $tasa_cambio = $dash->tasaCambioActual();
            $tasa_cambio_general = $tasa_cambio['compra'] ? number_format($tasa_cambio['compra'], 2) : 25.50;
            if ($moneda == "USD" && $currency == "MXN") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio * $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio * $tasa_cambio["importe"];
                }
            } else if ($moneda == "MXN" && $currency == "USD") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio / $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio / $tasa_cambio["compra"];
                }
            } else if($moneda == "MXN" && $currency == "COP") {
                $new_precio = $new_precio / $tasa_cambio["cop_compra"];
            } else if($moneda == "USD" && $currency == "COP") {
                if ($tasa_cambio_tarifa != "") {
                    $new_precio = $new_precio * $tasa_cambio_tarifa;
                } else {
                    $new_precio = $new_precio * $tasa_cambio["importe"];
                }
                $new_precio = $new_precio / $tasa_cambio["cop_compra"];
            }
        }
		return $new_precio;
    }
}