<?php
//require_once('../../api/beds/HotelApi.php');
class HbedsController extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */

	public $layout='//layouts/column1';



	/**

	 * @return array action filters

	 */

	public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}



	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()

	{

		return array(

			array('allow',  // allow all users to perform 'index' and 'view' actions

				'actions'=>array('index','view'),

				'users'=>array('@'),

			),

			array('allow', // allow authenticated user to perform 'create' and 'update' actions

				'actions'=>array('create','update','GeneratePdf','GenerateExcel','hotelInfo'),

				'users'=>array('@'),

			),

			array('allow', // allow admin user to perform 'admin' and 'delete' actions

				'actions'=>array('admin','delete'),

				'users'=>array('admin'),

			),

			array('deny',  // deny all users

				'users'=>array('*'),

			),

		);

	}



	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */

	public function actionView($id)

	{

		$this->render('view',array(

			'model'=>$this->loadModel($id),

		));

	}

	public function actionHotelInfo($code)
	{
		
		/*$beds= new HotelApi;
		if ($code) 
		$params['hotelCode']=$code;			
		

		 $beds->hotelDetailedInformation(json_encode($params['hotelCode']));
		
		$hotelDetail=json_decode($beds);*/
		
		echo $code;
	}

	/**

	 * Creates a new model.

	 * If creation is successful, the browser will be redirected to the 'view' page.

	 */

	public function actionCreate()

	{

		$model=new Transporte;



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		if(isset($_POST['Transporte']))

		{

			$model->attributes=$_POST['Transporte'];

			if($model->save())

				$this->redirect(array('view','id'=>$model->id));

		}



		$this->render('create',array(

			'model'=>$model,

		));

	}



	/**

	 * Updates a particular model.

	 * If update is successful, the browser will be redirected to the 'view' page.

	 * @param integer $id the ID of the model to be updated

	 */

	public function actionUpdate($id)

	{

		$model=$this->loadModel($id);



		// Uncomment the following line if AJAX validation is needed

		// $this->performAjaxValidation($model);



		if(isset($_POST['Transporte']))

		{

			$model->attributes=$_POST['Transporte'];

			if($model->save())

				$this->redirect(array('view','id'=>$model->id));

		}



		$this->render('update',array(

			'model'=>$model,

		));

	}



	/**

	 * Deletes a particular model.

	 * If deletion is successful, the browser will be redirected to the 'admin' page.

	 * @param integer $id the ID of the model to be deleted

	 */

	public function actionDelete($id)

	{

		if(Yii::app()->request->isPostRequest)

		{

			// we only allow deletion via POST request

			$this->loadModel($id)->delete();



			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser

			if(!isset($_GET['ajax']))

				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));

		}

		else

			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');

	}



	/**

	 * Lists all models.

	 */

	public function actionIndex()

	{

       

			$usuario=Usuarios::model()->findByPk(Yii::app()->user->id);

			

			$banners=Banners::model()->findAll(array('condition'=>'estatus=1 and current_date() between fecha_inicial and fecha_final','order'=>'posicion'));



			$this->render('index', array(

			

			'banners'=>$banners));

	}



	/**

	 * Manages all models.

	 */

	public function actionAdmin()

	{

		$model=new Transporte('search');

		$model->unsetAttributes();  // clear any default values

		if(isset($_GET['Transporte']))

			$model->attributes=$_GET['Transporte'];



		$this->render('admin',array(

			'model'=>$model,

		));

	}



	/**

	 * Returns the data model based on the primary key given in the GET variable.

	 * If the data model is not found, an HTTP exception will be raised.

	 * @param integer the ID of the model to be loaded

	 */

	public function loadModel($id)

	{

		$model=Transporte::model()->findByPk($id);

		if($model===null)

			throw new CHttpException(404,'The requested page does not exist.');

		return $model;

	}


	public function politicasCancelacion($cancellationPolicies,$fecha_inicial,$markup,$descripcionHabitacion,$r,$moneda,$bandera) {

		$cancelPenalties = array();

		if($bandera==true)
		{
			$atrrTable="border='1' class='table-tooltip tableInfo'";
		}else
		{
			$atrrTable="class='table table-bordered table-tooltip tableInfo'";
		}

		$cancelPenalties['descripcion'] = $descripcionHabitacion;
		$hoy=date("Y-m-d");

		if($cancellationPolicies)
		{
			$fechas_limite=array();
			$fechas_limite_h=array();
			foreach ($cancellationPolicies as $c => $cancelacion) 
			{

				$importe=$cancelacion->amount/$markup;

				$datetime_hoy=new DateTime($hoy);
				$datetime_cancelacion=new DateTime(date("Y-m-d",strtotime($cancelacion->from)));
				
				$diferencia = $datetime_cancelacion->diff($datetime_hoy);
				
				$resultado_diferencia_dias= $diferencia->format('%a');

				if($resultado_diferencia_dias<=7)
				{
					$fecha_limite_amount=date("d/m/Y 20:00",strtotime($hoy.' +'.($c).' days'));
					$fecha_limite=date("d/m/Y 00:00");

	            	//variable que va al array
					$fechaLimite=date('Y-m-d 00:00');
				}else
				{
					$fecha_limite_amount=date("d/m/Y H:i",strtotime($cancelacion->from.' -7 days'));
					$fecha_limite=date("d/m/Y H:i",strtotime($cancelacion->from.' -8 days'));

	            	//variable que va al array
					$fechaLimite=date("Y-m-d H:i",strtotime($cancelacion->from.' -8 days'));

				}
				$cancelPenalties['fecha_limite_inicial'] = $fecha_limite_amount;
				$cancelPenalties['precio'] = number_format($importe,2).' '.$moneda;
				$fchl['fecha']=strtotime($fechaLimite);
				array_push($fechas_limite, $fchl);
				array_push($fechas_limite_h, $cancelacion->from);
			}
			$fechaCount=count($fechas_limite);
			$fechaHCount=count($fechas_limite_h);
			if ($fechaCount>=1) {
				$comparar='	if ($a[fecha] == $b[fecha]) {
					return 1;
				}
				return ($a[fecha] < $b[fecha]) ? -1 : 1;';
				usort($fechas_limite, create_function('$a,$b', $comparar));
				$fecha_limite=date('d/m/Y',$fechas_limite[0]['fecha']);
			}
			if ($fechaHCount>=1) {
				$comparar='	if ($a[fecha] == $b[fecha]) {
					return 1;
				}
				return ($a[fecha] < $b[fecha]) ? -1 : 1;';
				usort($fechas_limite_h, create_function('$a,$b', $comparar));
				$fecha_limite_h=date('d/m/Y',strtotime($fechas_limite_h[0]['fecha']));
			}

		}else
		{
			if($bandera==true)
				$cancelPenalties['fecha_limite_inicial'] = 'Gastos de cancelación al reservar';
		}


		if($fecha_inicial==date("Y-m-d"))
			$cancelPenalties['nota'] = "Aplica cargo de cancelación inmediato. ";

		return array('cancelPenalties'=>$cancelPenalties,'fecha_limite'=>$fecha_limite,'fecha_limite_h'=>$fecha_limite_h,'fearray'=>$fechas_limite_h);
	}



	/**

	 * Performs the AJAX validation.

	 * @param CModel the model to be validated

	 */

	protected function performAjaxValidation($model)

	{

		if(isset($_POST['ajax']) && $_POST['ajax']==='transporte-form')

		{

			echo CActiveForm::validate($model);

			Yii::app()->end();

		}

	}

        public function actionGenerateExcel()

	{

            $session=new CHttpSession;

            $session->open();		

            

             if(isset($session['Transporte_records']))

               {

                $model=$session['Transporte_records'];

               }

               else

                 $model = Transporte::model()->findAll();



		

		Yii::app()->request->sendFile(date('YmdHis').'.xls',

			$this->renderPartial('excelReport', array(

				'model'=>$model

			), true)

		);

	}

        public function actionGeneratePdf() 

	{

           $session=new CHttpSession;

           $session->open();

		Yii::import('application.extensions.bootstrap.gii.*');

		require_once('bootstrap/tcpdf/tcpdf.php');

		require_once('bootstrap/tcpdf/config/lang/eng.php');



             if(isset($session['Transporte_records']))

               {

                $model=$session['Transporte_records'];

               }

               else

                 $model = Transporte::model()->findAll();







		$html = $this->renderPartial('expenseGridtoReport', array(

			'model'=>$model

		), true);

		

		//die($html);

		

		$pdf = new TCPDF();

		$pdf->SetCreator(PDF_CREATOR);

		$pdf->SetAuthor(Yii::app()->name);

		$pdf->SetTitle('Transporte Report');

		$pdf->SetSubject('Transporte Report');

		//$pdf->SetKeywords('example, text, report');

		$pdf->SetHeaderData('', 0, "Report", '');

		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");

		$pdf->setHeaderFont(Array('helvetica', '', 8));

		$pdf->setFooterFont(Array('helvetica', '', 6));

		$pdf->SetMargins(15, 18, 15);

		$pdf->SetHeaderMargin(5);

		$pdf->SetFooterMargin(10);

		$pdf->SetAutoPageBreak(TRUE, 0);

		$pdf->SetFont('dejavusans', '', 7);

		$pdf->AddPage();

		$pdf->writeHTML($html, true, false, true, false, '');

		$pdf->LastPage();

		$pdf->Output("Transporte_002.pdf", "I");

	}

}

