<?php

class HotelesDestacadosController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/altair';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new HotelesDestacados;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['HotelesDestacados']))
		{
			$model->attributes=$_POST['HotelesDestacados'];
			if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['HotelesDestacados']))
		{
			$model->attributes=$_POST['HotelesDestacados'];
			if($model->save())
				$this->redirect(array('index'));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}
	public function buenFin($id_hotel,$proveedor)
    {
    	$hoteles="7,25,178008,24,406,4,609,265,277,550,264,279,178220,169530,322,475,89,90,165,88,254,383,15,5,394,44,45,46,295,178135,329,169578,178218,178250,41,171,177894,147,122,169485,19,20,21,301,178052,177909,177912,177817,177818,177819,177820,169525,178185,178186,178122,178190,178189,178192,178188,178191,169480,169474,177785,169481,169482,169571,169516,169517,169542,169545,177890,291,178106,178107,178108,178109,178110,178111,178112,178114,178115,178116,178126,178240,178241,178242,178243,178244,139,169479,362,259,169478";
    	$hoteles=explode(',',$hoteles);
    	$fecha_inicial_buen_fin='2020-11-07';
    	$fecha_final_buen_fin='2020-11-20';
    	if (in_array($id_hotel, $hoteles)&&(date("Y-m-d") >= "2020-11-09" && date("Y-m-d") <= "2020-11-20")) {
    		
	    	return true;
    	}
	    	return false;
    }
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new HotelesDestacados('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['HotelesDestacados']))
		{
                        $model->attributes=$_GET['HotelesDestacados'];
			
			
                   	
                       if (!empty($model->id_hoteles_destacados)) $criteria->addCondition("id_hoteles_destacados = '".$model->id_hoteles_destacados."'");
                     
                    	
                       if (!empty($model->id_hotel)) $criteria->addCondition("id_hotel = '".$model->id_hotel."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    			
                    $session['HotelesDestacados_records']=HotelesDestacados::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}
	
	public function hotelesDestacados($id_hotel) {
		$count = Yii::app()->db->createCommand("
			SELECT COUNT(*)
			FROM tbl_hoteles_destacados
			WHERE id_hotel = :id_hotel
			AND estatus = 1
			AND CURRENT_DATE BETWEEN fecha_inicio AND fecha_final
		")->bindParam(":id_hotel", $id_hotel, PDO::PARAM_INT)->queryScalar();
		return ($count >= 1) ? 1 : 0;
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new HotelesDestacados('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['HotelesDestacados']))
			$model->attributes=$_GET['HotelesDestacados'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=HotelesDestacados::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='hoteles-destacados-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['HotelesDestacados_records']))
               {
                $model=$session['HotelesDestacados_records'];
               }
               else
                 $model = HotelesDestacados::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['HotelesDestacados_records']))
               {
                $model=$session['HotelesDestacados_records'];
               }
               else
                 $model = HotelesDestacados::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('HotelesDestacados Report');
		$pdf->SetSubject('HotelesDestacados Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("HotelesDestacados_002.pdf", "I");
	}
}
