<?php

class LogWsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel','xmlReturn'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		/*$this->render('view',array(
			'model'=>$this->loadModel($id),
		));*/
		/*echo Yii::app()->createUrl('getTarifas/obtenerTatifas')."<br>";
		echo Yii::app()->baseUrl;*/
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function Create($data, $ws)
	{
		$model=new LogWs;
		$logHotelbeds = new LogHotelbeds;	

		$logHotelbeds->header = $data['header'];
		$logHotelbeds->request = $data['request'];
		$logHotelbeds->response = $data['response'];
		$logHotelbeds->reference = $data['reference']; 

		if($logHotelbeds->save())
		{
			$model->id_log_ws=$logHotelbeds->id;
			$model->ws=$ws;
			$model->referencia=$logHotelbeds->reference;
			$model->tipo=$data['header'];
			if(!$model->save())
			{
				CJSON::encode($model->getError());
			}else{
				//$this->redirect('index');
				$response=true;
			}
			//else
			//	echo json_encode($model->getErrors());
		}else{
			CJSON::encode($logHotelbeds->getError());
				//$this->redirect('index');
			$response=false;
		}

		/*$this->render('create',array(
			'model'=>$model,
		));*/
		return $response;
	}

	public function Activities($data, $ws)
	{
		$model=new LogWs;
		$logHotelbeds = new LogActivities;	

		
		$logHotelbeds->request = $data['request'];
		$logHotelbeds->response = $data['response'];
		$logHotelbeds->reference = $data['reference']; 

		if($logHotelbeds->save())
		{
			$model->id_log_ws=$logHotelbeds->id;
			$model->ws=$ws;
			$model->referencia=$logHotelbeds->reference;
			$model->tipo=$data['header'];
			if(!$model->save())
			{
				CJSON::encode($model->getError());
			}else{
				//$this->redirect('index');
				$response=true;
			}
			//else
			//	echo json_encode($model->getErrors());
		}else{
			CJSON::encode($logHotelbeds->getError());
				//$this->redirect('index');
			$response=false;
		}

		/*$this->render('create',array(
			'model'=>$model,
		));*/
		return $response;
	}
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['LogWs']))
		{
			$model->attributes=$_POST['LogWs'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->idLog));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new LogWs('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['LogWs']))
		{
                        $model->attributes=$_GET['LogWs'];
			
			
                   	
                       if (!empty($model->idLog)) $criteria->addCondition("idLog = '".$model->idLog."'");
                     
                    	
                       if (!empty($model->id_log_ws)) $criteria->addCondition("id_log_ws = '".$model->id_log_ws."'");
                     
                    	
                       if (!empty($model->ws)) $criteria->addCondition("ws = '".$model->ws."'");
                     
                    	
                       if (!empty($model->referencia)) $criteria->addCondition("referencia = '".$model->referencia."'");
                     
                    	
                       if (!empty($model->tipo)) $criteria->addCondition("tipo = '".$model->tipo."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    			
                    $session['LogWs_records']=LogWs::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new LogWs('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['LogWs']))
			$model->attributes=$_GET['LogWs'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=LogWs::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='log-ws-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['LogWs_records']))
               {
                $model=$session['LogWs_records'];
               }
               else
                 $model = LogWs::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['LogWs_records']))
               {
                $model=$session['LogWs_records'];
               }
               else
                 $model = LogWs::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('LogWs Report');
		$pdf->SetSubject('LogWs Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("LogWs_002.pdf", "I");
	}

	public function actionXmlReturn($id,$ws) {
		if ($ws!="Actividad") {
			$log= LogHotelbeds::model()->findByPk($id);
			if (empty($log)) {
	   			$log= LogHotelbeds0::model()->findByPk($id);
			}
		}else{
	   		$log= LogActivities::model()->findByPk($id);
		}

				
		

	   	echo "<div>
	   		<h2>Request:</h2>
	   		<textarea rows='19' cols='80'>".$log->request."</textarea>
	   	</div><div>
	   		<h2>Response:</h2>
	   		<textarea rows='19' cols='80'>".$log->response."</textarea>
	   	</div>";
	}
	public function logCreate($data, $ws)
	{
		// if ($data['header'] !== 'avail') {
			$tbl=$this->SwtichTipo($data);		
			$id=$this->insertSql($tbl,$data);
			if($id>0)
			{
				$model=new LogWs;
				$model->id_log_ws=$id;
				$model->ws=$ws;
				$model->tipo=$data['header'];
				if(!$model->save())
				{
					print_r($model->getErrors());
				}else{
					//$this->redirect('index');
					$response=$model->id_log_ws;
				}
				//else
				//	echo json_encode($model->getErrors());
			}else{
					//$this->redirect('index');
				$response=false;
			}
		// }else{
		// 	$response = 0;
		// }
		/*$this->render('create',array(
			'model'=>$model,
		));*/
		return $response;
	}
	public function Update($id,$data)
	{
		// if ($id !== 0) {
			$model=LogWs::model()->find('id_log_ws='.$id.' and tipo="'.$data['header'].'"');
			$model->referencia= $data['reference'];
			$model->save();
			$tbl=$this->SwtichTipo($data);
			$logHotelbeds=$this->updateSql($id,$tbl,$data);
			//$logHotelbeds==true;
			if ($logHotelbeds==true) {
						return true;
			}
		// }
	}
	public function insertSql($tbl,$data)
	{
		$val=base64_encode($data['request']);
		$sql="INSERT INTO ".$tbl." (`request`) VALUES (COMPRESS('".$val."')) ";
		$list= Yii::app()->db->createCommand($sql)->query();
		return Yii::app()->db->lastInsertID;


	}
	public function updateSql($id,$tbl,$data)
	{
		$val=base64_encode($data['response']);
		$sql=" UPDATE ".$tbl." SET `response` = COMPRESS('".$val."'), reference='".$data["reference"]."'  WHERE id=".$id;
		$list= Yii::app()->db->createCommand($sql)->query();
		if ($list) {
			
			return true;
		}
		return false;

	}
	public function SwtichTipo($data)
	{
		switch ($data['header']) {
			case "avail":
				$tbl ="tbl_log_avail";
				break;
			case "book":
				$tbl = "tbl_log_book";
				break;
			case "simulation":
				$tbl = "tbl_log_cancel";	
				break;
			case "cancel":
				$tbl = "tbl_log_cancel";				
				break;
			case "cancelCron":
				$tbl = "tbl_log_cancel";
				break;
			case "cancelAg":
				$tbl = "tbl_log_cancel";
				break;
			case "fastBook":
				$tbl = "tbl_log_book";
				break;
			case "recheck":
				$tbl = "tbl_log_book";
			break;

		}
		return $tbl;
	}
}