<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PATCH, PUT, DELETE, OPTIONS');

class MITLigaController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view','bancoEnlace', 'mailEnlace','VerificarCampos'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new MITLiga;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['MITLiga']))
		{
			$model->attributes=$_POST['MITLiga'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_MIT));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['MITLiga']))
		{
			$model->attributes=$_POST['MITLiga'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_MIT));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	public function actionbancoEnlace()
	{
		$model =  new MITLiga;
		$model->id_usuario=$_POST['id_usuario'];
		$model->referencia=$_POST['ref'];
		$model->email=$_POST['email'];
		$model->celular=$_POST['celular'];
		$model->banco=$_POST['banco'];
		$model->estatus=$_POST['estatus'];
		$model->importe=$_POST['importe'];
		$model->tipo=$_POST['tipoLiga'];
		if($model->save()){
			try {
				$liga_pago = "https://www.rutamayatravel.com/reservaciones/pagoenlinea/?ref=".base64_encode($model->id_MIT);
				$this->mailInterno($liga_pago,$_POST['id_usuario'],$_POST['importe'],$_POST['ref'],$_POST['tipoLiga']);
				echo CJSON::encode($liga_pago);
			} catch (Exception $e) {
				
				echo CJSON::encode($model->getErrors());
			}
		}else{
			echo "Completa los campos vacíos";
			// echo CJSON::encode($model->getErrors()); 
		}

	}

	public function actionmailEnlace()
	{
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <".Yii::app()->user->email.">\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$fecha = date("d-m-Y H:i:s");
		$recipent = $_POST["email_enlace"];
		$subject = "Enlace de Pago de su Reservación";
		if ($_POST['enlace']) {
			$message = "
				<center><b>RUTA MAYA TRAVEL</b><br>
				Entre en el siguiente enlace, para poder pagar en linea su reservación <br><br>
				<a href=".$_POST['enlace'].">Pagar en linea</a></center>
				
		";
		}else{echo "Mensaje No enviado. Intente de nuevo";}
		
		
		// message lines should not exceed 70 characters (PHP rule), so wrap it
		// send mail
		if(mail($recipent,$subject,$message,$encabezados)){

			echo 'Mensaje Enviado!';
		}else{
			echo "Mensaje No enviado. Intente de nuevo";
		}
		
	}

	public function mailInterno($liga_pago,$id_usuario,$importe,$ref,$tipo){
		// contabilidad@rutamayatravel.com
		// programador@rutamayatravel.com
		$fechaCreacion = date("d-m-Y H:i:s"); 
		$logusuario = Usuarios::model()->findByPk($id_usuario);
		$encabezados  = "MIME-Version: 1.0\n";
		$encabezados .= "Content-type: text/html; charset=UTF-8\n";
		$encabezados .= "From:  Ruta Maya Travel <programador@rutamayatravel.com>\n";
		$encabezados .= 'Bcc: programador@rutamayatravel.com' . "\r\n";
		$encabezados .= 'cc: programador3@rutamayatravel.com' . "\r\n";
		$encabezados .= "X-Sender: <contacto web>\n";
		$encabezados .= "X-Mailer: PHP\n";
		$encabezados .= "X-Priority: 3\n";
		$encabezados .= "Return-Path: <web page>\n";
		$recipent = 'contabilidad@rutamayatravel.com';
		$subject = "Enlace de Pago Creado";
		if ($liga_pago) {
			$message = "
				<center><b>RUTA MAYA TRAVEL</b><br>
				Se generó un enlace de pago: <br><br>
				<span><a href=".$liga_pago.">".$liga_pago."</a></span><br><br>
				Enlace generado por: ".$logusuario->nombre_usuario."<br><br>
				Por la cantidad de: $ ".number_format($importe,2)."<br><br>
				Referencia: ".$ref."<br><br>
				Tipo: ".$tipo."<br><br>
				Fecha de creacion: ".$fechaCreacion."
				</center>
				
		";
		}else{return false;} 
		mail($recipent,$subject,$message,$encabezados);
	}

	public function actionverificarCampos($id){

		$liga_id="";

		switch ($_POST['tipoLiga']) {
			case 'RESERVACION':
					$liga = Reservacion::model()->find('id_reservacion='.$id);
					$liga_id = $liga->id_reservacion;
				break;
			case 'GRUPOS':
					$liga = Bloqueos::model()->find("id_bloqueo=".$id);
					$liga_id = $liga->id_bloqueo;
				break;
			case 'TOUR':
					$liga = TourReservacion::model()->find('id_tourReservacion='.$id);
					$liga_id = $liga->id_tourReservacion;
				break;
			case 'ACTIVITY':
					$liga = ActivityReservacion::model()->find('id_reservacion='.$id);
					$liga_id = $liga->id_reservacion;
				break;
			case 'BODAS':
					$liga = Bloqueos::model()->find("id_bloqueo=".$id." AND tipo LIKE 'GRUPAL'");
					$liga_id = $liga->id_bloqueo;
				break;
			default:
				# code...
				break;

		}

		if ($liga_id) {
			echo CJSON::encode($liga);
		}else{
			echo "No se encuentra la referencia";
		}
			
	}



	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('MITLiga');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new MITLiga('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['MITLiga']))
			$model->attributes=$_GET['MITLiga'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=MITLiga::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='mitliga-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
