<?php

require_once('../api/omnibees/Token.php');



class OmniBeesController extends Controller

{

	/**

	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning

	 * using two-column layout. See 'protected/views/layouts/column2.php'.

	 */


	public $layout='//layouts/column1';

	

	//PRODUCCION

	public $username='rutamayatravel';

	public $password="jcilqiqhudejdngu";

	public $url="https://pull.omnibees.com/Pullservice.svc?wsdl";

	

	//DEMO

	/*public $username="RutaMaya";

	public $password="E2KZDsEO";

	public $url="https://pullcert.omnibees.com/Pullservice.svc?wsdl";*/

	

	/*

	 * @return array action filters

	 */

	public function filters()

	{

		return array(

			'accessControl', // perform access control for CRUD operations

		);

	}



	/**

	 * Specifies the access control rules.

	 * This method is used by the 'accessControl' filter.

	 * @return array access control rules

	 */

	public function accessRules()

	{

		return array(

			array('allow',  // allow all users to perform 'index' and 'view' actions

				'actions'=>array('hotelOmniBees','cancelarBooking','cancelar'),

				'users'=>array('@'),

			),

			array('deny',  // deny all users

				'users'=>array('*'),

			),

		);

	}



	/**

	 * Displays a particular model.

	 * @param integer $id the ID of the model to be displayed

	 */

	public function hotelOmniBees($codigoHotel,$availRatesOnly, $id_hotel,$countryCode, $session_api)

	{

		$token= new Token;

		$echoToken=$token->obtenToken();

		$session=new CHttpSession;

		$session->open();

		if ($_SESSION["front_form"]) {
					# code...	
			$front_form = $_SESSION["front_form"];

		}else{

			$front_form = $session_api;
		}
		

		// $front_form = $session_api;

		$UserName = $this->username;
		$Password = $this->password;
		$url = $this->url; //esta es la buena

		if ($countryCode=="MX") {
			$currencyCode="MXN";
		}else{
			$currencyCode="USD";
		}

		$fechaEntrada=implode("-",array_reverse(explode("/",$front_form['fecha_ini']))); //date("Y-m-d",strtotime());

		$fechaSalida=implode("-",array_reverse(explode("/",$front_form['fecha_fin'])));   //date("Y-m-d",strtotime());



		$data=array("GetHotelAvail"=>array(

			"login"=>array("Password"=>$Password, "UserName"=>$UserName),

			"ota_HotelAvailRQ"=>array(

				"AvailRatesOnly"=>$availRatesOnly,

				"BestOnly"=>false,

				"EchoToken"=>$echoToken,

				"HotelSearchCriteria"=>array(

					"AvailableOnlyIndicator"=>null,					

					"Criterion"=>array(

						"Address"=>null,

						"Award"=>null,

						"GetPricesPerGuest"=>true,

						"HotelAmenity"=>null,

						"HotelRefs"=>array(

							0=>array(

									"HotelCode"=>$codigoHotel

								)

						),

						"RoomStayCandidatesType"=>array(

							"RoomStayCandidates"=>array()

						),

						"StayDateRange"=>array(

							"Duration"=>null,

							'Start'=>$fechaEntrada.'T00:00:00',

							'End'=>$fechaSalida.'T00:00:00'

						),

						"TPA_Extensions"=>array(

							"AmountIncludingMarkup"=>null,

							"AmountIsPackageRates"=>null,

							"AmountNotIncludingMarkup"=>null,

							"IsForMobile"=>false,

							"MultimediaObjects"=>array(

								"SendData"=>false

							)



						)						

					)

				),

				"IsModify"=>null,

				"MaxResponses"=>null,

				"OnRequestInd"=>false,

				"POS"=>null,	

				"PageNumber"=>null,

				"PrimaryLangID"=>"es",

				"RequestedCurrency"=>$currencyCode,

				"Target"=>"Test",

				"TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',

				"Version"=>2.5,

				))

		);



		$rph=0;



		for ($i=1; $i<=$front_form['habs']; $i++) 

		{ 

			$datapushRoomStayCandidates=array(

						"BookingCode"=>null,

			            "GuestCountsType"=>array(

			            	"GuestCounts"=>array()

			            ),

			            'Quantity' => 1,

			            'RPH' =>  $rph,

			            "RoomID"=>null

		        	);



			array_push($data["GetHotelAvail"]["ota_HotelAvailRQ"]["HotelSearchCriteria"]["Criterion"]["RoomStayCandidatesType"]["RoomStayCandidates"],$datapushRoomStayCandidates);



			$datapushGuestCounts=array(

			            			"Age"=>null,

			            			"AgeQualifyCode"=>"Adult",

			            			"Count"=>$front_form['habitacion_'.$i]['adultos'],

			            			"ResGuestRPH"=>null

			            		);



			array_push($data["GetHotelAvail"]["ota_HotelAvailRQ"]["HotelSearchCriteria"]["Criterion"]["RoomStayCandidatesType"]["RoomStayCandidates"][$rph]["GuestCountsType"]["GuestCounts"],$datapushGuestCounts);



			for ($j=1; $j <=$front_form['habitacion_'.$i]['num_ninios']; $j++) 

			{				
						
				$datapushGuestCounts=array(

			            			"Age"=>$front_form["habitacion_".$i]["edad_".$j],

			            			"AgeQualifyCode"=>"Child",

			            			"Count"=>1,

			            			"ResGuestRPH"=>null

			            		);

				array_push($data["GetHotelAvail"]["ota_HotelAvailRQ"]["HotelSearchCriteria"]["Criterion"]["RoomStayCandidatesType"]["RoomStayCandidates"][$rph]["GuestCountsType"]["GuestCounts"],$datapushGuestCounts);

			}







			$rph++;

		}



		$client = new SoapClient($url);



		try

		{

			$result = $client->__soapCall("GetHotelAvail", $data, NULL, $header);

		}

		catch (SoapFault $exception)

		{

			$result=$exception;

		}



		$logHotelbeds = array();
		$logHotelbeds['header'] = "OmniBeesAvail";
		$logHotelbeds['request'] = json_encode($data);
		$logHotelbeds['response'] = json_encode($result);
		$logHotelbeds['reference'] = $codigoHotel;		
		$this->logWs($logHotelbeds);



		//posiblemente si se necesitaria en otro controlador, vista, layout.
/*		if ($_SESSION["front_form"]) {
		
		$_SESSION['front_form']['roomsRate'][$id_hotel]=json_encode($result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate);
		
		}else{
		
		$front_form['roomsRate'][$id_hotel]=json_encode($result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate);
		}
*/
		return json_encode($result);

	}



	public function actionHotelOmniBees($codigoHotel,$id_hotel,$fecha_inicial, $countryCode)
	{
		$this->tarifasOmniBees($codigoHotel,$id_hotel,$fecha_inicial,1,$countryCode);
	}

	public function tarifasOmniBees($codigoHotel,$id_hotel,$fecha_inicial,$cotizacionrapidaBees,$countryCode,$session_api,$tarifasOmniBees,$mealplanArray)
	{
		if ($_SESSION["front_form"]) {
					# code...	
			$front_form = $_SESSION["front_form"];

		}else{

			$front_form = $session_api;
		}

		// $front_form = $session_api;
		
		if ($_SESSION["tarifasOmniBees"]) {
			$jsonHotel = json_encode($_SESSION['tarifasOmniBees'][$id_hotel]);
			$result = json_decode($jsonHotel);
		}else{
			$tarifasOmniBees = json_decode($tarifasOmniBees);
			$result = $tarifasOmniBees;
		}

		$num_habs=$front_form['habs'];
		// $result=$tarifasOmniBees["tarifasOmniBees"][$id_hotel];
		// echo "code".$result["GetHotelAvailResult"]["Criteria"]["Criterion"]["HotelRefs"]["HotelRef"]["HotelCode"];

		$bandera_result=true;
		$api = Api::model()->findByPk(4);
		
		$sinDisponiblidad='';
		
		$menorTarifaBees=0;
	    
	    $warningsType=array();
	    $arrayRPH=array();
		$arrayROOMS=array();
		$arrayAlloments=array();

		if($result->GetHotelAvailResult->RoomStaysType==null)
		{
	        $result=json_decode($this->hotelOmnibees($result->GetHotelAvailResult->Criteria->Criterion->HotelRefs->HotelRef->HotelCode,false, $id_hotel,$countryCode,$session_api));
	        $bandera_result=false;
		    $warnings=$result->GetHotelAvailResult->WarningsType->Warnings->Warning;

		    for ($w=0; $w < count($warnings) ; $w++) 
		    { 
		    	if(count($warnings)>1)
		    	{
		    		$warning=$warnings[$w];
		    	}else
		    	{
		    		$warning=$warnings;
		    	}

		    	switch ($warning->Code) 
		    	{
		    		case '427':
		    			$warning->ShortText="Fechas no disponibles";
	    			break;
	    			case '575':
		    			$warning->ShortText="Fechas cerradas";
	    			break;
	    			case '411':
		    			$warning->ShortText="Restricción mínima de la estancia";
	    			break;	
	    			case '138':
		    			$warning->ShortText="No acepta niños";
	    			break;	    			
		    	}

		    	$warningsType[$warning->Code]=$warning->ShortText;
		    }
		}
		
		//echo "<textarea>".json_encode($result)."</textarea>";

		$roomsRate=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate;
		$ratePlanType=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RatePlans->RatePlanType;
	    $roomTypes=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomTypes->RoomType;

	    $rooms=count($roomTypes);
	    $rates=count($roomsRate);
	    $plans=count($ratePlanType);

		for ($i=0; $i < $num_habs; $i++) 
		{ 
			for($r=0; $r < $rates; $r++)  
		    {   
		    	if($rates>1)
		    	{
		    		$rate=$roomsRate[$r];
		    	}else
		    	{
		    		$rate=$roomsRate;
		    	}	

				if($i==$rate->RoomStayCandidateRPH)
				{
					array_push($arrayRPH,$i);
				}
			}
		}


		$buscar=array_count_values($arrayRPH);
		$clave = array_search(min($buscar), $buscar);

		for($r=0; $r < $rates; $r++)  
	    {   
	    	if($rates>1)
	    	{
	    		$rate=$roomsRate[$r];
	    	}else
	    	{
	    		$rate=$roomsRate;
	    	}  
	

			if($clave==$rate->RoomStayCandidateRPH)
			{
				array_push($arrayROOMS,$rate->RoomID);				
			}
		}


		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
		    	$roomType=$roomTypes[$i];
			}else
			{
				$roomType=$roomTypes;
			}
			
		   	if(in_array($roomType->RoomID, $arrayROOMS))
		   	{
		    	if($roomType->NumberOfUnits>=$num_habs)
	   			{
		   			$arrayAlloments[$roomType->RoomID]=$roomType->NumberOfUnits;	
	   			}
		   	}
			
		}

		if(count($arrayAlloments)==0)
		{
			$bandera_result=false;
			$warningsType[000]="El número de habitaciones cotizadas supera al número de habitaciones disponibles";
		}

		/*echo json_encode($arrayROOMS);
		echo count($arrayAlloments);*/

		$data=array('id_hotel'=>$id_hotel,'fecha_inicial'=>$fecha_inicial,'noches'=>$noches,'resultHotel'=>$result,'roomsRate'=>$roomsRate,'ratePlanType'=>$ratePlanType,'roomTypes'=>$roomTypes,'rooms'=>$rooms,'rates'=>$rates,'plans'=>$plans,'arrayROOMS'=>$arrayROOMS,'api' => $api,'warningsType'=>$warningsType);

		#######################################


		if($bandera_result!=false)
		{			
			if($cotizacionrapidaBees==1)
			{
				for ($i=0; $i < $num_habs; $i++)
				{
					if (!in_array($i, $arrayRPH))
					{
						$sinDisponiblidad.=$this->sinDisponiblidad($i+1,$session_api);
					}
					
				}
				
				if($sinDisponiblidad!='')
				{
					echo $sinDisponiblidad;
				}else
				{
					$siteController = Yii::app()->createController('site');
					$siteController = $siteController[0];
					$fecha_limite=$siteController->getFechaLimitePago(0,$data["fecha_inicial"],0);
					$data["fecha_limite"]=date("d/m/Y H:i",strtotime($fecha_limite));
					
					$this->renderPartial('cotizacionrapidaBees',$data);
				}
			}else
			{
				$menorPrecioOmniBees=$this->menorTarifaBees($data, $front_form["habs"]);
			}

		}else 
		{
			##WarningsType

	        if($cotizacionrapidaBees==1)
	        {
				$this->renderPartial('sinDisponibilidad',$data);
			}

		}



		if($menorPrecioOmniBees>0)
			$menorprecioOmni=$menorPrecioOmniBees;
			// $_SESSION['menorPrecioOmniBees'][$id_hotel]=$menorPrecioOmniBees;	
		else
			unset($menorprecioOmni);			
			// 	unset($_SESSION['menorPrecioOmniBees'][$id_hotel]);
			

		// echo json_encode($menorprecioOmni);

		return $menorprecioOmni;
	}

	public function tarifasOB($codigoHotel,$id_hotel,$fecha_inicial,$cotizacionrapidaBees,$countryCode,$session_api,$tarifasOmniBees,$mealplanArray)
	{
		if ($_SESSION["front_form"]) {
					# code...	
			$front_form = $_SESSION["front_form"];

		}else{

			$front_form = $session_api;
		}

		// $front_form = $session_api;
		
		if ($_SESSION["tarifasOmniBees"]) {
			$jsonHotel = json_encode($_SESSION['tarifasOmniBees'][$id_hotel]);
			$result = json_decode($jsonHotel);
		}else{
			$tarifasOmniBees = json_decode($tarifasOmniBees);
			$result = $tarifasOmniBees;
		}

		$num_habs=$front_form['habs'];
		// $result=$tarifasOmniBees["tarifasOmniBees"][$id_hotel];
		// echo "code".$result["GetHotelAvailResult"]["Criteria"]["Criterion"]["HotelRefs"]["HotelRef"]["HotelCode"];

		$bandera_result=true;
		$api = Api::model()->findByPk(4);
		
		$sinDisponiblidad='';
		
		$menorTarifaBees=0;
	    
	    $warningsType=array();
	    $arrayRPH=array();
		$arrayROOMS=array();
		$arrayAlloments=array();

		if($result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->Total==null)
		{

	        $bandera_result=false;
		    $warnings=$result->GetHotelAvailResult->WarningsType->Warnings->Warning;

		    for ($w=0; $w < count($warnings) ; $w++) 
		    { 
		    	if(count($warnings)>1)
		    	{
		    		$warning=$warnings[$w];
		    	}else
		    	{
		    		$warning=$warnings;
		    	}

		    	switch ($warning->Code) 
		    	{
		    		case '427':
		    			$warning->ShortText="Fechas no disponibles";
	    			break;
	    			case '575':
		    			$warning->ShortText="Fechas cerradas";
	    			break;
	    			case '411':
		    			$warning->ShortText="Restricción mínima de la estancia";
	    			break;	
	    			case '138':
		    			$warning->ShortText="No acepta niños";
	    			break;	    			
		    	}

		    	$warningsType[$warning->Code]=$warning->ShortText;
		    }
		}
		
		//echo "<textarea>".json_encode($result)."</textarea>";

		$roomsRate=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate;
		$ratePlanType=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RatePlans->RatePlanType;
	    $roomTypes=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomTypes->RoomType;

	    if (($id_hotel==177908||$id_hotel==169548) && $num_habs>1) {
	    	$roomsRate=$this->eliminarRepetido($roomsRate);	
		}

	    $rooms=count($roomTypes);
	    $rates=count($roomsRate);
	    $plans=count($ratePlanType);

		for ($i=0; $i < $num_habs; $i++) 
		{ 
			for($r=0; $r < $rates; $r++)  
		    {   
		    	if($rates>1)
		    	{   
		    		// $ratePlanID[$r]=$roomsRate[$r]->RatePlanID;
		    		// $restringirEstado=RatesEstados::model()->find('id_proveedor=2 and estatus=1 and id_rate_plan='.$roomsRate[$r]->RatePlanID);
		    		// $resEdo=json_decode($restringirEstado->id_estados,true);
		    		// if (!in_array($_SESSION['estadoUsuario'],$resEdo) && $_SESSION['tipoUsuario'] == "Agencia") {
		    		// 	$tipo_precio = "OUTLET";
		    		// 	unset($roomsRate[$r]);
		    		// }else{

		    		// 	$rate=$roomsRate[$r];
		    		// }
		    			$rate=$roomsRate[$r];
		    	}else
		    	{
		    		// $restringirEstado=RatesEstados::model()->find('id_proveedor=2 and estatus=1 and id_rate_plan='.$roomsRate->RatePlanID);
		    		// $resEdo=json_decode($restringirEstado->id_estados,true);
		    		// if (!in_array($_SESSION['estadoUsuario'],$resEdo) && $_SESSION['tipoUsuario'] == "Agencia") {
		    		// 	$tipo_precio = "OUTLET";
		    		// 	$rate="";
		    		// 	//$warningsType[575]="Fechas Cerradas";
		    		// }else{
		    		// 	$rate=$roomsRate;
		    		// }
		    			$rate=$roomsRate;

		    	}	

				if($i==$rate->RoomStayCandidateRPH)
				{
					array_push($arrayRPH,$i);
				}
			}
		}


		$buscar=array_count_values($arrayRPH);
		$clave = array_search(min($buscar), $buscar);

		for($r=0; $r < $rates; $r++)  
	    {   
	    	if($rates>1)
	    	{
	    		$rate=$roomsRate[$r];
	    	}else
	    	{
	    		$rate=$roomsRate;
	    	}  
	

			if($clave==$rate->RoomStayCandidateRPH)
			{
				array_push($arrayROOMS,$rate->RoomID);				
			}
		}


		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
		    	$roomType=$roomTypes[$i];
			}else
			{
				$roomType=$roomTypes;
			}
			
		   	if(in_array($roomType->RoomID, $arrayROOMS))
		   	{
		    	if($roomType->NumberOfUnits>=$num_habs)
	   			{
		   			$arrayAlloments[$roomType->RoomID]=$roomType->NumberOfUnits;	
	   			}
		   	}
			
		}

		if(count($arrayAlloments)==0)
		{
			$bandera_result=false;
			$warningsType[000]="El número de habitaciones cotizadas supera al número de habitaciones disponibles";
		}

		/*echo json_encode($arrayROOMS);
		echo count($arrayAlloments);*/

		$data=array('id_hotel'=>$id_hotel,'fecha_inicial'=>$fecha_inicial,'noches'=>$noches,'resultHotel'=>$result,'roomsRate'=>$roomsRate,'ratePlanType'=>$ratePlanType,'roomTypes'=>$roomTypes,'rooms'=>$rooms,'rates'=>$rates,'plans'=>$plans,'arrayROOMS'=>$arrayROOMS,'api' => $api,'warningsType'=>$warningsType,"disponibilidad"=>$bandera_result);

		#######################################


		if($bandera_result!=false)
		{			
			// if($cotizacionrapidaBees==1)
			// {
				
				for ($i=0; $i < $num_habs; $i++)
				{
					if (!in_array($i, $arrayRPH))
					{
						// echo "aqui";
						$sinDisponiblidad.=$this->sinDisponiblidad($i+1,$session_api);
					}
					
				}
				
				if($sinDisponiblidad!='')
				{
					$data["sinTarifas_Mensaje"] = $sinDisponiblidad;
					$data["sinTarifas"] = true; ### NO HAY TARIFAS EN EL HOTEL
					// echo $sinDisponiblidad;
				}else
				{
					$data["sinTarifas"] = false;
					$data["sinDisponibilidad"] = false;
					$siteController = Yii::app()->createController('site');
					$siteController = $siteController[0];
					$fecha_limite=$siteController->getFechaLimitePago(0,$data["fecha_inicial"],0);
					$data["fecha_limite"]=date("d/m/Y H:i",strtotime($fecha_limite));
					
					$menorPrecioOmniBees=$this->menorTarifaBees($data, $front_form["habs"]);
					
					// echo $id_hotel."____".$menorPrecioOmniBees."<br>";
					// $this->renderPartial('cotizacionrapidaBees',$data);
				}
			// }else
			// {
			// 	$menorPrecioOmniBees=$this->menorTarifaBees($data, $front_form["habs"]);
			// }

		}else 
		{
			##WarningsType

	        // if($cotizacionrapidaBees==1)
	        // {
	        if ($rooms==0) {
	        	for ($i=0; $i < $num_habs; $i++)
				{
					$sinDisponiblidad.=$this->sinDisponiblidad($i+1,$session_api);	
				}

				$data["sinTarifas_Mensaje"] = $sinDisponiblidad;
				$data["sinTarifas"] = true; ### NO HAY TARIFAS EN EL HOTEL
	        	$data["sinDisponibilidad"] = false; ###TIENE TARIFAS PERO NO HAY DISPONIBILIDAD EN NINGUN CUARTO
	        }else{
	        	$data["sinDisponibilidad"] = true; ###TIENE TARIFAS PERO NO HAY DISPONIBILIDAD EN NINGUN CUARTO
	        }
				// $this->renderPartial('sinDisponibilidad',$data);
			// }

		}



		if($menorPrecioOmniBees>0){
			$menorprecioOmni=$menorPrecioOmniBees;
			$data["menorPrecioOmniBees"] = $menorPrecioOmniBees;
			// $_SESSION['menorPrecioOmniBees'][$id_hotel]=$menorPrecioOmniBees;	
		}
		else{
			unset($menorprecioOmni);			
			$data["menorPrecioOmniBees"] = $menorPrecioOmniBees;
		}
			// 	unset($_SESSION['menorPrecioOmniBees'][$id_hotel]);
			

		// echo json_encode($menorprecioOmni);

		return $data;
	}

	public function eliminarRepetido($roomsRate)
	{
			$repeti2=array();
			foreach ($roomsRate as $key=>$room) {
				$repeti2[$room->RatePlanID.$room->RoomStayCandidateRPH.$room->RoomID]=$room;
			}
			$repetidos=array_values($repeti2);
			$repetidos=json_decode(json_encode($repetidos));
			return $repetidos;
	}

	public function tarifasOmniBees2($codigoHotel,$id_hotel,$fecha_inicial,$cotizacionrapidaBees,$countryCode)
	{
		$num_habs=$_SESSION['front_form']['habs'];
		$result=$_SESSION['tarifasOmniBees'][$id_hotel];
		$bandera_result=true;
		$api = Api::model()->findByPk(4); 
		
		$sinDisponiblidad='';
		
		$menorTarifaBees=0;
	    
	    $warningsType=array();
	    $arrayRPH=array();
		$arrayROOMS=array();
		$arrayAlloments=array();
		



		if($result->GetHotelAvailResult->RoomStaysType==null)
		{
	        $result=json_decode($this->hotelOmnibees($result->GetHotelAvailResult->Criteria->Criterion->HotelRefs->HotelRef->HotelCode,false, $id_hotel,$countryCode));
	        $bandera_result=false;
		    $warnings=$result->GetHotelAvailResult->WarningsType->Warnings->Warning;

		    for ($w=0; $w < count($warnings) ; $w++) 
		    { 
		    	if(count($warnings)>1)
		    	{
		    		$warning=$warnings[$w];
		    	}else
		    	{
		    		$warning=$warnings;
		    	}

		    	switch ($warning->Code) 
		    	{
		    		case '427':
		    			$warning->ShortText="Fechas no disponibles";
	    			break;
	    			case '575':
		    			$warning->ShortText="Fechas cerradas";
	    			break;
	    			case '411':
		    			$warning->ShortText="Restricción mínima de la estancia";
	    			break;	
	    			case '138':
		    			$warning->ShortText="No acepta niños";
	    			break;	    			
		    	}

		    	$warningsType[$warning->Code]=$warning->ShortText;
		    }
		}
		
		//echo "<textarea>".json_encode($result)."</textarea>";

		$roomsRate=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomRates->RoomRate;
		$ratePlanType=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RatePlans->RatePlanType;
	    $roomTypes=$result->GetHotelAvailResult->RoomStaysType->RoomStays->RoomStay->RoomTypes->RoomType;

	    $rooms=count($roomTypes);
	    $rates=count($roomsRate);
	    $plans=count($ratePlanType);


		for ($i=0; $i < $num_habs; $i++) 
		{ 
			for($r=0; $r < $rates; $r++)  
		    {   
		    	if($rates>1)
		    	{
		    		$rate=$roomsRate[$r];
		    	}else
		    	{
		    		$rate=$roomsRate;
		    	}	

				if($i==$rate->RoomStayCandidateRPH)
				{
					array_push($arrayRPH,$i);
				}
			}
		}


		$buscar=array_count_values($arrayRPH);
		$clave = array_search(min($buscar), $buscar);

		for($r=0; $r < $rates; $r++)  
	    {   
	    	if($rates>1)
	    	{
	    		$rate=$roomsRate[$r];
	    	}else
	    	{
	    		$rate=$roomsRate;
	    	}  
	

			if($clave==$rate->RoomStayCandidateRPH)
			{
				array_push($arrayROOMS,$rate->RoomID);				
			}
		}


		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
		    	$roomType=$roomTypes[$i];
			}else
			{
				$roomType=$roomTypes;
			}
			
		   	if(in_array($roomType->RoomID, $arrayROOMS))
		   	{
		    	if($roomType->NumberOfUnits>=$num_habs)
	   			{
		   			$arrayAlloments[$roomType->RoomID]=$roomType->NumberOfUnits;	
	   			}
		   	}
			
		}

		if(count($arrayAlloments)==0)
		{
			$bandera_result=false;
			$warningsType[000]="El número de habitaciones cotizadas supera al número de habitaciones disponibles";
		}

		/*echo json_encode($arrayROOMS);
		echo count($arrayAlloments);*/

		$data=array('id_hotel'=>$id_hotel,'fecha_inicial'=>$fecha_inicial,'noches'=>$noches,'resultHotel'=>$result,'roomsRate'=>$roomsRate,'ratePlanType'=>$ratePlanType,'roomTypes'=>$roomTypes,'rooms'=>$rooms,'rates'=>$rates,'plans'=>$plans,'arrayROOMS'=>$arrayROOMS,'api' => $api,'warningsType'=>$warningsType);

		#######################################


		if($bandera_result!=false)
		{			
			if($cotizacionrapidaBees==1)
			{
				for ($i=0; $i < $num_habs; $i++)
				{
					if (!in_array($i, $arrayRPH))
					{
						$sinDisponiblidad.=$this->sinDisponiblidad($i+1);
					}
					
				}
				
				if($sinDisponiblidad!='')
				{
					echo $sinDisponiblidad;
				}else
				{
					$siteController = Yii::app()->createController('site');
					$siteController = $siteController[0];
					$fecha_limite=$siteController->getFechaLimitePago(0,$data["fecha_inicial"],0);
					$data["fecha_limite"]=date("d/m/Y H:i",strtotime($fecha_limite));
					
					$this->renderPartial('cotizacionrapidaBees',$data);
				}
			}else
			{
				$menorPrecioOmniBees=$this->menorTarifaBees($data);
			}

		}else 
		{
			##WarningsType

	        if($cotizacionrapidaBees==1)
	        {
				$this->renderPartial('sinDisponibilidad',$data);
			}

		}



		if($menorPrecioOmniBees>0)
			$_SESSION['menorPrecioOmniBees'][$id_hotel]=$menorPrecioOmniBees;	
		else
			unset($_SESSION['menorPrecioOmniBees'][$id_hotel]);


	}

	public function sinDisponiblidad($hab,$session_api)
	{
		if ($_SESSION["front_form"]) {
					# code...	
			$front_form = $_SESSION["front_form"];

		}else{

			$front_form = $session_api;
		}

		$num_adultos=$front_form['habitacion_'.$hab]['adultos'];
		$num_ninios=$front_form['habitacion_'.$hab]['num_ninios'];

		$criterioMenores='';

		if($num_adultos)
		{
			$criterioAdultos=$num_adultos.' Adulto';
			$criterioAdultos.=($num_adultos>1)?'s':'';
		}

		if($num_ninios)
		{
			$criterioMenores=' - '.$num_ninios.' Menor';
			$criterioMenores.=($num_ninios>1)?'es':'';
		}

		return '<div class="alert alert-warning">
  					<strong>Modifique su búsqueda.</strong><br>
					No existe Disponibilidad para la Habitación '.$hab.': '.$criterioAdultos.$criterioMenores.'
				</div>';
	}


	public function sinDisponiblidad2($hab)
	{
		$num_adultos=$_SESSION['front_form']['habitacion_'.$hab]['adultos'];
		$num_ninios=$_SESSION['front_form']['habitacion_'.$hab]['num_ninios'];

		$criterioMenores='';

		if($num_adultos)
		{
			$criterioAdultos=$num_adultos.' Adulto';
			$criterioAdultos.=($num_adultos>1)?'s':'';
		}

		if($num_ninios)
		{
			$criterioMenores=' - '.$num_ninios.' Menor';
			$criterioMenores.=($num_ninios>1)?'es':'';
		}

		return '<div class="alert alert-warning">
  					<strong>Modifique su búsqueda.</strong><br>
					No existe Disponibilidad para la Habitación '.$hab.': '.$criterioAdultos.$criterioMenores.'
				</div>';
	}

	public function menorTarifaBees($data, $habs)
	{
		$id_hotel=$data['id_hotel'];
		$resultHotel=$data['resultHotel'];
		$roomsRate=$data['roomsRate'];
		$ratePlanType=$data['ratePlanType'];
		$roomTypes=$data['roomTypes'];
		$rooms=$data['rooms'];
		$rates=$data['rates'];
		$plans=$data['plans'];
		$arrayROOMS=$data['arrayROOMS'];
		$api=$data['api'];
		$primeraTarifa="";
		$menorPrecio=0;
		$tipoCambio=1;
		$markup=$api->markup;
		$totales=array();
		// print_r($api);
		// echo $rooms."<br>";

		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
		    	$roomType=$roomTypes[$i];
			}else
			{
				$roomType=$roomTypes;
			}

		   	if(in_array($roomType->RoomID, $arrayROOMS))
		   	{

				if (strpos($roomType->RoomName, 'HEAVEN') !== false) 
				{
				    //$roomType->RoomName=explode("-", $roomType->RoomName)[0];
				    $id_hotelAux=169474;
				}
				else if (strpos($roomType->RoomName, 'Hacienda') !== false)
				{
					//$roomType->RoomName=explode("-", $roomType->RoomName)[0];
					$id_hotelAux=169474;
				}else
				{
		        	$id_hotelAux=$id_hotel;
				}

		        $tipoHabitacion=TipoHabitaciones::model()->find('codigo='.$roomType->RoomID.' AND id_hotel='.$id_hotel);
		        $id_habitacion=0;
				if(count($tipoHabitacion)>0)
		        {
		        	$id_habitacion=$tipoHabitacion->id_tipo_habitacion;
			    }
		        else if($id_hotelAux == $id_hotel && $id_habitacion==0)
		        {
		        	$tipoHabitacion= new TipoHabitaciones;

		        	$tipoHabitacion->tipo_habitacion=strtoupper($roomType->RoomName);
		            $tipoHabitacion->descripcion=strtoupper($roomType->RoomName);
		            $tipoHabitacion->codigo=$roomType->RoomID;
				    $tipoHabitacion->max_adultos=$roomType->MaxOccupancy;

		            $occupancies=$roomType->Occupancies->Occupancy;
		            for ($o=0; $o < count($occupancies); $o++)
		            { 
		            	if(count($occupancies)>1)
						{
					    	$occupancy=$occupancies[$o];
						}else
						{
							$occupancy=$occupancies;
						}

						if($occupancy->AgeQualifyingCode=='Child')
						{
				            $tipoHabitacion->max_menores=$occupancy->MaxOccupancy;

						}else if($occupancy->AgeQualifyingCode!='Child' AND $occupancy->AgeQualifyingCode!='Adult')
						{
							$tipoHabitacion->paxextra=$occupancy->MaxOccupancy;
						}
		            }

		            
		            $tipoHabitacion->id_hotel=$id_hotel;
		            $tipoHabitacion->max_juniors=0;
		            $tipoHabitacion->estatus=1;
		            $tipoHabitacion->activa_validacion=0;
				


					if($tipoHabitacion->save())
		            {
		        		$id_habitacion=$tipoHabitacion->id_tipo_habitacion;
		            }else
		            {
		                print_r($tipoHabitacion->getErrors());
		            }

		        }
	        

		        if($id_habitacion!=0)
		        {
		        
		        	
					for($r=0; $r < $rates; $r++)
			        {
			        	if($rates>1)
				    	{
				    		$rate=$roomsRate[$r];
				    	}
				    	else
				    	{
				    		$rate=$roomsRate;
				    	}

				        if($roomType->RoomID==$rate->RoomID) 
				        {
				        	if (!is_null($rate->Total)) {
				        		# code...
				        		$imprime++;

				        		$total=(($rate->Total->AmountBeforeTax*$tipoCambio)/$markup);
				        		$totalMxn=number_format($total, 2);                 
				        		// echo $totalMxn."<br>";

				        		if($imprime==1)
				        		{				        		
				        			$imprime=-($habs-1);
				        			$rateTotalAmountBeforeTax+=$rate->Total->AmountBeforeTax/$markup;

				        		}else
				        		{
				        			$rateTotalAmountBeforeTax+=$rate->Total->AmountBeforeTax/$markup;
				        		}

				        		if($imprime==0)
				        		{
				        			if(count($totales)==0)
				        			{
				        				$totales[$rate->Total->CurrencyCode]=$rateTotalAmountBeforeTax;
				        			}
				        			else
				        			{
				        				if(min($totales)>$rateTotalAmountBeforeTax)
				        					$totales[$rate->Total->CurrencyCode]=$rateTotalAmountBeforeTax;
				        			}

				        			$moneda=$rate->Total->CurrencyCode;
				        			$rateTotalAmountBeforeTax=0;
				        		}
				        	}
			            }
			        }
			    }
		    }
		}       
		

		return min($totales);
	
	}

	public function menorTarifaBees2($data)
	{
		$id_hotel=$data['id_hotel'];
		$resultHotel=$data['resultHotel'];
		$roomsRate=$data['roomsRate'];
		$ratePlanType=$data['ratePlanType'];
		$roomTypes=$data['roomTypes'];
		$rooms=$data['rooms'];
		$rates=$data['rates'];
		$plans=$data['plans'];
		$arrayROOMS=$data['arrayROOMS'];
		$api=$data['api'];
		$primeraTarifa="";
		$menorPrecio=0;
		$tipoCambio=1;
		$markup=$api->markup;
		$totales=array();

		for($i=0; $i < $rooms ; $i++) 
		{
			if($rooms>1)
			{
		    	$roomType=$roomTypes[$i];
			}else
			{
				$roomType=$roomTypes;
			}

		   	if(in_array($roomType->RoomID, $arrayROOMS))
		   	{

				if (strpos($roomType->RoomName, 'HEAVEN') !== false) 
				{
				    //$roomType->RoomName=explode("-", $roomType->RoomName)[0];
				    $id_hotelAux=169474;
				}
				else if (strpos($roomType->RoomName, 'Hacienda') !== false)
				{
					//$roomType->RoomName=explode("-", $roomType->RoomName)[0];
					$id_hotelAux=169474;
				}else
				{
		        	$id_hotelAux=$id_hotel;
				}

		        $tipoHabitacion=TipoHabitaciones::model()->find('codigo='.$roomType->RoomID.' AND id_hotel='.$id_hotel);
		        $id_habitacion=0;
				if(count($tipoHabitacion)>0)
		        {
		        	$id_habitacion=$tipoHabitacion->id_tipo_habitacion;
			    }
		        else if($id_hotelAux == $id_hotel && $id_habitacion==0)
		        {
		        	$tipoHabitacion= new TipoHabitaciones;

		        	$tipoHabitacion->tipo_habitacion=strtoupper($roomType->RoomName);
		            $tipoHabitacion->descripcion=strtoupper($roomType->RoomName);
		            $tipoHabitacion->codigo=$roomType->RoomID;
				    $tipoHabitacion->max_adultos=$roomType->MaxOccupancy;

		            $occupancies=$roomType->Occupancies->Occupancy;
		            for ($o=0; $o < count($occupancies); $o++)
		            { 
		            	if(count($occupancies)>1)
						{
					    	$occupancy=$occupancies[$o];
						}else
						{
							$occupancy=$occupancies;
						}

						if($occupancy->AgeQualifyingCode=='Child')
						{
				            $tipoHabitacion->max_menores=$occupancy->MaxOccupancy;

						}else if($occupancy->AgeQualifyingCode!='Child' AND $occupancy->AgeQualifyingCode!='Adult')
						{
							$tipoHabitacion->paxextra=$occupancy->MaxOccupancy;
						}
		            }

		            
		            $tipoHabitacion->id_hotel=$id_hotel;
		            $tipoHabitacion->max_juniors=0;
		            $tipoHabitacion->estatus=1;
		            $tipoHabitacion->activa_validacion=0;
				


					if($tipoHabitacion->save())
		            {
		        		$id_habitacion=$tipoHabitacion->id_tipo_habitacion;
		            }else
		            {
		                print_r($tipoHabitacion->getErrors());
		            }

		        }
	        

		        if($id_habitacion!=0)
		        {
		        
		        	
					for($r=0; $r < $rates; $r++)
			        {
			        	if($rates>1)
				    	{
				    		$rate=$roomsRate[$r];
				    	}
				    	else
				    	{
				    		$rate=$roomsRate;
				    	}

				        if($roomType->RoomID==$rate->RoomID) 
				        {
				        	$imprime++;

			                $total=(($rate->Total->AmountBeforeTax*$tipoCambio)/$markup);
			                $totalMxn=number_format($total, 2);                 

			                if($imprime==1)
				        	{				        		
				        		$imprime=-($_SESSION['front_form']['habs']-1);
				        		$rateTotalAmountBeforeTax+=$rate->Total->AmountBeforeTax/$markup;

				        	}else
				        	{
				        		$rateTotalAmountBeforeTax+=$rate->Total->AmountBeforeTax/$markup;
				        	}

				        	if($imprime==0)
				        	{
				        		
				        		if(count($totales)==0)
				        		{
				        			$totales[$rate->Total->CurrencyCode]=$rateTotalAmountBeforeTax;
				        		}
				        		else
				        		{
				        			if(min($totales)>$rateTotalAmountBeforeTax)
					        			$totales[$rate->Total->CurrencyCode]=$rateTotalAmountBeforeTax;
								}
				        		
				        		$moneda=$rate->Total->CurrencyCode;
				        		$rateTotalAmountBeforeTax=0;
				        	}
			            }
			        }
			    }
		    }
		}       
		
		return min($totales);
	
	}


	public function actionCancelarBooking_()

	{

		$token= new Token;

		$echoToken=$token->obtenToken();



		$session=new CHttpSession;

		$session->open();



		$url = $this->url; //esta es la buena



		$UserName = $this->username;

		$Password = $this->password;



		$data=array("SendHotelResCancel"=>array(

				"login"=>array("Password"=>$Password, "UserName"=>$UserName),

				"ota_CancelRQ"=>array(

					"EchoToken"=>$echoToken,

					"TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',

					"Target"=>"Test",

					"Version"=>2.5,

					"PrimaryLangID"=>"es",

					"UniqueID"=>array(

							array(

								"ID"=>$_POST["uniqueID"],

								"Type"=>"Reservation"

							)

					),

					"Verification"=>array(

						"Email"=>"programador1@rutamayatravel.com",

						"HotelRef"=>array(

							"HotelCode"=>$_POST["hotel"]	

						),

						"ReservationTimeSpan"=>array(

							"End"=>$_POST["fecha_out"]."T00:00:00",

							"Start"=>$_POST["fecha_in"]."T00:00:00"

						),

					),

					"CancelType"=>"CancelRoom",

					"Segment"=>array(

						array(

							"ItinSegNbr"=>$_POST["uniqueID"]."/".$_POST["habitacion"],

							"Status"=>"Cancelled"

						)

					),

					"POS"=>null	

					)

			)

		);





		$client = new SoapClient($url);



		try

		{

			$result = $client->__soapCall("SendHotelResCancel", $data, NULL, $header);

		}

		catch (SoapFault $exception)

		{

			$result=$exception;

		}

		$logHotelbeds = array();
		$logHotelbeds['header'] = "OmniBeesCancelar";
		$logHotelbeds['request'] = json_encode($data);
		$logHotelbeds['response'] = json_encode($result);
		$logHotelbeds['reference'] = $_POST["uniqueID"];	
		$this->logWs($logHotelbeds);


		echo json_encode($result);



	}



	public function actionCancelar()

	{

		$this->render("cancelar");

	}

	public function bookingInformation($reference)
	{

		$token= new Token;
		$tokens=$token->obtenToken(); 
		$UserName = $this->username;
		$Password = $this->password;
		$url = $this->url; //esta es la buena
		$data=array("GetBookings"=>
				array(
					"login"=>array(
						"Password"=>$Password, 
						"UserName"=>$UserName
					),
					"ota_ReadRQ"=>array(
					    "UniqueID"=>array(
					    	"ID"=>$reference,
					    	"Type"=>"Reservation"
					    	),
					    "EchoToken"=>$tokens,
					    "PrimaryLangID"=>"es",
					    "Target"=>"Test",
					    "TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',
					 	"Version"=>2.5,
				    )
				)
			);
		
		$client = new SoapClient($url);
		try
		{
			$result = $client->__soapCall("GetBookings", $data, NULL, $header);
			$response=$result->GetBookingsResult->HotelReservationsType->HotelReservations->HotelReservation;
						
		}
		catch(SoapFault $exception)
		{
			print_r($exception);    
		}

		return json_encode($response);
	}



	public function actionCancelarBooking()
	{

		$case=$_POST["cancelar"];

		if($case=="SIMULATION")
		{
			$code=explode("/", $_POST["code"]);
			$reference=substr($code[0], 2);
			$response=$this->bookingInformation($reference);
			echo "<textarea >".$response."</textarea>";
			$reserva=json_decode($response);
			$roomStay=$reserva->RoomStaysType->RoomStays->RoomStay;
			$rooms=count($roomStay);
			$key=$code[1]-1;
			if($rooms==1)
				$room=$roomStay;
			else
				$room=$roomStay[$key];

			if($room->RoomStayStatus->PMS_ResStatusType!="Cancelled")
			{			
				$politicas=$room->RatePlans->RatePlanType->CancelPenalties->CancelPenalty;
				$dias=$politicas->DeadLine->OffsetUnitMultiplier;
				?>

					<p>Costo de cancelación <span class="text-success">$ <?=number_format($politicas->AmountPercent->Amount,2);?></span> apartir de <?=$dias?> antes de <?=$room->RoomRates->RoomRate->EffectiveDate?><span class="text-success"><?php echo date("d/m/Y H:i",strtotime($room->RoomRates->RoomRate->EffectiveDate.' -'.$dias.' days')); ?></span></p>

					<?php 
						//echo "<textarea>".$response."</textarea>";
			}
			else
			{
				echo "<p>La habitación está cancelada</p>";
			}
			$logHotelbeds = array();
			$logHotelbeds['header'] = $case;
			$logHotelbeds['request'] = $reference;
			$logHotelbeds['response'] = $response;
			$logHotelbeds['reference'] =$_POST["code"];	
		 	$logHotelbed=$this->logWs($logHotelbeds);
		}

		else if($_POST["idDesglose"] && $case=="CANCELLATION")
		{
			$code=substr($_POST["code"], 0,-2);
			$itinSegNbr=substr($_POST["code"],2);
			$uniqueID=substr($itinSegNbr, 0,-2);
			$hotel=explode("-", $code)[1];

			$reservacion = Reservacion::model()->find("code='".$code."'");

			$token= new Token;
			$echoToken=$token->obtenToken();

			$session=new CHttpSession;
			$session->open();

			$url = $this->url; //esta es la buena
			$UserName = $this->username;
			$Password = $this->password;

			$data=array("SendHotelResCancel"=>array(
					"login"=>array("Password"=>$Password, "UserName"=>$UserName),
					"ota_CancelRQ"=>array(
						"EchoToken"=>$echoToken,
						"TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',
						"Target"=>"Test",
						"Version"=>2.5,
						"PrimaryLangID"=>"es",
						"UniqueID"=>array(
								array(
									"ID"=>$uniqueID,
									"Type"=>"Reservation"
								)

						),

						"Verification"=>array(
							"Email"=>"programador1@rutamayatravel.com",
							"HotelRef"=>array(
								"HotelCode"=>$hotel
							),

							"ReservationTimeSpan"=>array(
								"End"=>$reservacion->fecha_final."T00:00:00",
								"Start"=>$reservacion->fecha_inicial."T00:00:00"
							),

						),
						"CancelType"=>"CancelRoom",

						"Segment"=>array(
							array(
								"ItinSegNbr"=>$itinSegNbr,
								"Status"=>"Cancelled"
							)

						),
						"POS"=>null	
						)
				)

			);

			$client = new SoapClient($url);

			try
			{
				$result = $client->__soapCall("SendHotelResCancel", $data, NULL, $header);

			}
			catch (SoapFault $exception)
			{
				$result=$exception;
			}

			$logHotelbeds = array();
			$logHotelbeds['header'] = "OmniBeesCancelar";
			$logHotelbeds['request'] = json_encode($data);
			$logHotelbeds['response'] = json_encode($result);
			$logHotelbeds['reference'] = $_POST["uniqueID"];	
		    $logHotelbed=$this->logWs($logHotelbeds);


			
				$response=json_decode($logHotelbeds['response']);
				if($response->SendHotelResCancelResult->Segment->Segment->Status=='Cancelled')
				{

					$habitacion = ReservacionDesglose::model()->findByPk($_POST["idDesglose"]);					
					if($habitacion->id_desglose==$_POST["idDesglose"])
					{
						$habitacion->estatus=0; 
						if($habitacion->save())
							echo "<p>La habitación ha sido cancelada </p>";					
						
					}
				}else
				{
					
					echo "<br>Ocurrió un error al intentar cancelar la reserva.";
				}
			


		}
		
		

	}



	//Habitaciones iguales

	/*********************************************************************************************************************/

	public function bookingOmniBees($codigoHotel)

	{

		$token= new Token;

		$echoTokens=$token->obtenToken();

		$transactionIdentifier=$token->obtenToken();



		$url = $this->url; //esta es la buena



		$UserName = $this->username;

		$Password = $this->password;



		$language="es";
		if($_POST["Reservacion"]["observaciones"]!="")
		{
			$comentariosReservacion=$_POST["Reservacion"]["observaciones"];
		}else
		{
			$comentariosReservacion="La reserva no tiene comentarios";
		}

		

		$total_data=json_decode(base64_decode($_SESSION["Datos"][0]["totalRate"]));

		

		$data=array(

			"SendHotelRes"=>array(

				"login"=>array("Password"=>$Password, "UserName"=>$UserName),

				"ota_HotelResRQ"=>array(		

					"EchoToken"=>$echoTokens,

					"HotelReservationsType"=>array(

						"HotelReservations"=>array(

							0=>array(

								"CreateDateTime"=>"0001-01-01T00:00:00",

	         			        "LastModifyDateTime"=>"0001-01-01T00:00:00",

	         			        "POS"=>null,

								"ResGlobalInfo"=>array(

									"CommentsType"=>array(

										"Comments"=>array(

											0=>array(

												"Description"=>$comentariosReservacion,

												"Language"=>$language,

												"Name"=>null

											)

										)

									),

									"Guarantee"=>array(

										"AmountPercent"=>null,

										"DeadLine"=>null,

										"Duration"=>null,

										"End"=>null,

										"GuaranteeCode"=>null,

										"GuaranteeDescription"=>null,

										"GuaranteesAcceptedType"=>array(

											"GuaranteesAccepted"=>array(

												0=>array(

													"GuaranteeID"=>null,

													"GuaranteeTypeCode"=>"Voucher",

													"PaymentCard"=>null,

													"RPH"=>0

												)

											)

										),

										"Start"=>null

									),

									"HotelReservationsIDsType"=>null,

									"TimeSpan"=>null,

									"Total"=>array(

										"AmountAfterTax"=>null,//Antes de enviar el request se le asigna el total

										"AmountBeforeTax"=>null,//Antes de enviar el request se le asigna el total

										"AmountIncludingMarkup"=>false,

										"AmountIsPackage"=>false,

										"ChargeType"=>"PerStay",

										"CurrencyCode"=>null,//Antes de enviar el request se le asigna el tipo de moneda

										"TPA_Extensions"=>null

									)															

								),

								"ResGuestsType"=>array(

									"ResGuests"=>array(

										/*Pasarejos*/

									),	

								),

							 

								"ResStatus"=>array(

									"PMS_ResStatusType"=>null,

									"TransactionActionType"=>"Book",

								),

								"RoomStaysType"=>array(

									"MoreIndicator"=>false,

									"RoomStays"=>array(

										/*$roomStay*/

									)

									

								),

								"Services"=>null,

								"UniqueID"=>null

							)

						)

					),

					"PrimaryLangID"=>"es",

					"ResStatus"=>null,

					"RetransmissionIndicator"=>null,

					"Target"=>"Test",

					"TimeStamp"=>date("Y-m-d").'T'.date("H:i:s").'Z',

					"TransactionIdentifier"=>$transactionIdentifier,

					"Version"=>2.5

				)

			)

		);



		$i_roomStay=0;



		for ($i=1; $i<=$_SESSION['front_form']['habs']; $i++) 

		{ 

			



				$ratePlan_data=json_decode(base64_decode($_SESSION["Datos"][0]["ratePlan"]));

				$roomRate_data=json_decode($_SESSION["Datos"][0]["roomRates"][$i]);

				$roomType_data=json_decode(base64_decode($_SESSION["Datos"][0]["roomType"]));



				$total_roomRate=$roomRate_data->Total;



				

				$roomStays=array(

					"AvailabilityStatus"=>null,

					"BasicPropertyInfo"=>array(

						"Address"=>null,

						"Award"=>null,

						"ContactNumbersType"=>null,

						"CurrencyCode"=>null,

						"HotelAmenities"=>null,

						"HotelRef"=>array(

							"BrandName"=>null,

							"ChainCode"=>null,

						    "ChainName"=>null,

							"HotelCode"=>$codigoHotel,

							"HotelName"=>null

							),

						"ImageUrl"=>null,

						"Policy"=>null,

						"Position"=>null,

						"VendorMessagesType"=>null

					),

					"CommentsType"=>array(

						"Comments"=>array(

							0=>array(

								"Description"=>$comentariosReservacion,

								"Language"=>$language,

								"Name"=>null

							)

						)

					),

					"Guarantees"=>null,

					"GuestCountsType"=>array(						

						"GuestCounts"=>array(

							

						)

						

					),

					"IndexNumber"=>null,

					"RPH"=>0,

					"RatePlans"=>array(

						/*$ratePlan_data*/

					),

					"Reference"=>null,													

					"RoomRates"=>array(

						/*$roomRate_data*/

					),

					"RoomStayCandidateRPH"=>$i_roomStay,

					"RoomStayStatus"=>null,										 

					"RoomTypes"=>array(

						/*$roomType_data*/

					),

					"SpecialRequestsType"=>array(

						"SpecialRequests"=>array(

							0=>array(

								"Description"=>"This is my room special request",

								"Language"=>$language,

								"Name"=>null

							)

						)

					),

					"TPA_Extensions"=>null,

					"Total"=>array(

						"AmountAfterTax"=>$total_roomRate->AmountAfterTax,

						"AmountBeforeTax"=>$total_roomRate->AmountBeforeTax,

						"AmountIncludingMarkup"=>false,

						"AmountIsPackage"=>false,

						"ChargeType"=>"PerStay",

						"CurrencyCode"=>$total_roomRate->CurrencyCode,

						"TPA_Extensions"=>null

					),

					"RoomStayLanguage"=>$language,

					"WarningRPH"=>null

				);



			array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"],$roomStays);





			if($_POST["Habitacion_".$i]["num_adultos"])

			{

				$guestCounts=array(

								"Age"=>null,

								"AgeQualifyCode"=>"Adult",

								"Count"=>$_POST["Habitacion_".$i]["num_adultos"],

								"ResGuestRPH"=>array( 

									

								)	

							);





					array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$i_roomStay]["GuestCountsType"]["GuestCounts"],$guestCounts);

			}



			if($_POST["Habitacion_".$i]["num_ninios"])

			{

				$guestCounts=array(

								"Age"=>null,

								"AgeQualifyCode"=>"Child",

								"Count"=>$_POST["Habitacion_".$i]["num_ninios"],

								"ResGuestRPH"=>array( 

									

								)	

							);





					array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$i_roomStay]["GuestCountsType"]["GuestCounts"],$guestCounts);

			}



			array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$i_roomStay]["RatePlans"],$ratePlan_data);		

			array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$i_roomStay]["RoomRates"],$roomRate_data);

			array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$i_roomStay]["RoomTypes"],$roomType_data);





			$total_amountBefore+=$total_roomRate->AmountAfterTax;

			$total_amountAfter+=$total_roomRate->AmountBeforeTax;

			$total_currencyCode=$total_roomRate->CurrencyCode;



			$i_roomStay++;





		}



		$resGuestRPH=1;

		$resGuest=0;

		$roomStay=0;

		for ($i=1; $i<=$_SESSION['front_form']['habs']; $i++) 

		{

			

			$guestCount=0;



			for ($j=1; $j <= $_POST["Habitacion_".$i]["num_adultos"]; $j++) 

			{

				$resGuests=array(

		            			"Age"=>30,

		            			"AgeQualifyingCode"=>"Adult",

		            			"PrimaryIndicator"=>($resGuestRPH==1)?true:false,

		            			"Profiles"=>array(

		            				"ProfileInfos"=>array()

		            			),

		            			"ResGuestRPH"=>$resGuestRPH,

		            			"SpecialRequests"=>null

		            		);



				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGuestsType"]["ResGuests"],$resGuests);



				$profileInfos=array(

									"Profile"=>array(

										"Customer"=>array(

											"Address"=>array(

												"AddressLine"=>null,

												"CityCode"=>null,

												"CityName"=> null,

												"CountryCode"=>null,

												"CountryName"=>null,

												"PostalCode"=>null,

												"State"=>null,

												"StateProvCode"=>null,

												"ZoneCode"=>null,

												"ZoneName"=>null



											),

											"BirthDate"=>null,

											"Document"=>null,

											"Email"=>null,

											"Gender"=>null,

											"PersonName"=>array(

												"GivenName"=>$_POST['Adulto_'.$j.'_'.$i]["nombre"],

												"MiddleName"=>null,

												"NamePrefix"=>null,

												"Surname"=>$_POST['Adulto_'.$j.'_'.$i]["apellido"],

											),

											"Telephones"=>($resGuestRPH==1)?array(

												0=>array(

													"Extension"=>null,

													"PhoneLocationType"=>"PropertyDirect",

													"PhoneNumber"=>$_POST["Reservacion"]["tel_cliente"],

													"PhoneTechType"=>"Voice",

													"ShareMarketInd"=>"Yes",

													"ShareSyncInd"=>"Yes" 

												)

											):null



									)

								),

								"UniqueID"=>null

							);

				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGuestsType"]["ResGuests"][$resGuest]["Profiles"]["ProfileInfos"],$profileInfos);



				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$roomStay]["GuestCountsType"]["GuestCounts"][$guestCount]["ResGuestRPH"],$resGuestRPH);



				$resGuest++;

				$resGuestRPH++;



			

			}



			$guestCount++;



			for ($j=1; $j <= $_POST["Habitacion_".$i]["num_ninios"]; $j++) 

			{

				$resGuests=array(

		            			"Age"=>$_POST["Ninio_".$j."_".$i.""]["edad"],

		            			"AgeQualifyingCode"=>"Child",

		            			"PrimaryIndicator"=>($resGuestRPH==1)?true:false,

		            			"Profiles"=>array(

		            				"ProfileInfos"=>array()

		            			),

		            			"ResGuestRPH"=>$resGuestRPH,

		            			"SpecialRequests"=>null

		            		);



				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGuestsType"]["ResGuests"],$resGuests);



				$profileInfos=array(

									"Profile"=>array(

										"Customer"=>array(

											"Address"=>array(

												"AddressLine"=>null,

												"CityCode"=>null,

												"CityName"=> null,

												"CountryCode"=>null,

												"CountryName"=>null,

												"PostalCode"=>null,

												"State"=>null,

												"StateProvCode"=>null,

												"ZoneCode"=>null,

												"ZoneName"=>null



											),

											"BirthDate"=>null,

											"Document"=>null,

											"Email"=>null,

											"Gender"=>null,

											"PersonName"=>array(

												"GivenName"=>$_POST["Ninio_".$j."_".$i.""]["nombre"],

												"MiddleName"=>null,

												"NamePrefix"=>null,

												"Surname"=>$_POST["Ninio_".$j."_".$i.""]["apellido"],

											),

											"Telephones"=>array(

												0=>array(

													"Extension"=>null,

													"PhoneLocationType"=>"PropertyDirect",

													"PhoneNumber"=>$_POST["Reservacion"]["tel_cliente"],

													"PhoneTechType"=>"Voice",

													"ShareMarketInd"=>"Yes",

													"ShareSyncInd"=>"Yes" 

											)

										)



									)

								),

								"UniqueID"=>null

							);

				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGuestsType"]["ResGuests"][$resGuest]["Profiles"]["ProfileInfos"],$profileInfos);

				array_push($data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["RoomStaysType"]["RoomStays"][$roomStay]["GuestCountsType"]["GuestCounts"][$guestCount]["ResGuestRPH"],$resGuestRPH);



				$resGuest++;

				$resGuestRPH++;			

			}



			$roomStay++;

		}



		$data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGlobalInfo"]["Total"]["AmountAfterTax"]=$total_amountBefore;

		$data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGlobalInfo"]["Total"]["AmountBeforeTax"]=$total_amountAfter;

		$data["SendHotelRes"]["ota_HotelResRQ"]["HotelReservationsType"]["HotelReservations"][0]["ResGlobalInfo"]["Total"]["CurrencyCode"]=$total_currencyCode;





		$client = new SoapClient($url);

		

		try{

			$result = $client->__soapCall("SendHotelRes", $data, NULL, $header);



			$return=json_encode($result);



		}catch (SoapFault $exception){

			$return=json_encode($exception);

		}


		$logHotelbeds = array();
		$logHotelbeds['header'] = "OmniBeesBook";
		$logHotelbeds['request'] = json_encode($data);
		$logHotelbeds['response'] = $return;
		$logHotelbeds['reference'] = json_decode($return)->response->SendHotelResResult->HotelReservationsType->HotelReservations->HotelReservation->UniqueID->ID;
		$this->logWs($logHotelbeds);

		return $return;



		

	}

	/********************************************************************************************************************/
private function logWs($data)
	{
		$logWsControl=Yii::app()->createController('logWs');
		$logWsControl=$logWsControl[0];
		return $logWsControl->Create($data, 'OmniBees');
	}


}

