<?php
require_once dirname(__FILE__) . '/../vendors/openpay/Openpay.php';


use Openpay\Data\Openpay;
use Openpay\Resources\OpenpayErrors;

class PagosController extends Controller
{
	public function actionIndex()
	{
		$this->render('index');
	}

	public function actionOpenPay()
	{
		header('Content-Type: application/json');
		$data    = json_decode(file_get_contents('php://input'), true);
		$monto   = 0;
		$moneda  = 'MXN';
		$getData = PasarelasAgencias::model()->find('id_agencia=1 AND id_tipo_pasarela = 3 AND estatus = 1');
		if (is_null($getData)) {
			echo json_encode(['success' => false, 'message' => 'credenciales API Openpay no se encuentran']);
			return false;
		}

		$monto = $data['total'];

		$dash        = Yii::app()->createController('dashboard');
		$dash        = $dash[0];
		$tasa_cambio = $dash->tasaCambioActual();
		$secretKey   = ($getData->ambiente == 0) ? $getData->secret_key_sandbox : $getData->secret_key;
		$currency    = (isset($tasa_cambio['importe'])) ? floatval($tasa_cambio['importe']) : 25.5;

		if ($moneda == "USD") $monto = ($monto * $currency);

		$comision_meses = 0;

		switch ($data['msi']) {
			case '3':
				$comision_meses = 4.8;
				break;
			case '6':
				$comision_meses = 7.8;
				break;
			case '9':
				$comision_meses = 10.8;
				break;
			case '12':
				$comision_meses = 13.8;
				break;
			default:
				$comision_meses = 0;
				break;
		}


		$tasa_base = ($monto * 0.029) + 2.50;
		$tasa_meses = $monto * ($comision_meses / 100);
		$comision_iva = ($tasa_base + $tasa_meses) * 0.16;

		$comision_openpay = $tasa_base + $tasa_meses + $comision_iva;

		$total_comisionado = $monto + $comision_openpay;

		$url_redirect_openpay = "https://" . $_SERVER['SERVER_NAME'] . Yii::app()->baseUrl . "/pagos/esperaTransaccionOpenpay.html";

		$customer = array(
			'name'         => $data['name'],
			'phone_number' => $data['phone'],
			'email'        => $data['email']
		);
		$chargeRequest = array(
			'method'            => 'card',
			'source_id'         => $data['token'],
			'amount'            => number_format($total_comisionado, 2, '.', ''),
			'currency' 			=> $moneda,
			'description'       => 'Cargo por reservación',
			'device_session_id' => $data["deviceSessionId"],
			'customer'          => $customer,
			"use_3d_secure"     => "true",
			"redirect_url"      => $url_redirect_openpay,
		);

		if ($data['msi'] > 0) {
			$chargeRequest['payment_plan'] = array(
				'payments'         => $data['msi'],
			);
		}

		try {
			$openpay = Openpay::getInstance($getData->client_id, $secretKey);
			$charge  = $openpay->charges->create($chargeRequest);
			$url_autentificacion = $charge->payment_method->url;
			//AQUI CREAR RESERVACION
		} catch (\Throwable $th) {
			$success = false;
			$message = OpenpayErrors::getErrors()[$th->getCode()];
		}
		echo json_encode(['success' => (isset($success)) ? $success : true, 'message' => (isset($success)) ? $message : 'Pagado', 'url_autentificacion' => $url_autentificacion]);
	}

	public function actionTransaccion()
	{
		header('Content-Type: application/json');
		$dataRequest   = json_decode(file_get_contents('php://input'), true);

		$model_transaccion = new TransaccionesOpenpay;

		if ($dataRequest["verification_code"]) {
			$verification_code = $dataRequest["verification_code"];
			$id_verification = $dataRequest["id"];

			$model_transaccion->id_transaccion 		= $id_verification;
			$model_transaccion->codigo_verificacion = $verification_code;
			$model_transaccion->estatus 			= "VERIFICAR";

			$model_transaccion->save();
		} else {
			$id_transaccion = $dataRequest["transaction"]["id"];

			$code = $dataRequest["type"];
			$url_redirect = $dataRequest["transaction"]["payment_method"]["url"];
			if (!isset($dataRequest["transaction"]["error_code"])) {
				$error_code = 0;
			} else {
				$error_code = $dataRequest["transaction"]["error_code"];
			}

			$model_transaccion->id_transaccion 	= $id_transaccion;
			$model_transaccion->estatus 		= $code;
			$model_transaccion->url_redirect 	= $url_redirect;
			$model_transaccion->error_code 		= $error_code;

			$model_transaccion->save();
		}
	}

	public function actionEsperaTransaccionOpenpay(){ 
		$this->layout = "//layouts/homezV6";
		$id_transaccion = $_GET["id"];
		$transaccion_openpay = TransaccionesOpenpay::model()->find("id_transaccion = '$id_transaccion'");
		$this->render("espera_transaccion_openpay", array('transaccion_openpay' => $transaccion_openpay));
	}

	public function actionGetTransaccionOpenpay()
	{
		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
		header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
		header("Allow: GET, POST, OPTIONS, PUT, DELETE");

		$id_transaccion = $_GET["id"];
		$transaccion_openpay = TransaccionesOpenpay::model()->find("id_transaccion = '$id_transaccion'");
		if (is_null($transaccion_openpay)) echo CJSON::encode(['success' => false, 'data' => '']);
		else echo CJSON::encode(['success' => true, 'data' => $transaccion_openpay]);
	}
}