<?php

class TarifasFlyersController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout = '//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
				'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
			),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array(
				'allow', 'actions' => array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users' => array('@'),
			),
			array(
				'allow',  // allow all users to perform 'index' and 'view' actions
				'actions' => array('index', 'view', 'actualizarFlyer', 'activarFlyer', 'desactivarFlyer', 'Eliminarflyer', 'landing', 'liberarflyer', 'flyerGet', 'getFlyer', 'getAgencias', 'flyer', 'getLista', 'getListaActivados', 'getDesactivados'),
				'users' => array('*'),
			),
			array(
				'allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions' => array('create', 'update', 'GeneratePdf', 'GenerateExcel'),
				'users' => array('@'),
			),
			array(
				'allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions' => array('admin', 'delete'),
				'users' => array('admin'),
			),
			array(
				'deny',  // deny all users
				'users' => array('*'),
			),
		);
	}

	public function actions()
	{
		return array('REST.' => 'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model' => $this->loadModel($id),
		));
	}

	public function actionGetLista()
	{

		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();

		$model = TarifasFlyers::model()->findAll();

		$item = array();
		foreach ($model as $key => $data) {

			$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa_desglose=' . $data["id_tarifa_desglose"]);
			$tarifa = Tarifa::model()->find('id_tarifa=' . $tarifaDesglose->id_tarifa);
			$hotel = Hoteles::model()->find('id_hotel=' . $tarifa->id_hotel);
			$hotelFotoPrincipal = HotelesFotos::model()->find('id_hotel=' . $tarifa->id_hotel . ' and principal=1');
			$hotelFotoLogo = HotelesFotos::model()->find('id_hotel=' . $tarifa->id_hotel . ' and logotipo=1');
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $tarifa->id_tipo_plan);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $tarifaDesglose->id_tipo_habitacion);
			$menores =  DesgloseMenores::model()->find('id_tipo_habitacion=' . $tarifaDesglose->id_tipo_habitacion . ' and id_tarifa=' . $tarifaDesglose->id_tarifa);


			//MODELO DESGLOSE MENORES
			$item[$key]["num_menores_gratis"] = $menores->num_menores_gratis;
			$item[$key]["edad_min_menor"] = $menores->edad_min_menor;
			$item[$key]["edad_max_menor"] = $menores->edad_max_menor;
			$item[$key]["precio_neto_menor"] = $menores->precio_neto;
			$item[$key]["precio_menor"] = $menores->precio;
			//MODELO PRINCIPAL
			$item[$key]["id_tarifa_flyer"] = $data->id_tarifaFlyer;
			$item[$key]["estatus_flyer"] = $data->estatus;
			//MODELO TARIFA DESGLOSE
			$item[$key]["id_tarifa_desglose"] = $tarifaDesglose->id_tarifa_desglose;
			$item[$key]["id_tarifa"] = $tarifaDesglose->id_tarifa;
			$item[$key]["id_base_habitacion"] = $tarifaDesglose->id_base_habitacion;
			$item[$key]["precio_normal"] = $tarifaDesglose->precio_normal;
			//MODELO HOTELES
			$item[$key]["nombre_hotel"] = $hotel->nombre_hotel;
			$item[$key]["tel_hotel1"] = $hotel->tel_hotel1;
			$item[$key]["email_hotel"] = $hotel->email_hotel;
			$item[$key]["contacto_reservas_1"] = $hotel->contacto_reservas_1;
			$item[$key]["email_reservas_1"] = $hotel->email_reservas_1;
			$item[$key]["calle_hotel"] = $hotel->calle_hotel;
			$item[$key]["ubicacion_hotel"] = $hotel->ubicacion;
			$item[$key]["estrellas_hotel"] = $hotel->estrellas;
			$item[$key]["id_hotel"] = $hotel->id_hotel;
			//MODELO HOTELES FOTOS
			$item[$key]["foto_principal_hotel"] = $hotelFotoPrincipal->foto;
			$item[$key]["foto_logo_hotel"] = $hotelFotoLogo->foto;
			//MODELO HABITACIONES		
			$item[$key]["tipo_habitacion"] = $habitacion->tipo_habitacion;
			//MODELO PLAN
			$item[$key]["tipo_plan"] = $plan->nombre;
			//MODELO TARIFA
			$item[$key]["fecha_promo"] = $tarifa->fecha_promo;
			$item[$key]["fecha_promo_inicio"] = $tarifa->fecha_promo_inicio;


			$item[$key]["fecha_final"] = $tarifa->fecha_final;
			$originalDate2 = $tarifa->fecha_inicial;
			$dia = date("d", strtotime($originalDate2));
			$mes = date("m", strtotime($originalDate2));
			$año = date("Y", strtotime($originalDate2));
			$diamas3 = $dia + 3;
			$fechasumada = $diamas3 . '/' . $mes . '/' . $año;
			// $newDate2 = date("d/m/Y", strtotime($fechasumada));
			$item[$key]["fecha_final_convertida"] = $fechasumada;


			$item[$key]["fecha_inicial"] = $tarifa->fecha_inicial;
			$originalDate = $tarifa->fecha_inicial;
			$newDate = date("d/m/Y", strtotime($originalDate));
			$item[$key]["fecha_incial_convertida"] = $newDate;


			$item[$key]["estatus_tarifa"] = $tarifa->estatus;
			$item[$key]["tipo_precio"] = $tarifa->precio;
			$item[$key]["tipo_moneda"] = $tarifa->moneda;
			$item[$key]["tasa_cambio"] = $tarifa->tasa_cambio;
		}

		echo CJSON::encode($item);
	}

	public function actionGetListaActivados()
	{

		header('Access-Control-Allow-Origin: *');
		header("Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept");
		header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
		$criteria = new CDbCriteria();
		$criteria->addCondition('estatus = "1"');


		$model = TarifasFlyers::model()->findAll($criteria);


		$item = array();
		foreach ($model as $key => $data) {

			$tarifaDesglose = TarifaDesglose::model()->find('id_tarifa_desglose=' . $data["id_tarifa_desglose"]);
			$tarifa = Tarifa::model()->find('id_tarifa=' . $tarifaDesglose->id_tarifa);
			$hotel = Hoteles::model()->find('id_hotel=' . $tarifa->id_hotel);
			$hotelFotoPrincipal = HotelesFotos::model()->find('id_hotel=' . $tarifa->id_hotel . ' and principal=1');
			$hotelFotoLogo = HotelesFotos::model()->find('id_hotel=' . $tarifa->id_hotel . ' and logotipo=1');
			$plan = TipoPlan::model()->find('id_tipo_plan=' . $tarifa->id_tipo_plan);
			$habitacion = TipoHabitaciones::model()->find('id_tipo_habitacion=' . $tarifaDesglose->id_tipo_habitacion);
			$menores =  DesgloseMenores::model()->find('id_tipo_habitacion=' . $tarifaDesglose->id_tipo_habitacion . ' and id_tarifa=' . $tarifaDesglose->id_tarifa);


			$date_now = date("Y-m-d", strtotime(date("d-m-Y")));
			// echo $date_now . "</br>";
			$date_a_comparar =  date($tarifa->fecha_final);
			// echo $date_a_comparar . "</br>";

			if ($date_now < $date_a_comparar) {

				$dia_date = date('d');
				$mes_date = date('m');
				$año_date = date('Y');
				$originalDate2 = $tarifa->fecha_inicial;
				$dia = date("d", strtotime($originalDate2));
				$mes = date("m", strtotime($originalDate2));
				$año = date("Y", strtotime($originalDate2));
				$diamas3 = $dia + 3;
				$fechasumada = $diamas3 . '/' . $mes . '/' . $año;
				$originalDate = $tarifa->fecha_inicial;
				$newDate = date("d/m/Y", strtotime($originalDate));
				array_push($item, array(
					"num_menores_gratis" => $menores->num_menores_gratis,
					"edad_min_menor" => $menores->edad_min_menor,
					"edad_max_menor" => $menores->edad_max_menor,
					"precio_neto_menor" => $menores->precio_neto,
					"precio_menor" => $menores->precio,
					"fecha_actual" => ($dia_date + 1) . "/" . $mes_date . "/" . $año_date,
					"fecha_mas_3_dias" => ($dia_date + 4) . "/" . $mes_date . "/" . $año_date,
					"id_tarifa_flyer" => $data->estatus,
					"estatus_flyer" => $data->id_tarifaFlyer,
					"id_tarifa_desglose" => $tarifaDesglose->id_tarifa_desglose,
					"id_tarifa" => $tarifaDesglose->id_tarifa,
					"id_base_habitacion" => $tarifaDesglose->id_base_habitacion,
					"precio_normal" => $tarifaDesglose->precio_normal,
					"id_base_habitacion" => $tarifaDesglose->id_base_habitacion,
					"nombre_hotel" => $hotel->nombre_hotel,
					"tel_hotel1" => $hotel->tel_hotel1,
					"email_hotel" => $hotel->email_hotel,
					"contacto_reservas_1" =>  $hotel->contacto_reservas_1,
					"email_reservas_1" =>  $hotel->email_reservas_1,
					"calle_hotel" =>  $hotel->calle_hotel,
					"ubicacion_hotel" =>  $hotel->ubicacion,
					"estrellas_hotel" =>  $hotel->estrellas,
					"id_hotel" =>  $hotel->id_hotel,
					"foto_principal_hotel" =>  $hotelFotoPrincipal->foto,
					"foto_logo_hotel" =>  $hotelFotoLogo->foto,
					"tipo_habitacion" =>  $habitacion->tipo_habitacion,
					"tipo_plan" =>  $plan->nombre,
					"fecha_promo" =>  $tarifa->fecha_promo,
					"fecha_promo_inicio" =>  $tarifa->fecha_promo_inicio,
					"fecha_final" =>  $tarifa->fecha_final,
					"tipo_plan" =>  $plan->nombre,
					"fecha_final_convertida" =>  $fechasumada,
					"fecha_inicial" =>  $tarifa->fecha_inicial,
					"fecha_incial_convertida" =>  $newDate,
					"estatus_tarifa" =>  $tarifa->estatus,
					"tipo_precio" =>  $tarifa->precio,
					"tipo_moneda" =>  $tarifa->moneda,
					"tasa_cambio" =>  $tarifa->tasa_cambio

				));				
			}
		}

		echo CJSON::encode($item);
	}
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	//PROYECTO PROMOCIONES
	/** METODO PARA ACTUALIZAR UN REGISTRO EN LA TABLA FLYER */
	public function actionLiberarflyer($id)
	{



		$model_tarifa_flyer =  TarifasFlyers::model()->findAll('id_tarifa_desglose =' . $id);



		if ($model_tarifa_flyer == null) {

			$model = new TarifasFlyers;
			$model->id_tarifa_desglose = $id;
			$model->save();
			if (!$model->save()) {
				print_r($model->getErrors());
				echo $id;
			}
			echo "no existe";
		} else {


			echo " existe";
		}
	}
	public function actionActivarFlyer($id)
	{

		$model = TarifasFlyers::model()->find('id_tarifa_desglose=' . $id);

		$model->estatus = '1';

		$model->save();

		/** Para validar si actualizó correctamente */
		if (!$model->save()) {
			// print_r($model->getErrors());
			// echo $id;
		}
	}
	public function actionDesactivarFlyer($id)
	{

		$model = TarifasFlyers::model()->find('id_tarifa_desglose=' . $id);

		$model->estatus = '0';

		$model->save();

		/** Para validar si actualizó correctamente */
		if (!$model->save()) {
			print_r($model->getErrors());
			// echo $id;
		}
	}
	/** METODO PARA Eliminar UN REGISTRO EN LA TABLA FLYER */
	public function actionEliminarflyer($id)
	{
		$model = TarifasFlyers::model()->findByPk($id); // assuming there is a post whose ID is 10
		$model->delete(); // delete the row from the database table
		if (!$model->delete()) {
			// print_r($model->getErrors());
			// echo $id;
		} else {
			echo "Se elimino correctamente";
		}
	}

	public function actionGetFlyer($id)
	{
		$array_tarifasFlyer = array();
		$model_tarifaDesglose = TarifaDesglose::model()->findByPk($id);
		$model_tarifa = Tarifa::model()->findByPk($model_tarifaDesglose['id_tarifa']);
		$model_hotel = Hoteles::model()->findByPk($model_tarifa['id_hotel']);
		$model_fotos_prin = HotelesFotos::model()->findAll('id_hotel=' . $model_hotel->id_hotel . ' and principal="1"');
		$model_fotos_sec = HotelesFotos::model()->findAll('id_hotel=' . $model_hotel->id_hotel . ' and principal="0" and logotipo="0"');
		$model_tipo_habitacion = TipoHabitaciones::model()->findAll('id_tipo_habitacion=' . $model_tarifaDesglose->id_tipo_habitacion);
		$model_tipo_plan = TipoPlan::model()->findAll('id_tipo_plan=' . $model_tarifa->id_tipo_plan);
		$model_tarifa_flyer = TarifasFlyers::model()->findAll('id_tarifa_desglose=' . $model_tarifaDesglose->id_tarifa_desglose);


		$array_tarifasFlyer["desglose"] = $model_tarifaDesglose;
		$array_tarifasFlyer['tarifa'] = $model_tarifa;
		$array_tarifasFlyer['hotel'] = $model_hotel;
		$array_tarifasFlyer['foto_principal'] = $model_fotos_prin;
		$array_tarifasFlyer['fotos_secundarias'] = $model_fotos_sec;
		$array_tarifasFlyer['habitacion'] = $model_tipo_habitacion;
		$array_tarifasFlyer['plan'] = $model_tipo_plan;
		$array_tarifasFlyer['flyer'] = $model_tarifa_flyer;

		echo CJSON::encode($array_tarifasFlyer);
	}
	public function actionFlyerGet($id)
	{
		$model = TarifasFlyers::model()->find('id_tarifa_desglose=' . $id);
		$item = array();
		if ($model) {
			array_push($item, array(
				"id_tarifaFlyer" => $model->id_tarifaFlyer,
				"id_tarifa_desglose" => $model->id_tarifa_desglose,
				"log" => $model->log,
				"estatus" => $model->estatus

			));
		}
		echo CJSON::encode($item);
	}
	public function actionGetAgencias($id)
	{
		$array_agencias = array();
		$model_agencias = Agencias::model()->findByPk($id);

		$array_agencias['agencia'] = $model_agencias;

		echo CJSON::encode($array_agencias);
	}



	public function actionCreate()
	{
		$model = new TarifasFlyers;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['TarifasFlyers'])) {
			$model->attributes = $_POST['TarifasFlyers'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_tarifaFlyer));
		}

		$this->render('create', array(
			'model' => $model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if (isset($_POST['TarifasFlyers'])) {
			$model->attributes = $_POST['TarifasFlyers'];
			if ($model->save())
				$this->redirect(array('view', 'id' => $model->id_tarifaFlyer));
		}

		$this->render('update', array(
			'model' => $model,
		));
	}
	public function actionLanding()
	{

		$this->layout = '/layouts/flyer_template';
		$this->render("landing");
	}
	public function actionFlyer()
	{

		$this->layout = '/layouts/flyer_template';
		$this->render("flyer");
	}
	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionActualizarFlyer($id)
	{

		$model = TarifasFlyers::model()->findByPk($id);
		if ($model->estatus == '0') {
			$model->estatus = '1';
			echo ("Se activo el ID: " . $id);
			$model->save();
		} else if ($model->estatus == '1') {
			$model->estatus = '0';
			echo ("Se Desactivo el ID: " . $id);
			$model->save();
		}
		/** Para validar si actualizó correctamente */
		if (!$model->save()) {
			// print_r($model->getErrors());
			// echo $id;
		}
	}

	public function actionDelete($id)
	{
		if (Yii::app()->request->isPostRequest) {
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if (!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		} else
			throw new CHttpException(400, 'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$session = new CHttpSession;
		$session->open();
		$criteria = new CDbCriteria();

		$model = new TarifasFlyers('search');
		$model->unsetAttributes();  // clear any default values

		if (isset($_GET['TarifasFlyers'])) {
			$model->attributes = $_GET['TarifasFlyers'];



			if (!empty($model->id_tarifaFlyer)) $criteria->addCondition("id_tarifaFlyer = '" . $model->id_tarifaFlyer . "'");


			if (!empty($model->id_tarifa_desglose)) $criteria->addCondition("id_tarifa_desglose = '" . $model->id_tarifa_desglose . "'");


			if (!empty($model->log)) $criteria->addCondition("log = '" . $model->log . "'");


			if (!empty($model->estatus)) $criteria->addCondition("estatus = '" . $model->estatus . "'");


			$session['TarifasFlyers_records'] = TarifasFlyers::model()->findAll($criteria);
		}


		$this->render('index', array(
			'model' => $model,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new TarifasFlyers('search');
		$model->unsetAttributes();  // clear any default values
		if (isset($_GET['TarifasFlyers']))
			$model->attributes = $_GET['TarifasFlyers'];

		$this->render('admin', array(
			'model' => $model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = TarifasFlyers::model()->findByPk($id);
		if ($model === null)
			throw new CHttpException(404, 'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if (isset($_POST['ajax']) && $_POST['ajax'] === 'tarifas-flyers-form') {
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
	public function actionGenerateExcel()
	{
		$session = new CHttpSession;
		$session->open();

		if (isset($session['TarifasFlyers_records'])) {
			$model = $session['TarifasFlyers_records'];
		} else
			$model = TarifasFlyers::model()->findAll();


		Yii::app()->request->sendFile(
			date('YmdHis') . '.xls',
			$this->renderPartial('excelReport', array(
				'model' => $model
			), true)
		);
	}
	public function actionGeneratePdf()
	{
		$session = new CHttpSession;
		$session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

		if (isset($session['TarifasFlyers_records'])) {
			$model = $session['TarifasFlyers_records'];
		} else
			$model = TarifasFlyers::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model' => $model
		), true);

		//die($html);

		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('TarifasFlyers Report');
		$pdf->SetSubject('TarifasFlyers Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by " . Yii::app()->name, "");
		$pdf->setHeaderFont(array('helvetica', '', 8));
		$pdf->setFooterFont(array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("TarifasFlyers_002.pdf", "I");
	}
}
