<?php

class TourReservacionRestController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column1';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			array(
                'ext.starship.RestfullYii.filters.ERestFilter + 
                REST.GET, REST.PUT, REST.POST, REST.DELETE'
            ),
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', 'actions'=>array('REST.GET', 'REST.PUT', 'REST.POST', 'REST.DELETE'),
				'users'=>array('@'),
			),
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('@'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','GeneratePdf','GenerateExcel'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	public function actions()
	{
        return array('REST.'=>'ext.starship.RestfullYii.actions.ERestActionProvider',);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$model=new TourReservacionRest;

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['TourReservacionRest']))
		{
			$model->attributes=$_POST['TourReservacionRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_tourReservacion));
		}

		$this->render('create',array(
			'model'=>$model,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['TourReservacionRest']))
		{
			$model->attributes=$_POST['TourReservacionRest'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id_tourReservacion));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
            $session=new CHttpSession;
            $session->open();		
            $criteria = new CDbCriteria();            

                $model=new TourReservacionRest('search');
                $model->unsetAttributes();  // clear any default values

                if(isset($_GET['TourReservacionRest']))
		{
                        $model->attributes=$_GET['TourReservacionRest'];
			
			
                   	
                       if (!empty($model->id_tourReservacion)) $criteria->addCondition("id_tourReservacion = '".$model->id_tourReservacion."'");
                     
                    	
                       if (!empty($model->id_tour)) $criteria->addCondition("id_tour = '".$model->id_tour."'");
                     
                    	
                       if (!empty($model->fecha_inicio)) $criteria->addCondition("fecha_inicio = '".$model->fecha_inicio."'");
                     
                    	
                       if (!empty($model->fecha_fin)) $criteria->addCondition("fecha_fin = '".$model->fecha_fin."'");
                     
                    	
                       if (!empty($model->importe)) $criteria->addCondition("importe = '".$model->importe."'");
                     
                    	
                       if (!empty($model->estatus)) $criteria->addCondition("estatus = '".$model->estatus."'");
                     
                    	
                       if (!empty($model->id_agencia)) $criteria->addCondition("id_agencia = '".$model->id_agencia."'");
                     
                    	
                       if (!empty($model->id_usuario)) $criteria->addCondition("id_usuario = '".$model->id_usuario."'");
                     
                    	
                       if (!empty($model->id_agente)) $criteria->addCondition("id_agente = '".$model->id_agente."'");
                     
                    	
                       if (!empty($model->fecha_reserva)) $criteria->addCondition("fecha_reserva = '".$model->fecha_reserva."'");
                     
                    	
                       if (!empty($model->log)) $criteria->addCondition("log = '".$model->log."'");
                     
                    	
                       if (!empty($model->comision)) $criteria->addCondition("comision = '".$model->comision."'");
                     
                    	
                       if (!empty($model->fecha_limite)) $criteria->addCondition("fecha_limite = '".$model->fecha_limite."'");
                     
                    	
                       if (!empty($model->fecha_limite_t)) $criteria->addCondition("fecha_limite_t = '".$model->fecha_limite_t."'");
                     
                    	
                       if (!empty($model->libera_cupon)) $criteria->addCondition("libera_cupon = '".$model->libera_cupon."'");
                     
                    	
                       if (!empty($model->cliente_nombre)) $criteria->addCondition("cliente_nombre = '".$model->cliente_nombre."'");
                     
                    	
                       if (!empty($model->cliente_apellido)) $criteria->addCondition("cliente_apellido = '".$model->cliente_apellido."'");
                     
                    	
                       if (!empty($model->cliente_tel)) $criteria->addCondition("cliente_tel = '".$model->cliente_tel."'");
                     
                    	
                       if (!empty($model->adultos)) $criteria->addCondition("adultos = '".$model->adultos."'");
                     
                    	
                       if (!empty($model->menores)) $criteria->addCondition("menores = '".$model->menores."'");
                     
                    	
                       if (!empty($model->id_tarifa)) $criteria->addCondition("id_tarifa = '".$model->id_tarifa."'");
                     
                    	
                       if (!empty($model->cancelacion_fecha)) $criteria->addCondition("cancelacion_fecha = '".$model->cancelacion_fecha."'");
                     
                    	
                       if (!empty($model->cancelacion_motivo)) $criteria->addCondition("cancelacion_motivo = '".$model->cancelacion_motivo."'");
                     
                    	
                       if (!empty($model->observaciones)) $criteria->addCondition("observaciones = '".$model->observaciones."'");
                     
                    	
                       if (!empty($model->manual)) $criteria->addCondition("manual = '".$model->manual."'");
                     
                    	
                       if (!empty($model->saldo)) $criteria->addCondition("saldo = '".$model->saldo."'");
                     
                    	
                       if (!empty($model->saldo_h)) $criteria->addCondition("saldo_h = '".$model->saldo_h."'");
                     
                    	
                       if (!empty($model->code)) $criteria->addCondition("code = '".$model->code."'");
                     
                    	
                       if (!empty($model->fecha_liberacion)) $criteria->addCondition("fecha_liberacion = '".$model->fecha_liberacion."'");
                     
                    	
                       if (!empty($model->usuario_liberacion)) $criteria->addCondition("usuario_liberacion = '".$model->usuario_liberacion."'");
                     
                    	
                       if (!empty($model->descuento)) $criteria->addCondition("descuento = '".$model->descuento."'");
                     
                    			
                    $session['TourReservacionRest_records']=TourReservacionRest::model()->findAll($criteria); 
		}
       

                $this->render('index',array(
			'model'=>$model,
		));

	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new TourReservacionRest('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['TourReservacionRest']))
			$model->attributes=$_GET['TourReservacionRest'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=TourReservacionRest::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='tour-reservacion-rest-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
        public function actionGenerateExcel()
	{
            $session=new CHttpSession;
            $session->open();		
            
             if(isset($session['TourReservacionRest_records']))
               {
                $model=$session['TourReservacionRest_records'];
               }
               else
                 $model = TourReservacionRest::model()->findAll();

		
		Yii::app()->request->sendFile(date('YmdHis').'.xls',
			$this->renderPartial('excelReport', array(
				'model'=>$model
			), true)
		);
	}
        public function actionGeneratePdf() 
	{
           $session=new CHttpSession;
           $session->open();
		Yii::import('application.extensions.bootstrap.gii.*');
		require_once('bootstrap/tcpdf/tcpdf.php');
		require_once('bootstrap/tcpdf/config/lang/eng.php');

             if(isset($session['TourReservacionRest_records']))
               {
                $model=$session['TourReservacionRest_records'];
               }
               else
                 $model = TourReservacionRest::model()->findAll();



		$html = $this->renderPartial('expenseGridtoReport', array(
			'model'=>$model
		), true);
		
		//die($html);
		
		$pdf = new TCPDF();
		$pdf->SetCreator(PDF_CREATOR);
		$pdf->SetAuthor(Yii::app()->name);
		$pdf->SetTitle('TourReservacionRest Report');
		$pdf->SetSubject('TourReservacionRest Report');
		//$pdf->SetKeywords('example, text, report');
		$pdf->SetHeaderData('', 0, "Report", '');
		$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, "Example Report by ".Yii::app()->name, "");
		$pdf->setHeaderFont(Array('helvetica', '', 8));
		$pdf->setFooterFont(Array('helvetica', '', 6));
		$pdf->SetMargins(15, 18, 15);
		$pdf->SetHeaderMargin(5);
		$pdf->SetFooterMargin(10);
		$pdf->SetAutoPageBreak(TRUE, 0);
		$pdf->SetFont('dejavusans', '', 7);
		$pdf->AddPage();
		$pdf->writeHTML($html, true, false, true, false, '');
		$pdf->LastPage();
		$pdf->Output("TourReservacionRest_002.pdf", "I");
	}
}
