<?php
/**
 * This is the model class for table "{{acceso}}".
 *
 * The followings are the available columns in table '{{acceso}}':
 * @property integer $id_acceso
 * @property integer $id_usuario
 * @property string $lat
 * @property string $lon
 * @property string $fecha
 * @property string $ip
 */
class Acceso extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Acceso the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{acceso}}';
	}
	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, fecha, ip', 'required'),
			array('id_usuario', 'numerical', 'integerOnly'=>true),
			array('lat, lon', 'length', 'max'=>30),
			array('ip', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_acceso, id_usuario, lat, lon, fecha, ip', 'safe', 'on'=>'search'),
		);
	}
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUsuario'=> array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_acceso' => 'Id Acceso',
			'id_usuario' => 'Id Usuario',
			'lat' => 'Lat',
			'lon' => 'Lon',
			'fecha' => 'Fecha',
			'ip' => 'Ip',
		);
	}
	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.
		$criteria=new CDbCriteria;
		$criteria->compare('id_acceso',$this->id_acceso);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('lat',$this->lat,true);
		$criteria->compare('lon',$this->lon,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('ip',$this->ip,true);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}