<?php

/**
 * This is the model class for table "{{act_destinations}}".
 *
 * The followings are the available columns in table '{{act_destinations}}':
 * @property integer $id_destino
 * @property string $countrycode
 * @property string $destinationcode
 * @property string $nombre
 *
 * The followings are the available model relations:
 * @property ActCountries $countrycode0
 */
class ActDestinations extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ActDestinations the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{act_destinations}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('countrycode, destinationcode, nombre', 'required'),
			array('countrycode, destinationcode, nombre', 'length', 'max'=>100),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_destino, countrycode, destinationcode, nombre', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countrycode0' => array(self::BELONGS_TO, 'ActCountries', 'countrycode'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_destino' => 'Id Destino',
			'countrycode' => 'Countrycode',
			'destinationcode' => 'Destinationcode',
			'nombre' => 'Nombre',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_destino',$this->id_destino);
		$criteria->compare('countrycode',$this->countrycode,true);
		$criteria->compare('destinationcode',$this->destinationcode,true);
		$criteria->compare('nombre',$this->nombre,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}