<?php

/**
 * This is the model class for table "tbl_agencia".
 *
 * The followings are the available columns in table 'tbl_agencia':
 * @property integer $id_agencia
 * @property string $referenciaRMT
 * @property string $nom_agencia
 * @property string $emailPrincipal
 * @property string $telefonoPrincipal
 * @property string $telefonoWhatsapp
 * @property string $nosotros
 * @property string $Logo_A
 * @property string $Logo_B
 * @property string $fotoBanner
 * @property string $sitio_web
 * @property string $fb_fanpage
 * @property string $instragram
 * @property string $twitter
 * @property string $youtube
 * @property string $fb_chat
 * @property string $background_nav
 * @property string $texto_nav_color
 * @property string $background_body
 * @property string $texto_body_color
 * @property string $background_botones
 * @property string $texto_botones_color
 * @property integer $id_usuario
 */
class Agencia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Agencia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return CDbConnection database connection
	 */
	public function getDbConnection()
	{
		return Yii::app()->db2;
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_agencia';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('referenciaRMT, nom_agencia, emailPrincipal, telefonoPrincipal, telefonoWhatsapp, nosotros, Logo_A, Logo_B, sitio_web, fb_fanpage, instragram, twitter, youtube, background_nav, texto_nav_color, background_body, texto_body_color, background_botones, texto_botones_color, id_usuario', 'required'),
			array('id_usuario', 'numerical', 'integerOnly'=>true),
			array('referenciaRMT, nom_agencia, emailPrincipal, telefonoPrincipal, telefonoWhatsapp, Logo_A, Logo_B, fotoBanner, sitio_web, fb_fanpage, instragram, twitter, youtube, fb_chat', 'length', 'max'=>255),
			array('background_nav, texto_nav_color, background_body, texto_body_color, background_botones, texto_botones_color', 'length', 'max'=>250),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_agencia, referenciaRMT, nom_agencia, emailPrincipal, telefonoPrincipal, telefonoWhatsapp, nosotros, Logo_A, Logo_B, fotoBanner, sitio_web, fb_fanpage, instragram, twitter, youtube, fb_chat, background_nav, texto_nav_color, background_body, texto_body_color, background_botones, texto_botones_color, id_usuario', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_agencia' => 'Id Agencia',
			'referenciaRMT' => 'Referencia Rmt',
			'nom_agencia' => 'Nom Agencia',
			'emailPrincipal' => 'Email Principal',
			'telefonoPrincipal' => 'Telefono Principal',
			'telefonoWhatsapp' => 'Telefono Whatsapp',
			'nosotros' => 'Nosotros',
			'Logo_A' => 'Logo A',
			'Logo_B' => 'Logo B',
			'fotoBanner' => 'Foto Banner',
			'sitio_web' => 'Sitio Web',
			'fb_fanpage' => 'Fb Fanpage',
			'instragram' => 'Instragram',
			'twitter' => 'Twitter',
			'youtube' => 'Youtube',
			'fb_chat' => 'Fb Chat',
			'background_nav' => 'Background Nav',
			'texto_nav_color' => 'Texto Nav Color',
			'background_body' => 'Background Body',
			'texto_body_color' => 'Texto Body Color',
			'background_botones' => 'Background Botones',
			'texto_botones_color' => 'Texto Botones Color',
			'id_usuario' => 'Id Usuario',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('referenciaRMT',$this->referenciaRMT,true);
		$criteria->compare('nom_agencia',$this->nom_agencia,true);
		$criteria->compare('emailPrincipal',$this->emailPrincipal,true);
		$criteria->compare('telefonoPrincipal',$this->telefonoPrincipal,true);
		$criteria->compare('telefonoWhatsapp',$this->telefonoWhatsapp,true);
		$criteria->compare('nosotros',$this->nosotros,true);
		$criteria->compare('Logo_A',$this->Logo_A,true);
		$criteria->compare('Logo_B',$this->Logo_B,true);
		$criteria->compare('fotoBanner',$this->fotoBanner,true);
		$criteria->compare('sitio_web',$this->sitio_web,true);
		$criteria->compare('fb_fanpage',$this->fb_fanpage,true);
		$criteria->compare('instragram',$this->instragram,true);
		$criteria->compare('twitter',$this->twitter,true);
		$criteria->compare('youtube',$this->youtube,true);
		$criteria->compare('fb_chat',$this->fb_chat,true);
		$criteria->compare('background_nav',$this->background_nav,true);
		$criteria->compare('texto_nav_color',$this->texto_nav_color,true);
		$criteria->compare('background_body',$this->background_body,true);
		$criteria->compare('texto_body_color',$this->texto_body_color,true);
		$criteria->compare('background_botones',$this->background_botones,true);
		$criteria->compare('texto_botones_color',$this->texto_botones_color,true);
		$criteria->compare('id_usuario',$this->id_usuario);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}