<?php

/**
 * This is the model class for table "{{agencias_credito}}".
 *
 * The followings are the available columns in table '{{agencias_credito}}':
 * @property integer $id_credito
 * @property integer $id_agencia
 * @property double $disponible
 * @property double $utilizado
 * @property double $total
 * @property string $log
 * @property string $vigencia
 * @property string $estatus
 *
 * The followings are the available model relations:
 * @property Agencias $idAgencia
 */
class AgenciasCredito extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AgenciasCredito the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{agencias_credito}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_agencia, total, vigencia, estatus', 'required'),
			array('id_agencia, vigencia', 'numerical', 'integerOnly'=>true),
			array('disponible, utilizado, total', 'numerical'),
			array('estatus', 'length', 'max'=>2),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_credito, id_agencia, disponible, utilizado, total, log, vigencia, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idAgencia' => array(self::BELONGS_TO, 'Agencias', 'id_agencia'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_credito' => 'Id Credito',
			'id_agencia' => 'Id Agencia',
			'disponible' => 'Disponible',
			'utilizado' => 'Utilizado',
			'total' => 'Credito Total',
			'log' => 'Log',
			'vigencia' => 'Dias de credito',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_credito',$this->id_credito);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('disponible',$this->disponible);
		$criteria->compare('utilizado',$this->utilizado);
		$criteria->compare('total',$this->total);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('vigencia',$this->vigencia,true);
		$criteria->compare('estatus',$this->estatus,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}