<?php

/**
 * This is the model class for table "{{allotment}}".
 *
 * The followings are the available columns in table '{{allotment}}':
 * @property integer $id
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $id_hotel
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 * @property AllotmentDesglose[] $allotmentDesgloses
 */
class Allotment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Allotment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{allotment}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_inicio, fecha_final, id_hotel', 'required'),
			array('id_hotel', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, fecha_inicio, fecha_final, id_hotel', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
			'allotmentDesgloses' => array(self::HAS_MANY, 'AllotmentDesglose', 'id_allotment'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'id_hotel' => 'Hotel',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		if(!empty($this->fecha_inicio))$criteria->addCondition('fecha_inicio between "'.$this->fecha_inicio.'" and "'.$this->fecha_final.'"');
		$criteria->addCondition('id_hotel='.$_GET['id']);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
			'sort'=>array('defaultOrder'=>'fecha_inicio DESC'),
		));
	}
}