<?php

/**
 * This is the model class for table "{{allotment_desglose}}".
 *
 * The followings are the available columns in table '{{allotment_desglose}}':
 * @property integer $id
 * @property integer $id_allotment
 * @property string $id_tipo_habitacion
 * @property integer $maximo
 * @property integer $disponibles
 *
 * The followings are the available model relations:
 * @property TipoHabitaciones $idTipoHabitacion
 * @property Allotment $idAllotment
 */
class AllotmentDesglose extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return AllotmentDesglose the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{allotment_desglose}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_allotment, id_tipo_habitacion, maximo', 'required'),
			array('id_allotment, maximo', 'numerical', 'integerOnly'=>true),
			array('id_tipo_habitacion', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_allotment, id_tipo_habitacion, maximo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
			'idAllotment' => array(self::BELONGS_TO, 'Allotment', 'id_allotment'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_allotment' => 'Id Allotment',
			'id_tipo_habitacion' => 'Tipo Habitación',
			'maximo' => 'Allotments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_allotment',$this->id_allotment);
		$criteria->compare('id_tipo_habitacion',$this->id_tipo_habitacion,true);
		$criteria->compare('maximo',$this->maximo);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}