<?php



/**

 * This is the model class for table "{{api}}".

 *

 * The followings are the available columns in table '{{api}}':

 * @property integer $idApi

 * @property string $nombre

 * @property string $descripcion

 * @property string $code

 * @property string $markup

 * @property string $tipo_cambio

 * @property string $params

 */

class Api extends CActiveRecord

{

	/**

	 * Returns the static model of the specified AR class.

	 * @param string $className active record class name.

	 * @return Api the static model class

	 */

	public static function model($className=__CLASS__)

	{

		return parent::model($className);

	}



	/**

	 * @return string the associated database table name

	 */

	public function tableName()

	{

		return '{{api}}';

	}



	/**

	 * @return array validation rules for model attributes.

	 */

	public function rules()

	{

		// NOTE: you should only define rules for those attributes that

		// will receive user inputs.

		return array(

			array('nombre, descripcion, code, markup, tipo_cambio, params', 'required'),

			array('nombre', 'length', 'max'=>200),

			array('code', 'length', 'max'=>5),

			array('markup, tipo_cambio', 'length', 'max'=>10),

			array('proveedor', 'numerical'),


			// The following rule is used by search().

			// Please remove those attributes that should not be searched.

			array('idApi, nombre, descripcion, code, markup, tipo_cambio, params', 'safe', 'on'=>'search'),

		);

	}



	/**

	 * @return array relational rules.

	 */

	public function relations()

	{

		// NOTE: you may need to adjust the relation name and the related

		// class name for the relations automatically generated below.

		return array(

		);

	}



	/**

	 * @return array customized attribute labels (name=>label)

	 */

	public function attributeLabels()

	{

		return array(

			'idApi' => 'Id Api',

			'nombre' => 'Nombre',

			'descripcion' => 'Descripcion',

			'code' => 'Code',

			'markup' => 'Markup',

			'tipo_cambio' => 'Tipo Cambio',

			'params' => 'Params',

			'proveedor' => 'Proveedor'
			

		);

	}



	/**

	 * Retrieves a list of models based on the current search/filter conditions.

	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.

	 */

	public function search()

	{

		// Warning: Please modify the following code to remove attributes that

		// should not be searched.



		$criteria=new CDbCriteria;



		$criteria->compare('idApi',$this->idApi);

		$criteria->compare('nombre',$this->nombre,true);

		$criteria->compare('descripcion',$this->descripcion,true);

		$criteria->compare('code',$this->code,true);

		$criteria->compare('markup',$this->markup,true);

		$criteria->compare('tipo_cambio',$this->tipo_cambio,true);

		$criteria->compare('params',$this->params,true);



		return new CActiveDataProvider($this, array(

			'criteria'=>$criteria,

		));

	}

}