<?php

/**
 * This is the model class for table "{{apidestinosrel}}".
 *
 * The followings are the available columns in table '{{apidestinosrel}}':
 * @property integer $idApiDestRel
 * @property string $idDestino
 * @property integer $idApi
 * @property string $code
 *
 * The followings are the available model relations:
 * @property Api $idApi0
 * @property Destinos $idDestino0
 */
class Apidestinosrel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblApidestinosrel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{apidestinosrel}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('idDestino, idApi, code', 'required'),
			array('idApi', 'numerical', 'integerOnly'=>true),
			array('idDestino', 'length', 'max'=>11),
			array('code', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idApiDestRel, idDestino, idApi, code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idApi0' => array(self::BELONGS_TO, 'Api', 'idApi'),
			'idDestino0' => array(self::BELONGS_TO, 'Destinos', 'idDestino'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idApiDestRel' => 'Id Api Dest Rel',
			'idDestino' => 'Id Destino',
			'idApi' => 'Id Api',
			'code' => 'Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idApiDestRel',$this->idApiDestRel);
		$criteria->compare('idDestino',$this->idDestino,true);
		$criteria->compare('idApi',$this->idApi);
		$criteria->compare('code',$this->code,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}