<?php

/**
 * This is the model class for table "{{apihotelesrel}}".
 *
 * The followings are the available columns in table '{{apihotelesrel}}':
 * @property integer $idApiHotelRel
 * @property string $idHotel
 * @property integer $idApi
 * @property string $code
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel0
 * @property Api $idApi0
 */
class Apihotelesrel extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Apihotelesrel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{apihotelesrel}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('idHotel, idApi, code', 'required'),
			array('idApi', 'numerical', 'integerOnly'=>true),
			array('idHotel', 'length', 'max'=>11),
			array('code', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idApiHotelRel, idHotel, idApi, code', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel0' => array(self::BELONGS_TO, 'Hoteles', 'idHotel'),
			'idApi0' => array(self::BELONGS_TO, 'Api', 'idApi'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idApiHotelRel' => 'Id Api Hotel Rel',
			'idHotel' => 'Id Hotel',
			'idApi' => 'Id Api',
			'code' => 'Code',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idApiHotelRel',$this->idApiHotelRel);
		$criteria->compare('idHotel',$this->idHotel,true);
		$criteria->compare('idApi',$this->idApi);
		$criteria->compare('code',$this->code,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}