<?php

/**
 * This is the model class for table "tbl_base_habitacion".
 *
 * The followings are the available columns in table 'tbl_base_habitacion':
 * @property string $id_base_habitacion
 * @property string $base_habitacion
 * @property string $descripcion
 * @property integer $num_adultos
 * @property integer $estatus
 * @property string $log
 *
 * The followings are the available model relations:
 * @property PreciosDestino[] $preciosDestinos
 * @property ReservacionDesglose[] $reservacionDesgloses
 * @property TarifaDesglose[] $tarifaDesgloses
 */
class BaseHabitaciones extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return BaseHabitaciones the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_base_habitacion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('base_habitacion, descripcion, log', 'required'),
			array('num_adultos, estatus', 'numerical', 'integerOnly'=>true),
			array('base_habitacion', 'length', 'max'=>45),
			array('descripcion', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_base_habitacion, base_habitacion, descripcion, num_adultos, estatus, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'preciosDestinos' => array(self::HAS_MANY, 'PreciosDestino', 'id_base_habitacion'),
			'ocupacion' => array(self::HAS_ONE, 'Ocupaciones', 'id_base_habitacion'),
			'tarifaDesgloses' => array(self::HAS_MANY, 'TarifaDesglose', 'id_base_habitacion'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_base_habitacion' => 'Id Base Habitacion',
			'base_habitacion' => 'Base Habitacion',
			'descripcion' => 'Descripcion',
			'num_adultos' => 'Num Adultos',
			'estatus' => 'Estatus',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_base_habitacion',$this->id_base_habitacion,true);
		$criteria->compare('base_habitacion',$this->base_habitacion,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('num_adultos',$this->num_adultos);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}