<?php

/**
 * This is the model class for table "{{carrito}}".
 *
 * The followings are the available columns in table '{{carrito}}':
 * @property integer $id_producto
 * @property integer $cantidad
 * @property double $precio
 * @property double $importe
 * @property integer $id_user
 */
class Carrito extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Carrito the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{carrito}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_producto, cantidad, precio, importe, id_user', 'required'),
			array('id_producto, cantidad, id_user', 'numerical', 'integerOnly'=>true),
			array('precio, importe', 'numerical'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_producto, cantidad, precio, importe, id_user', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idproducto' => array(self::BELONGS_TO, 'CatServicios', 'id_producto'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_producto' => 'Id Producto',
			'cantidad' => 'Cantidad',
			'precio' => 'Precio',
			'importe' => 'Importe',
			'id_user' => 'Id User',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_producto',$this->id_producto);
		$criteria->compare('cantidad',$this->cantidad);
		$criteria->compare('precio',$this->precio);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('id_user',$this->id_user);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}