<?php

/**
 * This is the model class for table "{{categorias}}".
 *
 * The followings are the available columns in table '{{categorias}}':
 * @property integer $id_categoria
 * @property string $categoria
 * @property string $log
 * @property integer $estatus
 */
class Categorias extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Categorias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{categorias}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('categoria', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('categoria', 'length', 'max'=>45),
			array('log', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_categoria, categoria, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_categoria' => 'Id Categoria',
			'categoria' => 'Categoria',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_categoria',$this->id_categoria);
		$criteria->compare('categoria',$this->categoria,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}	
}