<?php

/**
 * This is the model class for table "tbl_colonia".
 *
 * The followings are the available columns in table 'tbl_colonia':
 * @property integer $id_colonia
 * @property integer $id_ciudad
 * @property string $cp
 * @property integer $id_tipocolonia
 * @property string $nombrecolonia
 * @property string $registro
 */
class Colonias extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Colonias the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_colonia';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_ciudad, id_tipocolonia, registro', 'required'),
			array('id_ciudad, id_tipocolonia', 'numerical', 'integerOnly'=>true),
			array('cp', 'length', 'max'=>45),
			array('nombrecolonia', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_colonia, id_ciudad, cp, id_tipocolonia, nombrecolonia, registro', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_colonia' => 'Id Colonia',
			'id_ciudad' => 'Id Ciudad',
			'cp' => 'Cp',
			'id_tipocolonia' => 'Id Tipocolonia',
			'nombrecolonia' => 'Nombrecolonia',
			'registro' => 'Registro',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_colonia',$this->id_colonia);
		$criteria->compare('id_ciudad',$this->id_ciudad);
		$criteria->compare('cp',$this->cp,true);
		$criteria->compare('id_tipocolonia',$this->id_tipocolonia);
		$criteria->compare('nombrecolonia',$this->nombrecolonia,true);
		$criteria->compare('registro',$this->registro,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}