<?php

/**
 * This is the model class for table "{{comentarios}}".
 *
 * The followings are the available columns in table '{{comentarios}}':
 * @property integer $id_comentario
 * @property string $comentario
 * @property integer $id_referencia
 * @property string $tipo_referencia
 * @property string $id_usuario
 * @property string $log
 *
 * The followings are the available model relations:
 * @property Usuarios $idUsuario
 */
class Comentarios extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Comentarios the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comentarios}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('comentario, id_referencia, tipo_referencia, id_usuario', 'required'),
			array('id_referencia', 'numerical', 'integerOnly'=>true),
			array('comentario', 'length', 'max'=>255),
			array('tipo_referencia', 'length', 'max'=>3),
			array('id_usuario', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_comentario, comentario, id_referencia, tipo_referencia, id_usuario, log', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_comentario' => 'Id Comentario',
			'comentario' => 'Comentario',
			'id_referencia' => 'Id Referencia',
			'tipo_referencia' => 'Tipo Referencia',
			'id_usuario' => 'Id Usuario',
			'log' => 'Log',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_comentario',$this->id_comentario);
		$criteria->compare('comentario',$this->comentario,true);
		$criteria->compare('id_referencia',$this->id_referencia);
		$criteria->compare('tipo_referencia',$this->tipo_referencia,true);
		$criteria->compare('id_usuario',$this->id_usuario,true);
		$criteria->compare('log',$this->log,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}