<?php

/**
 * This is the model class for table "{{comision_agencia}}".
 *
 * The followings are the available columns in table '{{comision_agencia}}':
 * @property integer $id
 * @property string $id_reservacion
 * @property integer $id_tipo_pago
 * @property integer $id_cuenta
 * @property integer $no_referencia
 * @property double $importe
 * @property string $id_user
 * @property string $fecha
 * @property string $estado
 *
 * The followings are the available model relations:
 * @property Usuarios $idUser
 * @property Reservacion $idReservacion
 * @property TipoPago $idTipoPago
 * @property Cuenta $idCuenta
 */
class ComisionAgencia extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ComisionAgencia the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comision_agencia}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_reservacion, importe, id_user', 'required'),
			array('id_tipo_pago, id_cuenta, no_referencia', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('id_reservacion, id_user', 'length', 'max'=>10),
			array('estado', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_reservacion, id_tipo_pago, id_cuenta, no_referencia, importe, id_user, fecha, fecha_pago, estado', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idUser' => array(self::BELONGS_TO, 'Usuarios', 'id_user'),
			'idReservacion' => array(self::BELONGS_TO, 'Reservacion', 'id_reservacion'),
			'idTipoPago' => array(self::BELONGS_TO, 'TipoPago', 'id_tipo_pago'),
			'idCuenta' => array(self::BELONGS_TO, 'Cuenta', 'id_cuenta'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_reservacion' => 'Id Reservacion',
			'id_tipo_pago' => 'Id Tipo Pago',
			'id_cuenta' => 'Id Cuenta',
			'no_referencia' => 'No Referencia',
			'importe' => 'Importe',
			'id_user' => 'Id User',
			'fecha' => 'Fecha',
			'fecha_pago' => 'Fecha Pago',
			'estado' => 'Estado',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_reservacion',$this->id_reservacion,true);
		$criteria->compare('id_tipo_pago',$this->id_tipo_pago);
		$criteria->compare('id_cuenta',$this->id_cuenta);
		$criteria->compare('no_referencia',$this->no_referencia);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('id_user',$this->id_user,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('estado',$this->estado,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}