<?php

/**
 * This is the model class for table "{{comisiones_banco}}".
 *
 * The followings are the available columns in table '{{comisiones_banco}}':
 * @property string $id_comision
 * @property string $tarjeta
 * @property string $banco
 * @property string $comison
 * @property integer $tipo
 * @property integer $estatus
 */
class ComisionesBanco extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ComisionesBanco the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{comisiones_banco}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tarjeta, banco', 'required'),
			array('tipo, estatus', 'numerical', 'integerOnly'=>true),
			array('tarjeta', 'length', 'max'=>16),
			array('banco', 'length', 'max'=>255),
			array('comison', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_comision, tarjeta, banco, comison, tipo, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_comision' => 'Id Comision',
			'tarjeta' => 'Tarjeta',
			'banco' => 'Banco',
			'comison' => 'Comison',
			'tipo' => 'Tipo',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_comision',$this->id_comision,true);
		$criteria->compare('tarjeta',$this->tarjeta,true);
		$criteria->compare('banco',$this->banco,true);
		$criteria->compare('comison',$this->comison,true);
		$criteria->compare('tipo',$this->tipo);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	public function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}	
	public function tipo($x){
		switch($x){
			case 0: $y="Pesos ($)"; break;
			case 1: $y="Porcentaje (%)"; break;
		}
		return $y;
	}	
}