<?php

/**
 * This is the model class for table "{{contratos}}".
 *
 * The followings are the available columns in table '{{contratos}}':
 * @property string $id_contrato
 * @property string $titulo
 * @property string $id_hotel
 * @property string $fecha_inicial
 * @property string $fecha_final
 * @property string $promocion
 * @property string $archivo
 */
class Contratos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Contratos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contratos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('titulo, id_hotel, fecha_inicial, fecha_final, promocion, archivo', 'required'),
			array('titulo, promocion, archivo', 'length', 'max'=>255),
			array('id_hotel', 'length', 'max'=>10),
			array('archivo', 'length', 'max'=>255, 'on'=>'insert,update'),
			array('archivo', 'file','types'=>'pdf, doc, docx', 'allowEmpty'=>true, 'on'=>'update'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_contrato, titulo, id_hotel, fecha_inicial, fecha_final, promocion, archivo', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);

	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_contrato' => 'Id Contrato',
			'titulo' => 'Titulo',
			'id_hotel' => 'Hotel',
			'fecha_inicial' => 'Fecha Inicial',
			'fecha_final' => 'Fecha Final',
			'promocion' => 'Promocion',
			'archivo' => 'Archivo',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_contrato',$this->id_contrato,true);
		$criteria->compare('titulo',$this->titulo,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('fecha_inicial',$this->fecha_inicial,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('promocion',$this->promocion,true);
		$criteria->compare('archivo',$this->archivo,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
	
	public static function promocion($x){
		switch($x){
			case'promocion': $y= 'Promocion';break;
			case 'normal' : $y= 'Normal';break;
			case 'bloqueos' : $y='Bloqueos';break;
			case 'grupos' : $y='Grupos';break;
			case 'otros': $y='Otros';break;
		}
		return $y;
	}	
}