<?php

/**
 * This is the model class for table "{{contratos_bloqueos}}".
 *
 * The followings are the available columns in table '{{contratos_bloqueos}}':
 * @property integer $id
 * @property string $nombre
 * @property string $id_hotel
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property double $importe
 * @property string $observaciones
 *
 * The followings are the available model relations:
 * @property Hoteles $idHotel
 */
class ContratosBloqueos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ContratosBloqueos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contratos_bloqueos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, id_hotel, fecha_inicio, fecha_final, habs, habs_promo, importe', 'required'),
			array('habs, habs_promo', 'numerical', 'integerOnly'=>true),
			array('importe, importe_cortesia', 'numerical'),
			array('nombre, comprobante', 'length', 'max'=>255),
			array('id_hotel', 'length', 'max'=>10),
			array('observaciones', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, nombre, id_hotel, fecha_inicio, fecha_final, habs, habs_promo, importe, importe_cortesia, observaciones, comprobante', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idHotel' => array(self::BELONGS_TO, 'Hoteles', 'id_hotel'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'nombre' => 'Nombre',
			'id_hotel' => 'Id Hotel',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'habs' => 'Habitaciones',
			'habs_promo' => 'Habs. Cortesía',
			'importe' => 'Importe',
			'importe_cortesia' => 'Importe de Cortesía',
			'observaciones' => 'Observaciones',
			'comprobante' => 'Documento',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('id_hotel',$this->id_hotel,true);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('habs',$this->habs);
		$criteria->compare('habs_promo',$this->habs_promo);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('importe_cortesia',$this->importe);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('comprobante',$this->comprobante,true);		

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}