<?php

/**
 * This is the model class for table "{{contratos_extras}}".
 *
 * The followings are the available columns in table '{{contratos_extras}}':
 * @property integer $id
 * @property integer $id_contrato
 * @property string $nombre
 * @property string $descripcion
 * @property double $importe
 *
 * The followings are the available model relations:
 * @property ContratosBloqueos $idContrato
 */
class ContratosExtras extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return ContratosExtras the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{contratos_extras}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_contrato, nombre, importe', 'required'),
			array('id_contrato', 'numerical', 'integerOnly'=>true),
			array('importe', 'numerical'),
			array('nombre', 'length', 'max'=>255),
			array('descripcion', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, id_contrato, nombre, descripcion, importe', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idContrato' => array(self::BELONGS_TO, 'ContratosBloqueos', 'id_contrato'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'id_contrato' => 'Contrato',
			'nombre' => 'Nombre',
			'descripcion' => 'Descripción',
			'importe' => 'Importe',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('id_contrato',$this->id_contrato);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('descripcion',$this->descripcion,true);
		$criteria->compare('importe',$this->importe);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}