<?php

/**
 * This is the model class for table "{{dashboard}}".
 *
 * The followings are the available columns in table '{{dashboard}}':
 * @property integer $idDashboard
 * @property integer $id_usuario
 * @property string $dashboard
 */
class Dashboard extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Dashboard the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{dashboard}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_usuario, dashboard', 'required'),
			array('id_usuario', 'numerical', 'integerOnly'=>true),
			array('dashboard', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('idDashboard, id_usuario, dashboard', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
				'idUsuario' => array(self::BELONGS_TO, 'Usuarios', 'id_usuario'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idDashboard' => 'Id Dashboard',
			'id_usuario' => 'Id Usuario',
			'dashboard' => 'Dashboard',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('idDashboard',$this->idDashboard);
		$criteria->compare('id_usuario',$this->id_usuario);
		$criteria->compare('dashboard',$this->dashboard,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}