<?php

/**
 * This is the model class for table "{{destinos}}".
 *
 * The followings are the available columns in table '{{destinos}}':
 * @property string $id_destino
 * @property string $destino
 * @property string $log
 * @property integer $estatus
 *
 * The followings are the available model relations:
 * @property HotelesDestinos[] $hotelesDestinoses
 * @property PreciosDestino[] $preciosDestinos
 */
class DestinosTours extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Destinos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{destinos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('destino', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('destino', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_destino, destino, log, estatus', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tours' => array(self::HAS_MANY, 'Tour', 'id_destino', 'joinType'=>'INNER JOIN'),
			
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_destino' => 'Id Destino',
			'destino' => 'Destino',
			'log' => 'Log',
			'estatus' => 'Estatus',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_destino',$this->id_destino,true);
		$criteria->compare('destino',$this->destino,true);
		$criteria->compare('log',$this->log,true);
		$criteria->compare('estatus',$this->estatus);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}
}