<?php

/**
 * This is the model class for table "{{empresas}}".
 *
 * The followings are the available columns in table '{{empresas}}':
 * @property string $id_empresa
 * @property string $razon_social
 * @property string $rfc
 * @property string $calle
 * @property string $num_exte
 * @property string $num_int
 * @property string $referencia
 * @property string $colonia
 * @property string $cp
 * @property string $localidad
 * @property string $ciudad
 * @property string $estado
 * @property string $pais
 * @property integer $estatus
 * @property string $regimen
 */
class Empresas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Empresas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{empresas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('razon_social, rfc', 'required'),
			array('estatus', 'numerical', 'integerOnly'=>true),
			array('razon_social, referencia, colonia, localidad, ciudad, estado, pais, regimen', 'length', 'max'=>255),
			array('rfc', 'length', 'max'=>15),
			array('calle, num_exte, num_int, cp', 'length', 'max'=>45),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_empresa, razon_social, rfc, calle, num_exte, num_int, referencia, colonia, cp, localidad, ciudad, estado, pais, estatus, regimen', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_empresa' => 'Id Empresa',
			'razon_social' => 'Razon Social',
			'rfc' => 'Rfc',
			'calle' => 'Calle',
			'num_exte' => 'Num Exte',
			'num_int' => 'Num Int',
			'referencia' => 'Referencia',
			'colonia' => 'Colonia',
			'cp' => 'Cp',
			'localidad' => 'Localidad',
			'ciudad' => 'Ciudad',
			'estado' => 'Estado',
			'pais' => 'Pais',
			'estatus' => 'Estatus',
			'regimen' => 'Regimen',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_empresa',$this->id_empresa,true);
		$criteria->compare('razon_social',$this->razon_social,true);
		$criteria->compare('rfc',$this->rfc,true);
		$criteria->compare('calle',$this->calle,true);
		$criteria->compare('num_exte',$this->num_exte,true);
		$criteria->compare('num_int',$this->num_int,true);
		$criteria->compare('referencia',$this->referencia,true);
		$criteria->compare('colonia',$this->colonia,true);
		$criteria->compare('cp',$this->cp,true);
		$criteria->compare('localidad',$this->localidad,true);
		$criteria->compare('ciudad',$this->ciudad,true);
		$criteria->compare('estado',$this->estado,true);
		$criteria->compare('pais',$this->pais,true);
		$criteria->compare('estatus',$this->estatus);
		$criteria->compare('regimen',$this->regimen,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
		public function estatus($x){
		switch($x){
			case 0: $y="Inactivo"; break;
			case 1: $y="Activo"; break;
		}
		return $y;
	}	
}