<?php

/**
 * This is the model class for table "tbl_estadosmex".
 *
 * The followings are the available columns in table 'tbl_estadosmex':
 * @property integer $id_estadosmex
 * @property string $claveestado
 * @property string $nombreestado
 * @property string $registro
 * @property string $id_pais
 */
class Estados extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Estados the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_estadosmex';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('registro', 'required'),
			array('claveestado', 'length', 'max'=>15),
			array('nombreestado', 'length', 'max'=>150),
			array('id_pais', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_estadosmex, claveestado, nombreestado, registro, id_pais', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_estadosmex' => 'Id Estadosmex',
			'claveestado' => 'Claveestado',
			'nombreestado' => 'Nombreestado',
			'registro' => 'Registro',
			'id_pais' => 'Id Pais',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_estadosmex',$this->id_estadosmex);
		$criteria->compare('claveestado',$this->claveestado,true);
		$criteria->compare('nombreestado',$this->nombreestado,true);
		$criteria->compare('registro',$this->registro,true);
		$criteria->compare('id_pais',$this->id_pais,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}