<?php

/**
 * This is the model class for table "{{events}}".
 *
 * The followings are the available columns in table '{{events}}':
 * @property integer $id_event
 * @property string $nombre_evento
 * @property integer $id_tipo_evento
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property string $hora
 * @property string $lugar
 * @property string $direccion
 * @property string $observaciones
 * @property string $logo
 * @property string $flyer
 * @property string $landing_page
 *
 * The followings are the available model relations:
 * @property EventType $idTipoEvento
 * @property EventsGuests[] $eventsGuests
 * @property ParticipateProvider[] $participateProviders
 * @property Tasks[] $tasks
 */
class Events extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Events the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{events}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre_evento, id_tipo_evento, fecha_inicio', 'required'),
			array('id_tipo_evento', 'numerical', 'integerOnly'=>true),
			array('nombre_evento', 'length', 'max'=>50),
			array('lugar, observaciones, landing_page', 'length', 'max'=>255),
			array('direccion', 'length', 'max'=>150),
			array('logo, flyer', 'length', 'max'=>100),
			array('fecha_final, hora', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_event, nombre_evento, id_tipo_evento, fecha_inicio, fecha_final, hora, lugar, direccion, observaciones, logo, flyer, landing_page', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoEvento' => array(self::BELONGS_TO, 'EventType', 'id_tipo_evento'),
			'eventsGuests' => array(self::HAS_MANY, 'EventsGuests', 'id_event'),
			'participateProviders' => array(self::HAS_MANY, 'ParticipateProvider', 'id_evento'),
			'tasks' => array(self::HAS_MANY, 'Tasks', 'id_evento'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_event' => 'Id Event',
			'nombre_evento' => 'Nombre Evento',
			'id_tipo_evento' => 'Id Tipo Evento',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'hora' => 'Hora',
			'lugar' => 'Lugar',
			'direccion' => 'Direccion',
			'observaciones' => 'Observaciones',
			'logo' => 'Logo',
			'flyer' => 'Flyer',
			'landing_page' => 'Landing Page',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_event',$this->id_event);
		$criteria->compare('nombre_evento',$this->nombre_evento,true);
		$criteria->compare('id_tipo_evento',$this->id_tipo_evento);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('hora',$this->hora,true);
		$criteria->compare('lugar',$this->lugar,true);
		$criteria->compare('direccion',$this->direccion,true);
		$criteria->compare('observaciones',$this->observaciones,true);
		$criteria->compare('logo',$this->logo,true);
		$criteria->compare('flyer',$this->flyer,true);
		$criteria->compare('landing_page',$this->landing_page,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}