<?php

/**
 * This is the model class for table "{{fe_facturas}}".
 *
 * The followings are the available columns in table '{{fe_facturas}}':
 * @property string $id_factura
 * @property string $fecha_creacion
 * @property string $folio
 * @property string $serie
 * @property string $fecha
 * @property string $moneda
 * @property string $forma_pago
 * @property string $metodo_pago
 * @property string $tipo_cambio
 * @property string $condiciones_pago
 * @property integer $id_agencia
 * @property string $receptor_rfc
 * @property string $receptor_razon_social
 * @property string $receptor_calle
 * @property string $receptor_no_exterior
 * @property string $receptor_no_interior
 * @property string $receptor_colonia
 * @property string $receptor_referencia
 * @property string $receptor_estado
 * @property string $receptor_cp
 * @property string $receptor_municipio
 * @property string $receptor_localidad
 * @property string $receptor_pais
 * @property string $id_receptor
 * @property double $importe
 * @property double $descuento_porcentaje
 * @property double $descuento_importe
 * @property double $iva_porcentaje
 * @property double $subtotal
 * @property double $iva
 * @property double $total
 * @property string $descuento_motivo
 * @property string $importe_letras
 * @property string $ruta_local_xml
 * @property string $ruta_local_pdf
 * @property string $ruta_ftp_xml
 * @property string $ruta_ftp_pdf
 * @property string $estatus
 * @property string $uuid_certificacion
 * @property string $fecha_certificacion
 * @property string $lugar_expedicion
 * @property string $num_cta_pago
 * @property string $original_folio
 * @property string $original_serie
 * @property string $original_fecha
 * @property double $original_monto
 * @property string $emisor_regimen
 * @property string $tipo_comprobante
 *
 * The followings are the available model relations:
 * @property FeFacturaRecibo[] $feFacturaRecibos
 */
class FeFacturas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FeFacturas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fe_facturas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_creacion, fecha, moneda, forma_pago, metodo_pago, id_agencia, receptor_rfc, receptor_razon_social, importe, iva_porcentaje, subtotal, iva, total', 'required'),
			array('id_agencia', 'numerical', 'integerOnly'=>true),
			array('importe, descuento_porcentaje, descuento_importe, iva_porcentaje, subtotal, iva, total, original_monto', 'numerical'),
			array('folio, receptor_calle, receptor_no_exterior, receptor_no_interior, receptor_pais, original_folio', 'length', 'max'=>20),
			array('serie, original_serie', 'length', 'max'=>5),
			array('fecha, fecha_certificacion, original_fecha', 'length', 'max'=>19),
			array('moneda, tipo_cambio, receptor_cp', 'length', 'max'=>15),
			array('forma_pago, metodo_pago, receptor_estado, tipo_comprobante', 'length', 'max'=>60),
			array('condiciones_pago, receptor_colonia, receptor_referencia, receptor_municipio, receptor_localidad', 'length', 'max'=>120),
			array('receptor_rfc', 'length', 'max'=>13),
			array('receptor_razon_social, importe_letras', 'length', 'max'=>200),
			array('id_receptor', 'length', 'max'=>10),
			array('descuento_motivo', 'length', 'max'=>100),
			array('ruta_local_xml, ruta_local_pdf, ruta_ftp_xml, ruta_ftp_pdf, lugar_expedicion, num_cta_pago, emisor_regimen', 'length', 'max'=>300),
			array('estatus', 'length', 'max'=>1),
			array('uuid_certificacion', 'length', 'max'=>50),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_factura, fecha_creacion, folio, serie, fecha, moneda, forma_pago, metodo_pago, tipo_cambio, condiciones_pago, id_agencia, receptor_rfc, receptor_razon_social, receptor_calle, receptor_no_exterior, receptor_no_interior, receptor_colonia, receptor_referencia, receptor_estado, receptor_cp, receptor_municipio, receptor_localidad, receptor_pais, id_receptor, importe, descuento_porcentaje, descuento_importe, iva_porcentaje, subtotal, iva, total, descuento_motivo, importe_letras, ruta_local_xml, ruta_local_pdf, ruta_ftp_xml, ruta_ftp_pdf, estatus, uuid_certificacion, fecha_certificacion, lugar_expedicion, num_cta_pago, original_folio, original_serie, original_fecha, original_monto, emisor_regimen, tipo_comprobante', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'feFacturaRecibos' => array(self::HAS_MANY, 'FeFacturaRecibo', 'id_factura'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_factura' => 'Id Factura',
			'fecha_creacion' => 'Fecha Creacion',
			'folio' => 'Folio',
			'serie' => 'Serie',
			'fecha' => 'Fecha',
			'moneda' => 'Moneda',
			'forma_pago' => 'Forma Pago',
			'metodo_pago' => 'Metodo Pago',
			'tipo_cambio' => 'Tipo Cambio',
			'condiciones_pago' => 'Condiciones Pago',
			'id_agencia' => 'Id Agencia',
			'receptor_rfc' => 'Receptor Rfc',
			'receptor_razon_social' => 'Receptor Razon Social',
			'receptor_calle' => 'Receptor Calle',
			'receptor_no_exterior' => 'Receptor No Exterior',
			'receptor_no_interior' => 'Receptor No Interior',
			'receptor_colonia' => 'Receptor Colonia',
			'receptor_referencia' => 'Receptor Referencia',
			'receptor_estado' => 'Receptor Estado',
			'receptor_cp' => 'Receptor Cp',
			'receptor_municipio' => 'Receptor Municipio',
			'receptor_localidad' => 'Receptor Localidad',
			'receptor_pais' => 'Receptor Pais',
			'id_receptor' => 'Id Receptor',
			'importe' => 'Importe',
			'descuento_porcentaje' => 'Descuento Porcentaje',
			'descuento_importe' => 'Descuento Importe',
			'iva_porcentaje' => 'Iva Porcentaje',
			'subtotal' => 'Subtotal',
			'iva' => 'Iva',
			'total' => 'Total',
			'descuento_motivo' => 'Descuento Motivo',
			'importe_letras' => 'Importe Letras',
			'ruta_local_xml' => 'Ruta Local Xml',
			'ruta_local_pdf' => 'Ruta Local Pdf',
			'ruta_ftp_xml' => 'Ruta Ftp Xml',
			'ruta_ftp_pdf' => 'Ruta Ftp Pdf',
			'estatus' => 'Estatus',
			'uuid_certificacion' => 'Uuid Certificacion',
			'fecha_certificacion' => 'Fecha Certificacion',
			'lugar_expedicion' => 'Lugar Expedicion',
			'num_cta_pago' => 'Num Cta Pago',
			'original_folio' => 'Original Folio',
			'original_serie' => 'Original Serie',
			'original_fecha' => 'Original Fecha',
			'original_monto' => 'Original Monto',
			'emisor_regimen' => 'Emisor Regimen',
			'tipo_comprobante' => 'Tipo Comprobante',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_factura',$this->id_factura,true);
		$criteria->compare('fecha_creacion',$this->fecha_creacion,true);
		$criteria->compare('folio',$this->folio,true);
		$criteria->compare('serie',$this->serie,true);
		$criteria->compare('fecha',$this->fecha,true);
		$criteria->compare('moneda',$this->moneda,true);
		$criteria->compare('forma_pago',$this->forma_pago,true);
		$criteria->compare('metodo_pago',$this->metodo_pago,true);
		$criteria->compare('tipo_cambio',$this->tipo_cambio,true);
		$criteria->compare('condiciones_pago',$this->condiciones_pago,true);
		$criteria->compare('id_agencia',$this->id_agencia);
		$criteria->compare('receptor_rfc',$this->receptor_rfc,true);
		$criteria->compare('receptor_razon_social',$this->receptor_razon_social,true);
		$criteria->compare('receptor_calle',$this->receptor_calle,true);
		$criteria->compare('receptor_no_exterior',$this->receptor_no_exterior,true);
		$criteria->compare('receptor_no_interior',$this->receptor_no_interior,true);
		$criteria->compare('receptor_colonia',$this->receptor_colonia,true);
		$criteria->compare('receptor_referencia',$this->receptor_referencia,true);
		$criteria->compare('receptor_estado',$this->receptor_estado,true);
		$criteria->compare('receptor_cp',$this->receptor_cp,true);
		$criteria->compare('receptor_municipio',$this->receptor_municipio,true);
		$criteria->compare('receptor_localidad',$this->receptor_localidad,true);
		$criteria->compare('receptor_pais',$this->receptor_pais,true);
		$criteria->compare('id_receptor',$this->id_receptor,true);
		$criteria->compare('importe',$this->importe);
		$criteria->compare('descuento_porcentaje',$this->descuento_porcentaje);
		$criteria->compare('descuento_importe',$this->descuento_importe);
		$criteria->compare('iva_porcentaje',$this->iva_porcentaje);
		$criteria->compare('subtotal',$this->subtotal);
		$criteria->compare('iva',$this->iva);
		$criteria->compare('total',$this->total);
		$criteria->compare('descuento_motivo',$this->descuento_motivo,true);
		$criteria->compare('importe_letras',$this->importe_letras,true);
		$criteria->compare('ruta_local_xml',$this->ruta_local_xml,true);
		$criteria->compare('ruta_local_pdf',$this->ruta_local_pdf,true);
		$criteria->compare('ruta_ftp_xml',$this->ruta_ftp_xml,true);
		$criteria->compare('ruta_ftp_pdf',$this->ruta_ftp_pdf,true);
		$criteria->compare('estatus',$this->estatus,true);
		$criteria->compare('uuid_certificacion',$this->uuid_certificacion,true);
		$criteria->compare('fecha_certificacion',$this->fecha_certificacion,true);
		$criteria->compare('lugar_expedicion',$this->lugar_expedicion,true);
		$criteria->compare('num_cta_pago',$this->num_cta_pago,true);
		$criteria->compare('original_folio',$this->original_folio,true);
		$criteria->compare('original_serie',$this->original_serie,true);
		$criteria->compare('original_fecha',$this->original_fecha,true);
		$criteria->compare('original_monto',$this->original_monto);
		$criteria->compare('emisor_regimen',$this->emisor_regimen,true);
		$criteria->compare('tipo_comprobante',$this->tipo_comprobante,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}