<?php

/**
 * This is the model class for table "{{fechas_bloqueadas}}".
 *
 * The followings are the available columns in table '{{fechas_bloqueadas}}':
 * @property integer $id_fecha
 * @property string $fecha_inicio
 * @property string $fecha_final
 * @property integer $id_tarifa
 */
class FechasBloqueadas extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FechasBloqueadas the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{fechas_bloqueadas}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('fecha_inicio, fecha_final, id_tarifa', 'required'),
			array('id_tarifa, id_tipo_habitacion', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_fecha, fecha_inicio, fecha_final, id_tarifa', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idTipoHabitacion' => array(self::BELONGS_TO, 'TipoHabitaciones', 'id_tipo_habitacion'),
			'idTarifa' => array(self::BELONGS_TO, 'Tarifa', 'id_tarifa'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_fecha' => 'Id Fecha',
			'fecha_inicio' => 'Fecha Inicio',
			'fecha_final' => 'Fecha Final',
			'id_tarifa' => 'Id Tarifa',
			'id_tipo_habitacion' => 'Tipo Habitación',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_fecha',$this->id_fecha);
		$criteria->compare('fecha_inicio',$this->fecha_inicio,true);
		$criteria->compare('fecha_final',$this->fecha_final,true);
		$criteria->compare('id_tarifa',$this->id_tarifa);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}