<?php

/**
 * This is the model class for table "{{file_grupos}}".
 *
 * The followings are the available columns in table '{{file_grupos}}':
 * @property integer $id_archivo
 * @property integer $id_grupos_cotizaciones
 * @property integer $id_file
 *
 * The followings are the available model relations:
 * @property GruposCotizaciones $idGruposCotizaciones
 * @property Files $idFile
 */
class FileGrupos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return FileGrupos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{file_grupos}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('id_grupos_cotizaciones, id_file', 'required'),
			array('id_grupos_cotizaciones, id_file', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_archivo, id_grupos_cotizaciones, id_file', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'idGruposCotizaciones' => array(self::BELONGS_TO, 'GruposCotizaciones', 'id_grupos_cotizaciones'),
			'idFile' => array(self::BELONGS_TO, 'Files', 'id_file'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_archivo' => 'Id Archivo',
			'id_grupos_cotizaciones' => 'Id Grupos Cotizaciones',
			'id_file' => 'Id File',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_archivo',$this->id_archivo);
		$criteria->compare('id_grupos_cotizaciones',$this->id_grupos_cotizaciones);
		$criteria->compare('id_file',$this->id_file);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}