<?php

/**
 * This is the model class for table "files".
 *
 * The followings are the available columns in table 'files':
 * @property integer $id_file
 * @property string $nombre
 * @property string $titulo
 * @property string $descrp
 * @property string $path
 * @property string $nombre_real
 * @property integer $status
 * @property integer $size
 */
class Files extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return Files the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{files}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('nombre, path, nombre_real, status, size', 'required'),
			array('size, status', 'numerical', 'integerOnly'=>true),
			array('titulo', 'length', 'max'=>250),
			array('nombre', 'length', 'max'=>100),
			array('path', 'length', 'max'=>250),
			array('nombre_real', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id_file, nombre, titulo, descrp, path, nombre_real, size, status', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id_file' => 'ID',
			'nombre' => 'Nombre del Archivo',
			'titulo' => 'Titulo',
			'descrp' => 'Descripción',
			'path' => 'Ruta',
			'nombre_real' => 'Nombre Real',
			'status' => 'Visible',
			'size' => 'Tamaño',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id_file',$this->id_file);
		$criteria->compare('nombre',$this->nombre,true);
		$criteria->compare('titulo',$this->nombre,true);
		$criteria->compare('descrp',$this->descrp,true);
		$criteria->compare('path',$this->path,true);
		$criteria->compare('nombre_real',$this->nombre_real,true);
		$criteria->compare('status',$this->status);
		$criteria->compare('size',$this->size);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}